/*
 * Decompiled with CFR 0.152.
 */
package savant.view.icon;

import javax.swing.ImageIcon;

public class SavantIconFactory {
    private static SavantIconFactory instance;

    private SavantIconFactory() {
    }

    public static SavantIconFactory getInstance() {
        if (instance == null) {
            instance = new SavantIconFactory();
        }
        return instance;
    }

    public ImageIcon getIcon(String resourcePath) {
        return new ImageIcon(this.getClass().getResource(resourcePath));
    }

    public ImageIcon getIcon(StandardIcon icon) {
        switch (icon) {
            case ADD: {
                return this.getIcon("/savant/images/icon/add.png");
            }
            case SAVE: {
                return this.getIcon("/savant/images/icon/save2.png");
            }
            case OPEN: {
                return this.getIcon("/savant/images/icon/open.png");
            }
            case COPY: {
                return this.getIcon("/savant/images/icon/copy2.png");
            }
            case CLOSE: {
                return this.getIcon("/savant/images/icon/close_red.png");
            }
            case DELETE: {
                return this.getIcon("/savant/images/icon/delete.png");
            }
            case GENOME: {
                return this.getIcon("/savant/images/icon/dna.png");
            }
            case RUN: {
                return this.getIcon("/savant/images/icon/run.png");
            }
            case UNDO: {
                return this.getIcon("/savant/images/icon/undo.png");
            }
            case REDO: {
                return this.getIcon("/savant/images/icon/redo.png");
            }
            case ZOOMIN: {
                return this.getIcon("/savant/images/icon/in.png");
            }
            case ZOOMOUT: {
                return this.getIcon("/savant/images/icon/out.png");
            }
            case SHIFT_FARLEFT: {
                return this.getIcon("/savant/images/icon/leftfull.png");
            }
            case SHIFT_FARRIGHT: {
                return this.getIcon("/savant/images/icon/rightfull.png");
            }
            case SHIFT_LEFT: {
                return this.getIcon("/savant/images/icon/left.png");
            }
            case SHIFT_RIGHT: {
                return this.getIcon("/savant/images/icon/right.png");
            }
            case STOP: {
                return this.getIcon("/savant/images/icon/stop.png");
            }
            case REFRESH: {
                return this.getIcon("/savant/images/icon/refresh.png");
            }
            case UP: {
                return this.getIcon("/savant/images/icon/up.png");
            }
            case DOWN: {
                return this.getIcon("/savant/images/icon/down.png");
            }
            case VIEW: {
                return this.getIcon("/savant/images/icon/view.png");
            }
            case FOLDER: {
                return this.getIcon("/savant/images/icon/folder.png");
            }
            case LOGO: {
                return this.getIcon("/savant/images/icon/savantlogo.png");
            }
            case TRACK: {
                return this.getIcon("/savant/images/icon/track.png");
            }
            case BKMK_ADD: {
                return this.getIcon("/savant/images/icon/bkm_add.png");
            }
            case BKMK_RM: {
                return this.getIcon("/savant/images/icon/bkm_rm.png");
            }
            case PLUGIN: {
                return this.getIcon("/savant/images/icon/plugin.png");
            }
            case CLOSE_DARK: {
                return this.getIcon("/savant/images/icon/close_dark.png");
            }
            case CLOSE_LIGHT: {
                return this.getIcon("/savant/images/icon/close_light.png");
            }
        }
        return null;
    }

    public static enum StandardIcon {
        ADD,
        SAVE,
        OPEN,
        COPY,
        CLOSE,
        DELETE,
        RUN,
        STOP,
        REFRESH,
        GENOME,
        UP,
        DOWN,
        UNDO,
        REDO,
        ZOOMIN,
        ZOOMOUT,
        SHIFT_FARLEFT,
        SHIFT_FARRIGHT,
        SHIFT_LEFT,
        SHIFT_RIGHT,
        VIEW,
        LOGO,
        TRACK,
        FOLDER,
        BKMK_ADD,
        BKMK_RM,
        PLUGIN,
        CLOSE_DARK,
        CLOSE_LIGHT;

    }
}

