/*
 * Decompiled with CFR 0.152.
 */
package savant.view.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.savant.analytics.savantanalytics.AnalyticsAgent;
import savant.api.data.DataFormat;
import savant.api.util.DialogUtils;
import savant.api.util.Resolution;
import savant.controller.GenomeController;
import savant.controller.LocationController;
import savant.data.sources.DataSource;
import savant.data.types.Genome;
import savant.settings.InterfaceSettings;
import savant.settings.SettingsDialog;
import savant.util.DrawingMode;
import savant.util.MiscUtils;
import savant.view.dialog.BAMFilterDialog;
import savant.view.swing.Frame;
import savant.view.swing.GraphPane;
import savant.view.swing.Savant;
import savant.view.swing.TrackColourSchemePanel;
import savant.view.tracks.BAMTrack;
import savant.view.tracks.RichIntervalTrack;
import savant.view.tracks.SequenceTrack;
import savant.view.tracks.Track;

public final class FrameCommandBar
extends JMenuBar {
    private static final Log LOG = LogFactory.getLog(FrameCommandBar.class);
    private static final int[] AVAILABLE_INTERVAL_HEIGHTS = new int[]{1, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40};
    private final Frame frame;
    private final GraphPane graphPane;
    private final Track mainTrack;
    private JMenuItem scaleToFitItem;
    private JCheckBoxMenuItem[] modeItems;
    private int drawModePosition = 0;
    private JMenu intervalMenu;
    private JSlider intervalSlider;
    private JCheckBoxMenuItem setAsGenomeButton;
    private JCheckBoxMenuItem baseQualityItem;
    private JCheckBoxMenuItem mappingQualityItem;

    FrameCommandBar(Frame f) {
        this.frame = f;
        this.graphPane = (GraphPane)f.getGraphPane();
        this.mainTrack = f.getTracks()[0];
        this.setMinimumSize(new Dimension(50, 22));
        this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        JMenu toolsMenu = this.createToolsMenu();
        this.add(toolsMenu);
        if (this.mainTrack.getValidDrawingModes().length > 1) {
            JMenu modeMenu = this.createDisplayModeMenu();
            this.add(modeMenu);
        }
        JMenu appearanceMenu = this.createAppearanceMenu();
        this.add(appearanceMenu);
        DataFormat df = this.mainTrack.getDataFormat();
        if (df == DataFormat.ALIGNMENT || df == DataFormat.GENERIC_INTERVAL || df == DataFormat.RICH_INTERVAL) {
            this.intervalMenu = this.createIntervalMenu();
            this.add(this.intervalMenu);
            this.drawModeChanged(this.mainTrack.getDrawingMode());
            int h = this.getIntervalHeight();
            this.graphPane.setUnitHeight(h);
            this.graphPane.setScaledToFit(false);
        }
    }

    private JMenu createToolsMenu() {
        JMenu menu = new JMenu("Tools");
        JMenuItem item = new JCheckBoxMenuItem("Lock X Axis");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameCommandBar.this.graphPane.setLocked(!FrameCommandBar.this.graphPane.isLocked());
            }
        });
        menu.add(item);
        final JCheckBoxMenuItem itemy = new JCheckBoxMenuItem("Lock Y Axis");
        itemy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Trying to locking Y max: " + !itemy.isSelected());
                FrameCommandBar.this.graphPane.setYMaxLocked(itemy.isSelected());
            }
        });
        item = new JMenuItem("Copy URL to Clipboard");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(FrameCommandBar.this.mainTrack.getDataSource().getURI().toString()), null);
            }
        });
        menu.add(item);
        DataFormat df = this.mainTrack.getDataFormat();
        if (df == DataFormat.SEQUENCE) {
            menu.add(new JSeparator());
            JMenuItem copyItem = new JMenuItem("Copy Sequence to Clipboard");
            copyItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        LocationController lc = LocationController.getInstance();
                        byte[] seq = ((SequenceTrack)FrameCommandBar.this.mainTrack).getSequence(lc.getReferenceName(), lc.getRange());
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(new String(seq)), null);
                    }
                    catch (Throwable x) {
                        LOG.error((Object)x);
                        DialogUtils.displayError("Unable to copy sequence to clipboard.");
                    }
                }
            });
            menu.add(copyItem);
            this.setAsGenomeButton = new JCheckBoxMenuItem("Set as Genome");
            this.setAsGenomeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Genome newGenome = Genome.createFromTrack(FrameCommandBar.this.mainTrack);
                    GenomeController.getInstance().setGenome(newGenome);
                }
            });
            menu.add(this.setAsGenomeButton);
            menu.addMenuListener(new MenuAdapter(){

                @Override
                public void menuSelected(MenuEvent me) {
                    Track seqTrack = (Track)GenomeController.getInstance().getGenome().getSequenceTrack();
                    if (seqTrack == FrameCommandBar.this.mainTrack) {
                        FrameCommandBar.this.setAsGenomeButton.setSelected(true);
                        FrameCommandBar.this.setAsGenomeButton.setEnabled(false);
                        FrameCommandBar.this.setAsGenomeButton.setToolTipText("This track is already the reference sequence");
                    } else {
                        FrameCommandBar.this.setAsGenomeButton.setSelected(false);
                        FrameCommandBar.this.setAsGenomeButton.setEnabled(true);
                        FrameCommandBar.this.setAsGenomeButton.setToolTipText("Use this track as the reference sequence");
                    }
                }
            });
        } else if (df == DataFormat.ALIGNMENT) {
            menu.add(new JSeparator());
            item = new JMenuItem("Filter...");
            item.setToolTipText("Control how records are filtered");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new BAMFilterDialog(DialogUtils.getMainWindow(), (BAMTrack)FrameCommandBar.this.mainTrack).setVisible(true);
                }
            });
            menu.add(item);
        } else if (df == DataFormat.RICH_INTERVAL) {
            menu.add(new JSeparator());
            final JMenuItem bookmarkAll = new JMenuItem("Bookmark All Features");
            bookmarkAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataSource ds = (DataSource)FrameCommandBar.this.mainTrack.getDataSource();
                    if (DialogUtils.askYesNo("Bookmark All Features ", String.format("This will create %d bookmarks.  Are you sure you want to do this?", ds.getDictionaryCount())) == 0) {
                        ds.addDictionaryToBookmarks();
                        Savant.getInstance().displayBookmarksPanel();
                    }
                }
            });
            menu.add(bookmarkAll);
            menu.addMenuListener(new MenuAdapter(){

                @Override
                public void menuSelected(MenuEvent me) {
                    bookmarkAll.setEnabled(FrameCommandBar.this.mainTrack.getDataSource() instanceof DataSource && ((DataSource)FrameCommandBar.this.mainTrack.getDataSource()).getDictionaryCount() > 0);
                }
            });
        }
        return menu;
    }

    private JMenu createDisplayModeMenu() {
        JMenu menu = new JMenu("Display Mode");
        DrawingMode[] validModes = this.mainTrack.getValidDrawingModes();
        this.modeItems = new JCheckBoxMenuItem[validModes.length];
        for (int i = 0; i < validModes.length; ++i) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(validModes[i].getDescription());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                    if (item.getState()) {
                        DrawingMode[] validModes = FrameCommandBar.this.mainTrack.getValidDrawingModes();
                        for (int j = 0; j < FrameCommandBar.this.modeItems.length; ++j) {
                            if (item.getText().equals(validModes[j].getDescription())) {
                                for (Track t : FrameCommandBar.this.frame.getTracks()) {
                                    AnalyticsAgent.log((NameValuePair[])new NameValuePair[]{new NameValuePair("track-event", "DisplayModeChanged"), new NameValuePair("track-type", t.getClass().getSimpleName()), new NameValuePair("target-mode", validModes[j].getDescription())});
                                    t.setDrawingMode(validModes[j]);
                                }
                                FrameCommandBar.this.drawModePosition = j;
                                continue;
                            }
                            FrameCommandBar.this.modeItems[j].setState(false);
                        }
                    } else {
                        item.setState(true);
                    }
                }
            });
            if (validModes[i] == this.mainTrack.getDrawingMode()) {
                item.setState(true);
            }
            this.modeItems[i] = item;
            menu.add(item);
        }
        DrawingMode currentMode = this.mainTrack.getDrawingMode();
        for (int i = 0; i < validModes.length; ++i) {
            if (!validModes[i].equals((Object)currentMode)) continue;
            this.drawModePosition = i;
            break;
        }
        this.graphPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (MiscUtils.MAC && e.getModifiersEx() == 256 && e.getKeyChar() == 'm' || !MiscUtils.MAC && e.getKeyChar() == '\n' && e.isControlDown()) {
                    FrameCommandBar.this.cycleDisplayMode();
                }
            }
        });
        return menu;
    }

    private void cycleDisplayMode() {
        if (this.modeItems == null) {
            return;
        }
        this.modeItems[this.drawModePosition].setState(false);
        ++this.drawModePosition;
        DrawingMode[] drawModes = this.mainTrack.getValidDrawingModes();
        if (this.drawModePosition >= drawModes.length) {
            this.drawModePosition = 0;
        }
        this.modeItems[this.drawModePosition].setState(true);
        this.mainTrack.setDrawingMode(drawModes[this.drawModePosition]);
    }

    private JMenu createAppearanceMenu() {
        JMenu menu = new JMenu("Appearance");
        JMenuItem item = new JMenuItem("Colour Settings...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog dlg = new SettingsDialog(DialogUtils.getMainWindow(), "Colour Settings", new TrackColourSchemePanel(FrameCommandBar.this.mainTrack));
                dlg.setVisible(true);
            }
        });
        menu.add(item);
        DataFormat df = this.mainTrack.getDataFormat();
        if (df != DataFormat.SEQUENCE) {
            this.scaleToFitItem = new JCheckBoxMenuItem("Scale to Fit");
            this.scaleToFitItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (FrameCommandBar.this.scaleToFitItem.isSelected()) {
                        FrameCommandBar.this.graphPane.setScaledToFit(true);
                    } else {
                        if (FrameCommandBar.this.intervalSlider != null && FrameCommandBar.this.mainTrack.getDrawingMode() != DrawingMode.ARC && FrameCommandBar.this.mainTrack.getDrawingMode() != DrawingMode.ARC_PAIRED && FrameCommandBar.this.mainTrack.getResolution(LocationController.getInstance().getRange()) == Resolution.HIGH) {
                            int h = FrameCommandBar.this.getIntervalHeight();
                            FrameCommandBar.this.graphPane.setUnitHeight(h);
                        }
                        FrameCommandBar.this.graphPane.setScaledToFit(false);
                    }
                }
            });
            this.scaleToFitItem.setToolTipText("If selected, the track's display will be scaled to fit the available height.");
            menu.addMenuListener(new MenuAdapter(){

                @Override
                public void menuSelected(MenuEvent me) {
                    FrameCommandBar.this.scaleToFitItem.setSelected(FrameCommandBar.this.graphPane.isScaledToFit());
                }
            });
            menu.add(this.scaleToFitItem);
        }
        if (df == DataFormat.RICH_INTERVAL) {
            menu.add(new JSeparator());
            JCheckBoxMenuItem itemRGB = new JCheckBoxMenuItem("Enable ItemRGB");
            itemRGB.setState(false);
            itemRGB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((RichIntervalTrack)FrameCommandBar.this.mainTrack).toggleItemRGBEnabled();
                    FrameCommandBar.this.graphPane.setRenderForced();
                    FrameCommandBar.this.graphPane.repaint();
                }
            });
            menu.add(itemRGB);
            JCheckBoxMenuItem score = new JCheckBoxMenuItem("Enable Score");
            score.setState(false);
            score.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((RichIntervalTrack)FrameCommandBar.this.mainTrack).toggleScoreEnabled();
                    FrameCommandBar.this.graphPane.setRenderForced();
                    FrameCommandBar.this.graphPane.repaint();
                }
            });
            menu.add(score);
            JCheckBoxMenuItem alternate = new JCheckBoxMenuItem("Display Alternate Name");
            alternate.setState(((RichIntervalTrack)this.mainTrack).isUsingAlternateName());
            alternate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((RichIntervalTrack)FrameCommandBar.this.mainTrack).toggleAlternateName();
                    FrameCommandBar.this.graphPane.setRenderForced();
                    FrameCommandBar.this.graphPane.repaint();
                }
            });
            menu.add(alternate);
        } else if (df == DataFormat.ALIGNMENT) {
            menu.add(new JSeparator());
            this.baseQualityItem = new JCheckBoxMenuItem("Enable Base Quality");
            this.baseQualityItem.setState(false);
            this.baseQualityItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (((BAMTrack)FrameCommandBar.this.mainTrack).toggleBaseQualityEnabled()) {
                        FrameCommandBar.this.mappingQualityItem.setState(false);
                    }
                    FrameCommandBar.this.graphPane.setRenderForced();
                    FrameCommandBar.this.graphPane.repaint();
                }
            });
            menu.add(this.baseQualityItem);
            this.mappingQualityItem = new JCheckBoxMenuItem("Enable Mapping Quality");
            this.mappingQualityItem.setState(false);
            this.mappingQualityItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (((BAMTrack)FrameCommandBar.this.mainTrack).toggleMappingQualityEnabled()) {
                        FrameCommandBar.this.baseQualityItem.setState(false);
                    }
                    FrameCommandBar.this.graphPane.setRenderForced();
                    FrameCommandBar.this.graphPane.repaint();
                }
            });
            menu.add(this.mappingQualityItem);
        }
        return menu;
    }

    private JMenu createIntervalMenu() {
        JMenu menu = new JMenu("Interval Height");
        this.intervalSlider = new JSlider(1, 1, AVAILABLE_INTERVAL_HEIGHTS.length, 1);
        this.intervalSlider.setMinorTickSpacing(1);
        this.intervalSlider.setMajorTickSpacing(AVAILABLE_INTERVAL_HEIGHTS.length / 2);
        this.intervalSlider.setSnapToTicks(true);
        this.intervalSlider.setPaintTicks(true);
        this.intervalSlider.setValue(FrameCommandBar.getSliderFromIntervalHeight(InterfaceSettings.getIntervalHeight(this.mainTrack.getDataFormat())));
        this.intervalSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int h = FrameCommandBar.this.getIntervalHeight();
                if (FrameCommandBar.this.graphPane.isScaledToFit()) {
                    FrameCommandBar.this.graphPane.setUnitHeight(h);
                    FrameCommandBar.this.graphPane.setScaledToFit(false);
                } else if (FrameCommandBar.this.graphPane.getUnitHeight() != (double)h) {
                    FrameCommandBar.this.graphPane.setUnitHeight(h);
                    FrameCommandBar.this.graphPane.setRenderForced();
                    FrameCommandBar.this.graphPane.repaint();
                }
            }
        });
        menu.add(this.intervalSlider);
        return menu;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    int getIntervalHeight() {
        int slider = this.intervalSlider.getValue() - 1;
        if (slider < 0) {
            return AVAILABLE_INTERVAL_HEIGHTS[0];
        }
        if (slider >= AVAILABLE_INTERVAL_HEIGHTS.length) {
            return AVAILABLE_INTERVAL_HEIGHTS[AVAILABLE_INTERVAL_HEIGHTS.length - 1];
        }
        return AVAILABLE_INTERVAL_HEIGHTS[slider];
    }

    private static int getSliderFromIntervalHeight(int intervalHeight) {
        int newValue = 0;
        int diff = Math.abs(AVAILABLE_INTERVAL_HEIGHTS[0] - intervalHeight);
        for (int i = 1; i < AVAILABLE_INTERVAL_HEIGHTS.length; ++i) {
            int currVal = AVAILABLE_INTERVAL_HEIGHTS[i];
            int currDiff = Math.abs(currVal - intervalHeight);
            if (currDiff >= diff) continue;
            newValue = i;
            diff = currDiff;
        }
        return newValue + 1;
    }

    public void drawModeChanged(DrawingMode mode) {
        if (this.intervalMenu != null) {
            this.intervalMenu.setVisible(mode != DrawingMode.ARC && mode != DrawingMode.ARC_PAIRED && mode != DrawingMode.SNP && mode != DrawingMode.STRAND_SNP);
        }
    }

    private abstract class MenuAdapter
    implements MenuListener {
        private MenuAdapter() {
        }

        @Override
        public void menuDeselected(MenuEvent me) {
        }

        @Override
        public void menuCanceled(MenuEvent me) {
        }
    }
}

