/*
 * Decompiled with CFR 0.152.
 */
package savant.view.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.savant.analytics.savantanalytics.AnalyticsAgent;
import savant.api.adapter.FrameAdapter;
import savant.api.adapter.GraphPaneAdapter;
import savant.api.data.ContinuousRecord;
import savant.api.data.Record;
import savant.api.event.ExportEvent;
import savant.api.event.PopupEvent;
import savant.api.util.Listener;
import savant.controller.GraphPaneController;
import savant.controller.LocationController;
import savant.controller.event.GraphPaneEvent;
import savant.data.types.BAMIntervalRecord;
import savant.exception.RenderingException;
import savant.selection.PopupPanel;
import savant.selection.PopupThread;
import savant.settings.ColourSettings;
import savant.settings.InterfaceSettings;
import savant.util.AxisRange;
import savant.util.AxisType;
import savant.util.ColourKey;
import savant.util.DrawingInstruction;
import savant.util.DrawingMode;
import savant.util.MiscUtils;
import savant.util.Range;
import savant.util.swing.ProgressPanel;
import savant.view.swing.Frame;
import savant.view.tracks.BAMTrack;
import savant.view.tracks.BAMTrackRenderer;
import savant.view.tracks.ContinuousTrackRenderer;
import savant.view.tracks.Track;
import savant.view.tracks.TrackCancellationListener;

public class GraphPane
extends JPanel
implements GraphPaneAdapter,
MouseWheelListener,
MouseListener,
MouseMotionListener {
    private static final Log LOG = LogFactory.getLog(GraphPane.class);
    private Track[] tracks;
    private Frame parentFrame;
    private int mouseX = 0;
    private int mouseY = 0;
    private int xMin;
    private int xMax;
    protected int yMin;
    protected int yMax;
    private double unitWidth = Double.NaN;
    protected double unitHeight;
    private AxisType yAxisType = AxisType.NONE;
    private AxisType xAxisType = AxisType.NONE;
    private boolean mouseInside = false;
    private Range lockedRange;
    protected boolean scaledToFit = true;
    private Rectangle2D selectionRect = new Rectangle2D.Double();
    private boolean isDragging = false;
    private BufferedImage bufferedImage;
    private Range prevRange = null;
    private DrawingMode prevMode = null;
    private Dimension prevSize = null;
    private String prevRef = null;
    private boolean paneResize = false;
    private int newHeight;
    private int oldWidth = -1;
    private int oldHeight = -1;
    private int oldViewHeight = -1;
    private boolean renderRequired = false;
    private int posOffset = 0;
    protected boolean forcedHeight = false;
    private int startX;
    private int startY;
    private int baseX;
    private int initialScroll;
    private boolean panVert = false;
    public Thread popupThread;
    private Record currentOverRecord = null;
    private Shape currentOverShape = null;
    private ProgressPanel progressPanel;
    private final List<Listener<ExportEvent>> exportListeners = new ArrayList<Listener<ExportEvent>>();
    private final List<Listener<PopupEvent>> popupListeners = new ArrayList<Listener<PopupEvent>>();
    private boolean yAxisLocked;

    public GraphPane(Frame parent) {
        this.parentFrame = parent;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.getInputMap().allKeys();
        this.addMouseWheelListener(this);
        this.popupThread = new Thread((Runnable)new PopupThread(this), "PopupThread");
        this.popupThread.start();
        GraphPaneController gpc = GraphPaneController.getInstance();
        gpc.addListener(new Listener<GraphPaneEvent>(){

            @Override
            public void handleEvent(GraphPaneEvent event) {
                if (event.getType() == GraphPaneEvent.Type.HIGHLIGHTING) {
                    GraphPane.this.repaint();
                }
            }
        });
    }

    public void setYMaxLocked(boolean b) {
        System.out.println("Locking Y max: " + b);
        this.yAxisLocked = b;
    }

    public void setTracks(Track[] tracks) {
        this.tracks = tracks;
        this.setYAxisType(AxisType.NONE);
    }

    public Track[] getTracks() {
        return this.tracks;
    }

    public boolean render(Graphics2D g2) {
        return this.render(g2, new Range(this.xMin, this.xMax), null);
    }

    public boolean render(Graphics2D g2, Range xRange, Range yRange) {
        boolean withinScrollBounds;
        boolean sameRange;
        LOG.trace((Object)("GraphPane.render(g2, " + xRange + ", " + yRange + ")"));
        double oldUnitHeight = this.unitHeight;
        int oldYMax = this.yMax;
        GradientPaint gp0 = new GradientPaint(0.0f, 0.0f, ColourSettings.getColor(ColourKey.GRAPH_PANE_BACKGROUND_TOP), 0.0f, this.getHeight(), ColourSettings.getColor(ColourKey.GRAPH_PANE_BACKGROUND_BOTTOM));
        g2.setPaint(gp0);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        GraphPaneController gpc = GraphPaneController.getInstance();
        LocationController lc = LocationController.getInstance();
        JScrollBar scroller = this.getVerticalScrollBar();
        if (gpc.isPanning() && !this.isLocked()) {
            double fromX = this.transformXPos(gpc.getMouseClickPosition());
            double toX = this.transformXPos(gpc.getMouseReleasePosition());
            g2.translate(toX - fromX, 0.0);
        }
        if (this.tracks == null) {
            this.parentFrame.updateProgress();
            return false;
        }
        for (Track t : this.tracks) {
            if (!t.getRenderer().isWaitingForData()) continue;
            String progressMsg = (String)t.getRenderer().getInstruction(DrawingInstruction.PROGRESS);
            this.setPreferredSize(new Dimension(this.getWidth(), 0));
            this.showProgress(progressMsg, -1.0);
            return false;
        }
        if (this.progressPanel != null) {
            this.remove(this.progressPanel);
            this.progressPanel = null;
        }
        int minYRange = Integer.MAX_VALUE;
        int maxYRange = Integer.MIN_VALUE;
        AxisType bestYAxis = AxisType.NONE;
        block9: for (Track t : this.tracks) {
            AxisRange axisRange = (AxisRange)t.getRenderer().getInstruction(DrawingInstruction.AXIS_RANGE);
            if (axisRange != null) {
                int axisYMin = axisRange.getYMin();
                int axisYMax = axisRange.getYMax();
                if (axisYMin < minYRange) {
                    minYRange = axisYMin;
                }
                if (axisYMax > maxYRange) {
                    maxYRange = axisYMax;
                }
            }
            switch (t.getYAxisType(t.getResolution(xRange))) {
                case INTEGER_GRIDLESS: {
                    if (bestYAxis != AxisType.NONE) continue block9;
                    bestYAxis = AxisType.INTEGER_GRIDLESS;
                    continue block9;
                }
                case INTEGER: {
                    if (bestYAxis == AxisType.REAL) continue block9;
                    bestYAxis = AxisType.INTEGER;
                    continue block9;
                }
                case REAL: {
                    bestYAxis = AxisType.REAL;
                }
            }
        }
        this.setXAxisType(this.tracks[0].getXAxisType(this.tracks[0].getResolution(xRange)));
        this.setXRange(xRange);
        this.setYAxisType(bestYAxis);
        Range consolidatedYRange = new Range(minYRange, maxYRange);
        this.setYRange(consolidatedYRange);
        consolidatedYRange = new Range(this.yMin, this.yMax);
        DrawingMode currentMode = this.tracks[0].getDrawingMode();
        boolean bl = sameRange = this.prevRange != null && xRange.equals(this.prevRange);
        if (!sameRange) {
            PopupPanel.hidePopup();
        }
        boolean sameMode = currentMode == this.prevMode;
        boolean sameSize = this.prevSize != null && this.getSize().equals(this.prevSize) && this.parentFrame.getFrameLandscape().getWidth() == this.oldWidth && this.parentFrame.getFrameLandscape().getHeight() == this.oldHeight;
        boolean sameRef = this.prevRef != null && lc.getReferenceName().equals(this.prevRef);
        boolean bl2 = withinScrollBounds = this.bufferedImage != null && scroller.getValue() >= this.getOffset() && scroller.getValue() < this.getOffset() + this.getViewportHeight() * 2;
        if (sameRange && sameMode && sameSize && sameRef && !this.renderRequired && withinScrollBounds) {
            g2.drawImage((Image)this.bufferedImage, 0, this.getOffset(), this);
            this.renderCurrentSelected(g2);
            this.unitHeight = oldUnitHeight;
            this.yMax = oldYMax;
        } else {
            this.renderRequired = false;
            int h = this.getHeight();
            if (!this.forcedHeight) {
                h = Math.min(h, this.getViewportHeight() * 3);
            }
            LOG.debug((Object)("Requesting " + this.getWidth() + "\u00d7" + h + " bufferedImage."));
            this.bufferedImage = new BufferedImage(this.getWidth(), h, 1);
            if (this.bufferedImage.getHeight() == this.getHeight()) {
                this.setOffset(0);
            } else {
                this.setOffset(scroller.getValue() - this.getViewportHeight());
            }
            LOG.debug((Object)("Rendering fresh " + this.bufferedImage.getWidth() + "\u00d7" + this.bufferedImage.getHeight() + " bufferedImage at (0, " + this.getOffset() + ")"));
            Graphics2D g3 = this.bufferedImage.createGraphics();
            g3.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.prevRange = xRange;
            this.prevSize = this.getSize();
            this.prevMode = this.tracks[0].getDrawingMode();
            this.prevRef = lc.getReferenceName();
            this.renderBackground(g3, this.xAxisType == AxisType.INTEGER || this.xAxisType == AxisType.REAL, this.yAxisType == AxisType.INTEGER || this.yAxisType == AxisType.REAL);
            boolean nothingRendered = true;
            String message = null;
            int priority = -1;
            for (Track t : this.tracks) {
                AxisRange axes = (AxisRange)t.getRenderer().getInstruction(DrawingInstruction.AXIS_RANGE);
                axes = axes == null ? new AxisRange(xRange, consolidatedYRange) : new AxisRange(axes.getXRange(), consolidatedYRange);
                t.getRenderer().addInstruction(DrawingInstruction.AXIS_RANGE, axes);
                try {
                    t.getRenderer().render(g3, this);
                    nothingRendered = false;
                }
                catch (RenderingException rx) {
                    if (rx.getPriority() <= priority) continue;
                    message = rx.getMessage();
                    priority = rx.getPriority();
                }
                catch (Throwable x) {
                    LOG.error((Object)("Error rendering " + t), x);
                    message = MiscUtils.getMessage(x);
                    priority = 3;
                }
            }
            if (nothingRendered && message != null) {
                this.setPreferredSize(new Dimension(this.getWidth(), 0));
                this.revalidate();
                this.drawMessage(g3, message);
            }
            this.updateYMax();
            if (this.paneResize) {
                this.paneResize = false;
                if (this.getHeight() != this.newHeight) {
                    Dimension newSize = new Dimension(this.getWidth(), this.newHeight);
                    this.setPreferredSize(newSize);
                    this.setSize(newSize);
                    this.parentFrame.validate();
                    scroller.setValue(scroller.getMaximum());
                    this.repaint();
                    return false;
                }
            } else if (this.oldViewHeight != -1 && this.oldViewHeight != this.getViewportHeight()) {
                int newViewHeight = this.getViewportHeight();
                int oldScroll = scroller.getValue();
                scroller.setValue(oldScroll + (this.oldViewHeight - newViewHeight));
                this.oldViewHeight = newViewHeight;
            }
            this.oldWidth = this.parentFrame.getFrameLandscape().getWidth();
            this.oldHeight = this.parentFrame.getFrameLandscape().getHeight();
            g2.drawImage((Image)this.bufferedImage, 0, this.getOffset(), this);
            this.fireExportEvent(xRange, this.bufferedImage);
            this.renderCurrentSelected(g2);
        }
        return true;
    }

    private int getViewportHeight() {
        return this.getParent().getParent().getHeight();
    }

    public JScrollBar getVerticalScrollBar() {
        return ((JScrollPane)this.getParent().getParent().getParent()).getVerticalScrollBar();
    }

    private void renderCurrentSelected(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.translate(0, this.getOffset());
        for (Track t : this.tracks) {
            if (!t.getRenderer().hasMappedValues()) continue;
            List<Shape> currentSelected = t.getRenderer().getCurrentSelectedShapes(this);
            if (currentSelected.size() <= 0) break;
            boolean arcMode = t.getDrawingMode() == DrawingMode.ARC_PAIRED;
            for (Shape selectedShape : currentSelected) {
                if (selectedShape == this.currentOverShape) continue;
                if (arcMode) {
                    g2.setColor(Color.GREEN);
                    g2.draw(selectedShape);
                    continue;
                }
                g2.setColor(new Color(0, 255, 0, 150));
                g2.fill(selectedShape);
                if (!(selectedShape.getBounds().getWidth() > 5.0)) continue;
                g2.setColor(Color.BLACK);
                g2.draw(selectedShape);
            }
            break;
        }
        if (this.currentOverShape != null) {
            if (this.tracks[0].getDrawingMode() == DrawingMode.ARC_PAIRED) {
                g2.setColor(Color.RED);
                g2.draw(this.currentOverShape);
                BAMIntervalRecord rec1 = (BAMIntervalRecord)this.currentOverRecord;
                BAMIntervalRecord rec2 = ((BAMTrack)this.tracks[0]).getMate(rec1);
                ((BAMTrackRenderer)this.tracks[0].getRenderer()).renderReadsFromArc(g2, this, rec1, rec2, this.prevRange);
            } else {
                g2.setColor(new Color(255, 0, 0, 150));
                g2.fill(this.currentOverShape);
                if (this.currentOverShape.getBounds() != null && this.currentOverShape.getBounds().getWidth() > 5.0 && this.currentOverShape.getBounds().getHeight() > 3.0) {
                    g2.setColor(Color.BLACK);
                    g2.draw(this.currentOverShape);
                }
            }
        }
        g2.translate(0, -this.getOffset());
    }

    @Override
    public void setRenderForced() {
        this.renderRequired = true;
    }

    public boolean isRenderForced() {
        return this.renderRequired;
    }

    public void forceFullHeight() {
        this.forcedHeight = true;
    }

    public void unforceFullHeight() {
        this.forcedHeight = false;
    }

    private void setOffset(int offset) {
        this.posOffset = offset;
    }

    @Override
    public int getOffset() {
        return this.posOffset;
    }

    private void requestHeight(int h) {
        this.newHeight = h;
        this.paneResize = true;
    }

    @Override
    protected void paintComponent(Graphics g) {
        double x2;
        double x1;
        double width;
        if (this.tracks != null && this.tracks.length > 0) {
            LOG.trace((Object)("GraphPane.paintComponent(" + this.tracks[0].getName() + ")"));
        }
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        boolean trueRender = this.render(g2);
        GraphPaneController gpc = GraphPaneController.getInstance();
        int h = this.getHeight();
        if (gpc.isAiming() && this.mouseInside) {
            g2.setColor(Color.BLACK);
            Font thickfont = g2.getFont().deriveFont(1, 15.0f);
            g2.setFont(thickfont);
            int genomeX = gpc.getMouseXPosition();
            double genomeY = gpc.getMouseYPosition();
            String target = "";
            target = target + "X: " + MiscUtils.numToString(genomeX);
            if (!Double.isNaN(genomeY)) {
                target = target + " Y: " + MiscUtils.numToString(genomeY);
            }
            g2.drawLine(this.mouseX, 0, this.mouseX, h);
            if (genomeY != -1.0) {
                g.drawLine(0, this.mouseY, this.getWidth(), this.mouseY);
            }
            g2.drawString(target, this.mouseX + 5, this.mouseY - 5);
        }
        this.selectionRect = new Rectangle2D.Double((width = (x1 = this.transformXPos(gpc.getMouseClickPosition())) - (x2 = this.transformXPos(gpc.getMouseReleasePosition()))) < 0.0 ? x1 : x2, 0.0, Math.max(2.0, Math.abs(width)), h);
        if (!gpc.isPanning() && (gpc.isZooming() || gpc.isSelecting())) {
            Rectangle2D.Double rectangle = new Rectangle2D.Double(this.selectionRect.getX(), this.selectionRect.getY() - 10.0, this.selectionRect.getWidth(), this.selectionRect.getHeight() + 10.0);
            g2.setColor(Color.gray);
            g2.setStroke(new BasicStroke(1.0f, 1, 1, 3.0f, new float[]{4.0f}, 4.0f));
            g2.draw(rectangle);
            if (gpc.isZooming()) {
                g.setColor(ColourSettings.getColor(ColourKey.GRAPH_PANE_ZOOM_FILL));
            } else if (gpc.isSelecting()) {
                g.setColor(ColourSettings.getColor(ColourKey.GRAPH_PANE_SELECTION_FILL));
            }
            g2.fill(this.selectionRect);
        }
        Range xRange = this.getXRange();
        if (gpc.isPlumbing()) {
            g2.setColor(Color.BLACK);
            double spos = this.transformXPos(gpc.getMouseXPosition());
            g2.draw(new Line2D.Double(spos, 0.0, spos, h));
            double rpos = this.transformXPos(gpc.getMouseXPosition() + 1);
            g2.draw(new Line2D.Double(rpos, 0.0, rpos, h));
        }
        if (gpc.isSpotlight() && !gpc.isZooming()) {
            int center = gpc.getMouseXPosition();
            int left = center - gpc.getSpotlightSize() / 2;
            int right = left + gpc.getSpotlightSize();
            g2.setColor(new Color(0, 0, 0, 200));
            if (left >= xRange.getFrom()) {
                g2.fill(new Rectangle2D.Double(0.0, 0.0, this.transformXPos(left), h));
            }
            if (right <= xRange.getTo()) {
                double pix = this.transformXPos(right);
                g2.fill(new Rectangle2D.Double(pix, 0.0, (double)this.getWidth() - pix, h));
            }
        }
        if (this.isLocked()) {
            this.drawMessage((Graphics2D)g, "Locked");
        }
        if (trueRender) {
            gpc.delistRenderingGraphpane(this);
        }
    }

    private void renderBackground(Graphics2D g2, boolean xGridOn, boolean yGridOn) {
        int h = this.getHeight();
        int w = this.getWidth();
        GradientPaint gp0 = new GradientPaint(0.0f, 0.0f, ColourSettings.getColor(ColourKey.GRAPH_PANE_BACKGROUND_TOP), 0.0f, h, ColourSettings.getColor(ColourKey.GRAPH_PANE_BACKGROUND_BOTTOM));
        g2.setPaint(gp0);
        g2.fillRect(0, 0, w, h);
        Area clipArea = new Area(new Rectangle(0, 0, w, h));
        Color gridColor = ColourSettings.getColor(ColourKey.AXIS_GRID);
        if (yGridOn) {
            double y;
            Font tickFont = g2.getFont().deriveFont(0, 9.0f);
            int[] yTicks = MiscUtils.getTickPositions(this.transformYPixel(this.getHeight()), this.transformYPixel(0.0));
            g2.setColor(gridColor);
            g2.setFont(tickFont);
            for (int t : yTicks) {
                y = this.transformYPos(t);
                if (y == 0.0 || y == (double)this.getHeight()) continue;
                String s = Integer.toString(t);
                Rectangle2D labelRect = tickFont.getStringBounds(s, g2.getFontRenderContext());
                double baseline = y + labelRect.getHeight() * 0.5 - 2.0;
                g2.drawString(s, 4.0f, (float)baseline);
                clipArea.subtract(new Area(new Rectangle2D.Double(3.0, baseline - labelRect.getHeight() - 1.0, labelRect.getWidth() + 2.0, labelRect.getHeight() + 2.0)));
            }
            g2.setClip(clipArea);
            for (int t2 : yTicks) {
                y = this.transformYPos(t2);
                g2.draw(new Line2D.Double(0.0, y, w, y));
            }
        }
        if (xGridOn) {
            Range r = LocationController.getInstance().getRange();
            int[] xTicks = MiscUtils.getTickPositions(r);
            g2.setColor(gridColor);
            for (int t : xTicks) {
                double x = this.transformXPos(t);
                g2.draw(new Line2D.Double(x, 0.0, x, h));
            }
        }
        g2.setClip(null);
    }

    public Range getXRange() {
        return new Range(this.xMin, this.xMax);
    }

    @Override
    public void setXRange(Range r) {
        if (r != null) {
            this.xMin = r.getFrom();
            this.xMax = r.getTo();
            this.setUnitWidth();
        }
    }

    public void setXAxisType(AxisType type) {
        this.xAxisType = type;
    }

    @Override
    public Range getYRange() {
        return new Range(this.yMin, this.yMax);
    }

    @Override
    public void setYRange(Range r) {
        if (this.yAxisLocked) {
            return;
        }
        if (r != null && this.yAxisType != AxisType.NONE) {
            int oldYMin = this.yMin;
            this.yMin = r.getFrom();
            this.yMax = r.getTo();
            if (this.scaledToFit) {
                this.setUnitHeight();
                LOG.debug((Object)("setYRange set unit height to " + this.unitHeight));
            } else if (((double)this.yMin < 0.0 || (double)oldYMin < 0.0) && oldYMin < this.yMin) {
                this.yMin = oldYMin;
            }
        }
    }

    public void setYAxisType(AxisType type) {
        this.yAxisType = type;
        this.parentFrame.setYMaxVisible(type != AxisType.NONE);
    }

    @Override
    public double getUnitHeight() {
        return this.unitHeight;
    }

    public void setUnitHeight() {
        this.unitHeight = (double)this.getHeight() / (double)(this.yMax - this.yMin);
    }

    @Override
    public void setUnitHeight(double height) {
        this.unitHeight = height;
    }

    @Override
    public double getUnitWidth() {
        return this.unitWidth;
    }

    public void setUnitWidth() {
        this.unitWidth = (double)this.getWidth() / (double)(this.xMax - this.xMin + 1);
    }

    @Override
    public int transformXPixel(double pix) {
        return (int)Math.floor(pix / this.unitWidth + (double)this.xMin);
    }

    @Override
    public double transformXPos(int pos) {
        return (double)(pos - this.xMin) * this.unitWidth;
    }

    @Override
    public double transformYPixel(double pix) {
        return ((double)this.getHeight() - pix) / this.unitHeight + (double)this.yMin;
    }

    @Override
    public double transformYPos(double pos) {
        return (double)this.getHeight() - (pos - (double)this.yMin) * this.unitHeight;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int notches = e.getWheelRotation();
        LocationController lc = LocationController.getInstance();
        if (MiscUtils.MAC && e.isMetaDown() || e.isControlDown()) {
            if (notches < 0) {
                lc.shiftRangeLeft();
            } else {
                lc.shiftRangeRight();
            }
        } else if (InterfaceSettings.doesWheelZoom()) {
            if (notches < 0) {
                lc.zoomInOnMouse();
            } else {
                lc.zoomOutFromMouse();
            }
        } else {
            JScrollBar sb = this.getVerticalScrollBar();
            if (sb.isVisible()) {
                sb.setValue(sb.getValue() + notches * 15);
            }
        }
    }

    private void setMouseModifier(MouseEvent e) {
        GraphPaneController gpc = GraphPaneController.getInstance();
        boolean zooming = MiscUtils.MAC ? e.isMetaDown() : e.isControlDown();
        boolean selecting = e.isShiftDown() && !zooming;
        gpc.setZooming(this.isDragging && zooming);
        gpc.setPanning(this.isDragging && !zooming && !selecting);
        gpc.setSelecting(this.isDragging && selecting);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() == 2) {
            LocationController.getInstance().zoomInOnMouse();
            return;
        }
        this.trySelect(event.getPoint());
        this.setMouseModifier(event);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.setMouseModifier(event);
        this.requestFocus();
        int x1 = this.getConstrainedX(event);
        this.baseX = this.transformXPixel(x1);
        this.initialScroll = this.getVerticalScrollBar().getValue();
        Point l = event.getLocationOnScreen();
        this.startX = l.x;
        this.startY = l.y;
        GraphPaneController gpc = GraphPaneController.getInstance();
        gpc.setMouseClickPosition(this.transformXPixel(x1));
    }

    public void resetCursor() {
        this.setCursor(new Cursor(12));
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        GraphPaneController gpc = GraphPaneController.getInstance();
        LocationController lc = LocationController.getInstance();
        int x2 = this.getConstrainedX(event);
        this.resetCursor();
        double x1 = this.transformXPos(gpc.getMouseClickPosition());
        if (gpc.isPanning()) {
            if (!this.panVert) {
                Range r = lc.getRange();
                int shiftVal = gpc.getMouseClickPosition() - this.transformXPixel(x2);
                Range newr = new Range(r.getFrom() + shiftVal, r.getTo() + shiftVal);
                lc.setLocation(newr);
                AnalyticsAgent.log((NameValuePair[])new NameValuePair[]{new NameValuePair("navigation-event", "panned"), new NameValuePair("navigation-modality", "mousedrag")});
            }
        } else if (gpc.isZooming()) {
            Range r = this.isLocked() ? this.lockedRange : lc.getRange();
            int newMin = (int)Math.round(Math.min(x1, (double)x2) / this.getUnitWidth());
            int newMax = (int)Math.max(Math.round(Math.max(x1, (double)x2) / this.getUnitWidth()) - 1L, (long)newMin);
            Range newr = new Range(r.getFrom() + newMin, r.getFrom() + newMax);
            AnalyticsAgent.log((NameValuePair[])new NameValuePair[]{new NameValuePair("navigation-event", "zoomed"), new NameValuePair("navigation-modality", "mousedrag")});
            lc.setLocation(newr);
        } else if (gpc.isSelecting()) {
            for (Track t : this.tracks) {
                if (!t.getRenderer().hasMappedValues()) continue;
                if (!t.getRenderer().rectangleSelect(this.selectionRect)) break;
                this.repaint();
                break;
            }
            AnalyticsAgent.log((NameValuePair[])new NameValuePair[]{new NameValuePair("selection-event", "selected"), new NameValuePair("selection-modality", "mousedrag")});
        }
        this.isDragging = false;
        this.setMouseModifier(event);
        gpc.setMouseReleasePosition(this.transformXPixel(x2));
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.resetCursor();
        this.mouseInside = true;
        this.setMouseModifier(event);
        PopupPanel.hidePopup();
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.setCursor(new Cursor(0));
        this.setMouseModifier(event);
        this.mouseInside = false;
        GraphPaneController.getInstance().setMouseXPosition(-1);
        GraphPaneController.getInstance().setMouseYPosition(Double.NaN, false);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.setMouseModifier(event);
        GraphPaneController gpc = GraphPaneController.getInstance();
        int x2 = this.getConstrainedX(event);
        this.isDragging = true;
        if (gpc.isPanning()) {
            this.setCursor(new Cursor(12));
        } else if (gpc.isZooming() || gpc.isSelecting()) {
            this.setCursor(new Cursor(1));
        }
        JScrollBar scroller = this.getVerticalScrollBar();
        boolean scroll = scroller.isVisible();
        if (scroll) {
            int magY;
            Point l = event.getLocationOnScreen();
            int currX = l.x;
            int currY = l.y;
            int magX = Math.abs(currX - this.startX);
            if (magX >= (magY = Math.abs(currY - this.startY))) {
                this.panVert = false;
                gpc.setMouseReleasePosition(this.transformXPixel(x2));
                scroller.setValue(this.initialScroll);
            } else {
                this.panVert = true;
                gpc.setMouseReleasePosition(this.baseX);
                scroller.setValue(this.initialScroll - (currY - this.startY));
            }
        } else {
            this.panVert = false;
            gpc.setMouseReleasePosition(this.transformXPixel(x2));
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.mouseX = event.getX();
        this.mouseY = event.getY();
        if (!Double.isNaN(this.unitWidth)) {
            GraphPaneController gpc = GraphPaneController.getInstance();
            gpc.setMouseXPosition(this.transformXPixel(this.mouseX));
            switch (this.yAxisType) {
                case NONE: {
                    gpc.setMouseYPosition(Double.NaN, false);
                    break;
                }
                case INTEGER_GRIDLESS: 
                case INTEGER: {
                    gpc.setMouseYPosition(Math.floor(this.transformYPixel(this.mouseY)), true);
                    break;
                }
                case REAL: {
                    gpc.setMouseYPosition(this.transformYPixel(this.mouseY), false);
                }
            }
            gpc.setSpotlightSize(this.getXRange().getLength());
        }
    }

    private int getConstrainedX(MouseEvent event) {
        int x = event.getX();
        if (x < 0) {
            return 0;
        }
        return Math.min(x, this.getWidth());
    }

    public boolean isLocked() {
        return this.lockedRange != null;
    }

    public void setLocked(boolean b) {
        if (b) {
            this.lockedRange = LocationController.getInstance().getRange();
        } else {
            this.lockedRange = null;
            this.renderRequired = true;
        }
        this.repaint();
    }

    @Override
    public FrameAdapter getParentFrame() {
        return this.parentFrame;
    }

    public void tryPopup(Point p) {
        if (this.tracks == null) {
            return;
        }
        Point pt = new Point(p.x, p.y - this.getOffset());
        for (Track t : this.tracks) {
            Map<Record, Shape> map = t.getRenderer().searchPoint(pt);
            if (map == null) continue;
            PopupPanel.hidePopup();
            Record overRecord = map.keySet().iterator().next();
            Point p1 = (Point)p.clone();
            SwingUtilities.convertPointToScreen(p1, this);
            PopupPanel.showPopup(this, p1, t, overRecord);
            this.currentOverRecord = overRecord;
            this.currentOverShape = map.get(this.currentOverRecord);
            if (this.currentOverRecord instanceof ContinuousRecord) {
                this.currentOverShape = ContinuousTrackRenderer.continuousRecordToEllipse(this, this.currentOverRecord);
            }
            this.repaint();
            return;
        }
        this.currentOverShape = null;
        this.currentOverRecord = null;
    }

    @Override
    public void recordSelected(Record rec) {
        for (Track t : this.tracks) {
            t.getRenderer().addToSelected(rec);
        }
        this.repaint();
    }

    @Override
    public void popupHidden() {
        if (this.currentOverShape != null) {
            this.currentOverShape = null;
            this.currentOverRecord = null;
            this.repaint();
        }
    }

    public void trySelect(Point p) {
        Point p_offset = new Point(p.x, p.y - this.getOffset());
        for (Track t : this.tracks) {
            Map<Record, Shape> map = t.getRenderer().searchPoint(p_offset);
            if (map == null) continue;
            Object[] recs = map.keySet().toArray();
            if (recs.length == 1) {
                t.getRenderer().addToSelected((Record)recs[0]);
            } else {
                ArrayList<Record> array = new ArrayList<Record>();
                for (Object rec : recs) {
                    array.add((Record)rec);
                }
                t.getRenderer().toggleGroup(array);
            }
            this.repaint();
            break;
        }
    }

    private void drawMessage(Graphics2D g2, String message) {
        Font font;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font subFont = font = g2.getFont();
        int h = this.getSize().height / 3;
        int w = this.getWidth();
        if (w > 500) {
            font = font.deriveFont(0, 36.0f);
            subFont = subFont.deriveFont(0, 18.0f);
        } else if (w > 150) {
            font = font.deriveFont(0, 24.0f);
            subFont = subFont.deriveFont(0, 12.0f);
        } else {
            font = font.deriveFont(0, 12.0f);
            subFont = subFont.deriveFont(0, 8.0f);
        }
        int returnPos = message.indexOf(10);
        g2.setColor(ColourSettings.getColor(ColourKey.GRAPH_PANE_MESSAGE));
        if (returnPos > 0) {
            this.drawMessageHelper(g2, message.substring(0, returnPos), font, w, h, -(subFont.getSize() / 2));
            this.drawMessageHelper(g2, message.substring(returnPos + 1), subFont, w, h, font.getSize() - subFont.getSize() / 2);
        } else {
            this.drawMessageHelper(g2, message, font, w, h, 0);
        }
    }

    private void drawMessageHelper(Graphics2D g2, String message, Font font, int w, int h, int offset) {
        g2.setFont(font);
        FontMetrics metrics = g2.getFontMetrics();
        Rectangle2D stringBounds = font.getStringBounds(message, g2.getFontRenderContext());
        int preferredWidth = (int)stringBounds.getWidth() + metrics.getHeight();
        int preferredHeight = (int)stringBounds.getHeight() + metrics.getHeight();
        w = Math.min(preferredWidth, w);
        h = Math.min(preferredHeight, h);
        int x = (this.getWidth() - (int)stringBounds.getWidth()) / 2;
        int y = this.getHeight() / 2 + (metrics.getAscent() - metrics.getDescent()) / 2 + offset;
        g2.drawString(message, x, y);
    }

    void showProgress(String msg, double fraction) {
        if (this.progressPanel == null) {
            this.progressPanel = new ProgressPanel(new TrackCancellationListener(this.parentFrame));
            this.add(this.progressPanel);
        }
        this.progressPanel.setMessage(msg);
        this.progressPanel.setFraction(fraction);
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExportEventListener(Listener<ExportEvent> eel) {
        List<Listener<ExportEvent>> list = this.exportListeners;
        synchronized (list) {
            this.exportListeners.add(eel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExportListener(Listener<ExportEvent> eel) {
        List<Listener<ExportEvent>> list = this.exportListeners;
        synchronized (list) {
            this.exportListeners.remove(eel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExportListeners() {
        List<Listener<ExportEvent>> list = this.exportListeners;
        synchronized (list) {
            this.exportListeners.clear();
        }
    }

    public void fireExportEvent(Range range, BufferedImage image) {
        int size = this.exportListeners.size();
        for (int i = 0; i < size; ++i) {
            this.exportListeners.get(i).handleEvent(new ExportEvent(range, image));
            size = this.exportListeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addPopupListener(Listener<PopupEvent> pel) {
        List<Listener<PopupEvent>> list = this.popupListeners;
        synchronized (list) {
            this.popupListeners.add(pel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePopupListener(Listener<PopupEvent> eel) {
        List<Listener<PopupEvent>> list = this.popupListeners;
        synchronized (list) {
            this.popupListeners.remove(eel);
        }
    }

    @Override
    public void firePopupEvent(PopupPanel popup) {
        int size = this.popupListeners.size();
        for (int i = 0; i < size; ++i) {
            this.popupListeners.get(i).handleEvent(new PopupEvent(popup));
            size = this.popupListeners.size();
        }
    }

    @Override
    public void setScaledToFit(boolean value) {
        if (this.scaledToFit != value) {
            this.scaledToFit = value;
            if (value) {
                this.requestHeight(this.getViewportHeight());
            }
            this.renderRequired = true;
            this.repaint();
        }
    }

    @Override
    public boolean isScaledToFit() {
        return this.scaledToFit;
    }

    @Override
    public boolean needsToResize() {
        if (!this.scaledToFit) {
            int currentHeight = this.getHeight();
            int expectedHeight = (int)((double)(this.yMax - this.yMin) * this.unitHeight);
            if ((expectedHeight = Math.max(expectedHeight, this.parentFrame.getFrameLandscape().getHeight())) != currentHeight) {
                this.requestHeight(expectedHeight);
                return true;
            }
        }
        return false;
    }

    protected void updateYMax() {
        this.parentFrame.updateYMax(this.yMax);
    }
}

