/*
 * Decompiled with CFR 0.152.
 */
package savant.view.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JPanel;
import savant.api.event.LocationChangedEvent;
import savant.api.util.Listener;
import savant.controller.GenomeController;
import savant.controller.LocationController;
import savant.data.types.Genome;
import savant.util.MiscUtils;
import savant.util.Range;

public class RangeSelectionPanel
extends JPanel
implements Listener<LocationChangedEvent> {
    private static final AlphaComposite COMPOSITE_50 = AlphaComposite.getInstance(3, 0.5f);
    private static final AlphaComposite COMPOSITE_75 = AlphaComposite.getInstance(3, 0.75f);
    static final Color LINE_COLOUR = new Color(100, 100, 100);
    private boolean isMouseInside = false;
    private boolean isDragging = false;
    private int maximum = 100;
    private final JLabel mousePosition;
    int x1;
    int x2;
    int x_notdragging;
    private final JLabel recStart;
    private final JLabel recStop;
    private final JLabel coords;
    boolean isNewRect = true;
    private boolean rangeChangedExternally;
    private LocationController locationController = LocationController.getInstance();

    public RangeSelectionPanel() {
        this.mousePosition = new JLabel();
        this.mousePosition.setHorizontalAlignment(0);
        this.add((Component)this.mousePosition, "Center");
        this.recStart = new JLabel();
        this.add((Component)this.recStart, "West");
        this.recStop = new JLabel();
        this.add((Component)this.recStop, "East");
        this.coords = new JLabel();
        this.add((Component)this.coords, "North");
        this.setToolTipText("Click and drag to select a subregion of the reference");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                RangeSelectionPanel.this.x1 = event.getX();
                if (RangeSelectionPanel.this.x1 < 1) {
                    RangeSelectionPanel.this.x1 = 1;
                }
                if (RangeSelectionPanel.this.x1 > RangeSelectionPanel.this.getWidth()) {
                    RangeSelectionPanel.this.x1 = RangeSelectionPanel.this.getWidth();
                }
                RangeSelectionPanel.this.isNewRect = true;
                RangeSelectionPanel.this.rangeChangedExternally = false;
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                boolean wasDragging = RangeSelectionPanel.this.isDragging;
                RangeSelectionPanel.this.isDragging = false;
                RangeSelectionPanel.this.x2 = event.getX();
                if (RangeSelectionPanel.this.x2 < 1) {
                    RangeSelectionPanel.this.x2 = 1;
                } else if (RangeSelectionPanel.this.x2 > RangeSelectionPanel.this.getWidth()) {
                    RangeSelectionPanel.this.x2 = RangeSelectionPanel.this.getWidth();
                }
                RangeSelectionPanel.this.repaint();
                int st = RangeSelectionPanel.this.x1;
                int end = RangeSelectionPanel.this.x2;
                if (RangeSelectionPanel.this.x1 > RangeSelectionPanel.this.x2) {
                    st = RangeSelectionPanel.this.x2;
                    end = RangeSelectionPanel.this.x1;
                }
                int startRange = Math.max(RangeSelectionPanel.this.translatePixelToPosition(st), RangeSelectionPanel.this.locationController.getMaxRangeStart());
                int endRange = wasDragging ? RangeSelectionPanel.this.translatePixelToPosition(end) : startRange + RangeSelectionPanel.this.locationController.getRange().getLength() - 1;
                endRange = Math.min(endRange, RangeSelectionPanel.this.locationController.getMaxRangeEnd());
                RangeSelectionPanel.this.locationController.setLocation(startRange, endRange);
            }

            @Override
            public void mouseEntered(MouseEvent event) {
                RangeSelectionPanel.this.setCursor(new Cursor(1));
                RangeSelectionPanel.this.isMouseInside = true;
            }

            @Override
            public void mouseExited(MouseEvent event) {
                RangeSelectionPanel.this.setCursor(new Cursor(0));
                RangeSelectionPanel.this.isMouseInside = false;
                RangeSelectionPanel.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent event) {
                RangeSelectionPanel.this.isDragging = true;
                RangeSelectionPanel.this.x2 = event.getX();
                if (RangeSelectionPanel.this.x2 < 1) {
                    RangeSelectionPanel.this.x2 = 1;
                } else if (RangeSelectionPanel.this.x2 > RangeSelectionPanel.this.getWidth()) {
                    RangeSelectionPanel.this.x2 = RangeSelectionPanel.this.getWidth();
                }
                RangeSelectionPanel.this.isNewRect = false;
                RangeSelectionPanel.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent event) {
                RangeSelectionPanel.this.x_notdragging = event.getX();
                RangeSelectionPanel.this.repaint();
            }
        });
        this.setVisible(true);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        try {
            int selEnd;
            int selStart;
            Genome.Cytoband[] bands = null;
            Genome genome = GenomeController.getInstance().getGenome();
            if (genome != null) {
                bands = genome.getCytobands(this.locationController.getReferenceName());
            }
            BufferedImage barUnselectedGlossyImage = ImageIO.read(this.getClass().getResource("/savant/images/bar_unselected_glossy.png"));
            BufferedImage leftCapImage = ImageIO.read(this.getClass().getResource("/savant/images/round_cap_left_bordered.png"));
            BufferedImage rightCapImage = ImageIO.read(this.getClass().getResource("/savant/images/round_cap_right_bordered.png"));
            int width = this.getWidth();
            int height = this.getHeight();
            Graphics2D g2d = (Graphics2D)g;
            Composite originalComposite = g2d.getComposite();
            g2d.setComposite(COMPOSITE_75);
            g.drawImage(barUnselectedGlossyImage, 0, 0, width, height, this);
            g2d.setComposite(originalComposite);
            g.setColor(LINE_COLOUR);
            g.drawLine(0, 0, width, 0);
            if (this.locationController.getRange() == null) {
                g.drawLine(0, height - 1, width, height - 1);
                return;
            }
            String bandPos = "";
            if (bands != null) {
                int centromereStart = -1;
                g2d.setComposite(COMPOSITE_50);
                for (Genome.Cytoband b : bands) {
                    int bandX = MiscUtils.transformPositionToPixel(b.start, width, this.locationController.getMaxRange());
                    int bandWidth = MiscUtils.transformPositionToPixel(b.end, this.getWidth(), this.locationController.getMaxRange()) - bandX;
                    if (this.isMouseInside && this.x_notdragging >= bandX && this.x_notdragging <= bandX + bandWidth) {
                        bandPos = " (" + b.name + ")";
                    }
                    g.setColor(b.getColor());
                    g.fillRect(bandX, 1, bandWidth, height - 2);
                    if (!b.isCentromere()) continue;
                    if (centromereStart >= 0) {
                        int mid = height / 2;
                        g2d.setComposite(originalComposite);
                        Polygon bowtie = new Polygon(new int[]{centromereStart, bandX, centromereStart, bandX + bandWidth, bandX, bandX + bandWidth}, new int[]{0, mid, height, height, mid, 0}, 6);
                        g.setColor(this.getBackground());
                        g.fillPolygon(bowtie);
                        g.setColor(LINE_COLOUR);
                        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g.drawLine(centromereStart - 1, 0, bandX, mid);
                        g.drawLine(centromereStart - 1, height, bandX, mid);
                        g.drawLine(bandX, mid, bandX + bandWidth, 0);
                        g.drawLine(bandX, mid, bandX + bandWidth, height);
                        g2d.setComposite(COMPOSITE_50);
                        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
                        continue;
                    }
                    centromereStart = bandX;
                }
                g2d.setComposite(originalComposite);
            }
            int startRange = this.locationController.getRangeStart();
            int endRange = this.locationController.getRangeEnd();
            if (this.isDragging) {
                selStart = this.x1 < this.x2 ? this.x1 : this.x2;
                selEnd = selStart + Math.max(2, Math.abs(this.x1 - this.x2));
            } else {
                selStart = MiscUtils.transformPositionToPixel(startRange, width, this.locationController.getMaxRange());
                selEnd = MiscUtils.transformPositionToPixel(endRange, width, this.locationController.getMaxRange());
                if (selEnd < selStart + 5) {
                    selEnd = selStart + 5;
                }
            }
            g.setColor(new Color(167, 201, 236));
            g2d.setComposite(COMPOSITE_75);
            g.fillRect(selStart, 0, selEnd - selStart, height);
            g2d.setComposite(originalComposite);
            g.setColor(LINE_COLOUR);
            g.drawLine(0, height - 1, selStart, height - 1);
            g.drawLine(selStart, height - 1, selStart, 0);
            g.drawLine(selStart, 0, selEnd, 0);
            g.drawLine(selEnd, 0, selEnd, height - 1);
            g.drawLine(selEnd, height - 1, width, height - 1);
            g.drawImage(leftCapImage, 0, 0, 20, 23, this);
            g.drawImage(rightCapImage, width - 20, 0, 20, 23, this);
            if (this.isDragging) {
                String to;
                String from;
                g.setColor(Color.black);
                int fromX = this.x1 > this.x2 ? this.x2 : this.x1;
                int toX = this.x1 > this.x2 ? this.x1 : this.x2;
                int ypos = this.getHeight() / 2 + 4;
                if (this.rangeChangedExternally) {
                    from = MiscUtils.posToShortString(startRange);
                    to = MiscUtils.posToShortString(endRange);
                } else {
                    from = MiscUtils.posToShortString(MiscUtils.transformPixelToPosition(fromX, width, this.locationController.getMaxRange()));
                    to = MiscUtils.posToShortString(MiscUtils.transformPixelToPosition(toX, width, this.locationController.getMaxRange()));
                }
                FontMetrics metrics = g.getFontMetrics(g.getFont());
                int fromWidth = metrics.stringWidth(from);
                int toWidth = metrics.stringWidth(to);
                int startFrom = fromX - 7 - fromWidth;
                int startTo = toX + 7;
                if (startFrom + fromWidth + 12 < startTo) {
                    if (startFrom > 0) {
                        g.drawString(from, startFrom, ypos);
                    }
                    if (startTo + toWidth < width) {
                        g.drawString(to, startTo, ypos);
                    }
                }
            } else if (this.isMouseInside) {
                g.setColor(Color.black);
                FontMetrics metrics = g.getFontMetrics(g.getFont());
                int genomepos = this.translatePixelToPosition(this.x_notdragging);
                String mousePos = MiscUtils.posToShortString(genomepos) + bandPos;
                g.drawString(mousePos, this.x_notdragging - metrics.stringWidth(mousePos) - 12, height / 2 + 4);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setMaximum(int max) {
        this.maximum = max - 1;
    }

    public void setRange(int lower, int upper) {
        this.setRange(new Range(lower, upper));
    }

    public void setRange(Range r) {
        this.x1 = this.translatePositionToPixel(r.getFrom());
        this.x2 = this.translatePositionToPixel(r.getTo());
        this.getParent().repaint();
        this.repaint();
    }

    public int getLowerPosition() {
        return this.translatePixelToPosition(this.x1);
    }

    public int getUpperPosition() {
        return this.translatePixelToPosition(this.x2);
    }

    private int translatePixelToPosition(int pixel) {
        return (int)((double)pixel * (double)this.maximum / (double)this.getWidth());
    }

    private int translatePositionToPixel(int position) {
        return (int)(((double)position * (double)this.getWidth() - 4.0) / (double)this.maximum) + 1;
    }

    @Override
    public void handleEvent(LocationChangedEvent event) {
        if (event.isNewReference()) {
            Genome loadedGenome = GenomeController.getInstance().getGenome();
            this.setMaximum(loadedGenome.getLength());
        }
        this.rangeChangedExternally = true;
        this.setRange((Range)event.getRange());
    }
}

