/*
 * Decompiled with CFR 0.152.
 */
package savant.view.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.event.LocationChangedEvent;
import savant.api.util.Listener;
import savant.controller.GraphPaneController;
import savant.controller.LocationController;
import savant.controller.event.GraphPaneEvent;
import savant.util.MiscUtils;
import savant.util.Range;
import savant.view.swing.Savant;

public class Ruler
extends JPanel {
    private static final Log LOG = LogFactory.getLog(Ruler.class);
    static final int CAP_HEIGHT = 23;
    static final int CAP_WIDTH = 20;
    static final int CAP_IMAGE_WIDTH = 8;
    static final AlphaComposite COMPOSITE_85 = AlphaComposite.getInstance(3, 0.75f);
    private final JLabel mousePosition;
    private final JLabel recStart;
    private final JLabel recStop;
    private final JLabel cords;
    private GraphPaneController graphPaneController = GraphPaneController.getInstance();
    private LocationController locationController = LocationController.getInstance();

    public Ruler() {
        this.mousePosition = new JLabel();
        this.mousePosition.setHorizontalAlignment(0);
        this.add((Component)this.mousePosition, "Center");
        this.recStart = new JLabel();
        this.add((Component)this.recStart, "West");
        this.recStop = new JLabel();
        this.add((Component)this.recStop, "East");
        this.cords = new JLabel();
        this.add((Component)this.cords, "North");
        this.graphPaneController.addListener(new Listener<GraphPaneEvent>(){

            @Override
            public void handleEvent(GraphPaneEvent event) {
                if (Ruler.this.graphPaneController.isPanning()) {
                    Ruler.this.repaint();
                }
            }
        });
        this.locationController.addListener(new Listener<LocationChangedEvent>(){

            @Override
            public void handleEvent(LocationChangedEvent event) {
                Ruler.this.repaint();
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.graphPaneController.isPanning()) {
            int fromX = MiscUtils.transformPositionToPixel(this.graphPaneController.getMouseClickPosition(), this.getWidth(), this.locationController.getRange());
            int toX = MiscUtils.transformPositionToPixel(this.graphPaneController.getMouseReleasePosition(), this.getWidth(), this.locationController.getRange());
            g.translate(toX - fromX, 0);
        }
        this.renderBackground(g);
    }

    private void renderBackground(Graphics g) {
        int pos;
        Graphics2D g2 = (Graphics2D)g;
        try {
            BufferedImage image = ImageIO.read(this.getClass().getResource("/savant/images/bar_selected_glossy.png"));
            Composite originalComposite = ((Graphics2D)g).getComposite();
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.85f));
            g.drawImage(image, -this.getWidth(), 0, this.getWidth() * 3, this.getHeight(), this);
            ((Graphics2D)g).setComposite(originalComposite);
        }
        catch (Exception e) {
            LOG.error((Object)"Error drawing image background");
        }
        Range r = this.locationController.getRange();
        if (r == null) {
            return;
        }
        int[] tickPositions = MiscUtils.getTickPositions(r);
        int separation = tickPositions.length > 1 ? tickPositions[1] - tickPositions[0] : 0;
        int xEnd = Integer.MIN_VALUE;
        FontMetrics fm = g2.getFontMetrics();
        for (int p : tickPositions) {
            int x = MiscUtils.transformPositionToPixel(p, this.getWidth(), r);
            if (x <= xEnd + 10) continue;
            g2.setColor(new Color(50, 50, 50, 50));
            g2.drawLine(x, 0, x, this.getHeight());
            String numStr = MiscUtils.posToShortStringWithSeparation(p, separation);
            g2.setColor(Color.black);
            g2.drawString(numStr, x + 3, this.getHeight() / 2 + 3);
            xEnd = x + fm.stringWidth(numStr) + 3;
        }
        if (r.getLength() >= this.locationController.getRangeStart()) {
            try {
                BufferedImage image_left_cap = ImageIO.read(this.getClass().getResource("/savant/images/round_cap_left_bordered.png"));
                pos = this.getLeftCapPos();
                g.drawImage(image_left_cap, pos, 0, 20, 23, this);
                g.setColor(Savant.getInstance().getBackground());
                g.fillRect(pos, 0, -this.getWidth(), this.getHeight());
            }
            catch (IOException ex) {
                LOG.error((Object)"Drawing failed.", (Throwable)ex);
            }
        }
        if (r.getLength() >= this.locationController.getMaxRangeEnd() - this.locationController.getRangeEnd()) {
            try {
                BufferedImage image_right_cap = ImageIO.read(this.getClass().getResource("/savant/images/round_cap_right_bordered.png"));
                pos = MiscUtils.transformPositionToPixel(this.locationController.getMaxRangeEnd(), this.getWidth(), this.locationController.getRange());
                g.drawImage(image_right_cap, pos - 20, 0, 20, 23, this);
                g.setColor(Savant.getInstance().getBackground());
                g.fillRect(pos, 0, this.getWidth(), this.getHeight());
            }
            catch (IOException ex) {
                LOG.error((Object)"Drawing failed.", (Throwable)ex);
            }
        }
    }

    int getLeftCapPos() {
        return MiscUtils.transformPositionToPixel(1, this.getWidth(), this.locationController.getRange());
    }
}

