/*
 * Decompiled with CFR 0.152.
 */
package savant.view.swing.start;

import com.jidesoft.swing.AutoResizingTextArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import savant.api.util.DialogUtils;
import savant.controller.ProjectController;
import savant.controller.RecentProjectsController;
import savant.settings.BrowserSettings;
import savant.util.swing.HyperlinkButton;
import savant.view.icon.SavantIconFactory;

public class WelcomePage
extends JPanel {
    private static final Color TEXT_COLOR = Color.BLACK;
    private static final Font TITLE_FONT = new Font("Arial", 1, 13);
    private static final Font DATE_FONT = new Font("Arial", 2, 12);
    private static final Border INFO_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createLineBorder(Color.WHITE, 10));

    public WelcomePage() {
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setOpaque(false);
        p.add(Box.createVerticalStrut(100));
        p.add(new SpiralPanel());
        p.add(this.align(0, this.createLabel("v2.0.4 " + BrowserSettings.BUILD)));
        p.add(Box.createVerticalStrut(20));
        p.add(this.align(-1, this.createBoldLabel("Recent Projects")));
        p.add(this.getRecentProjectsInnerPanel());
        p.add(Box.createVerticalGlue());
        this.add((Component)WelcomePage.getSidePanel(), "West");
        this.add((Component)p, "Center");
        this.add((Component)WelcomePage.getSidePanel(), "East");
    }

    private static JPanel getSidePanel() {
        int width = (int)Math.round(Toolkit.getDefaultToolkit().getScreenSize().getWidth() * 0.15);
        JPanel p = new JPanel();
        p.setOpaque(false);
        Dimension d = new Dimension(width, 1);
        p.setMinimumSize(d);
        p.setPreferredSize(d);
        return p;
    }

    private JComponent align(int dir, JComponent c) {
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new BoxLayout(p, 0));
        Component glue = Box.createHorizontalGlue();
        switch (dir) {
            case -1: {
                p.add(c);
                p.add(glue);
                break;
            }
            case 0: {
                p.add(glue);
                p.add(c);
                p.add(Box.createHorizontalGlue());
                break;
            }
            case 1: {
                p.add(glue);
                p.add(c);
                break;
            }
            default: {
                p.add(c);
                p.add(glue);
            }
        }
        return p;
    }

    private JPanel getRecentProjectsInnerPanel() {
        JPanel p = new JPanel();
        p.setBorder(INFO_BORDER);
        p.setBackground(Color.WHITE);
        p.setLayout(new BoxLayout(p, 1));
        try {
            List<String> projects = RecentProjectsController.getInstance().getRecentProjects();
            for (final String t : projects) {
                p.add(this.align(-1, HyperlinkButton.createHyperlinkButton(t, Color.black, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            ProjectController.getInstance().loadProjectFromFile(new File(t));
                        }
                        catch (Exception x) {
                            DialogUtils.displayException("Project Error", String.format("<html>Unable to load project <i>%s</i>: %s.</html>", t, x), x);
                        }
                    }
                })));
            }
            if (projects.isEmpty()) {
                p.add(this.align(-1, this.createLabel("No recent projects")));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return p;
    }

    private JLabel createLabel(String lab) {
        JLabel l = new JLabel(lab);
        l.setOpaque(false);
        l.setForeground(Color.BLACK);
        l.setAlignmentX(0.0f);
        return l;
    }

    private JLabel createBoldLabel(String lab) {
        JLabel l = this.createLabel(lab);
        l.setFont(l.getFont().deriveFont(1));
        return l;
    }

    private JLabel createSmallLabel(String lab) {
        JLabel l = this.createLabel(lab);
        l.setFont(l.getFont().deriveFont(0, 11.0f));
        return l;
    }

    private JPanel parseNewsFile(File newsFile) {
        JPanel p = null;
        try {
            p = new JPanel();
            p.setBackground(Color.WHITE);
            p.setOpaque(true);
            BoxLayout bl = new BoxLayout(p, 1);
            p.setLayout(bl);
            Document d = new SAXBuilder().build(newsFile);
            Element root = d.getRootElement();
            List newsEntries = root.getChildren("entry");
            HashMap<TextAttribute, Integer> underlining = new HashMap<TextAttribute, Integer>();
            underlining.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
            Font underlined = this.getFont().deriveFont(underlining);
            for (Element e : newsEntries) {
                String text = e.getChildText("description");
                AutoResizingTextArea ta = new AutoResizingTextArea(text);
                ta.setMaximumSize(new Dimension(99999, 1));
                ta.setForeground(TEXT_COLOR);
                ta.setLineWrap(true);
                ta.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        e.consume();
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        e.consume();
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        e.consume();
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        e.consume();
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        e.consume();
                    }
                });
                ta.setOpaque(false);
                ta.setWrapStyleWord(true);
                ta.setEditable(false);
                JLabel title = new JLabel(e.getChildText("title"));
                title.setFont(TITLE_FONT);
                title.setForeground(TEXT_COLOR);
                JLabel date = new JLabel(e.getChildText("date"));
                date.setFont(DATE_FONT);
                date.setForeground(TEXT_COLOR);
                p.add(Box.createVerticalStrut(10));
                title.setAlignmentX(0.0f);
                p.add(title);
                date.setAlignmentX(0.0f);
                p.add(date);
                ta.setAlignmentX(0.0f);
                p.add((Component)ta);
                final String more = e.getChildText("more");
                if (more == null || more.length() <= 0) continue;
                JLabel link = new JLabel("More...");
                link.setForeground(TEXT_COLOR);
                link.setFont(underlined);
                link.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        try {
                            Desktop.getDesktop().browse(URI.create(more));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                p.add(link);
            }
            p.add(Box.createVerticalGlue());
        }
        catch (Exception e) {
            JLabel l = new JLabel("Problem getting news");
            l.setForeground(TEXT_COLOR);
            p.add(l);
        }
        return p;
    }

    private static class SpiralPanel
    extends JPanel {
        private final Image img = SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.LOGO).getImage();

        public SpiralPanel() {
            this.setMinimumSize(new Dimension(999, 150));
            this.setPreferredSize(new Dimension(999, 150));
            this.setMaximumSize(new Dimension(999, 150));
        }

        @Override
        public void paintComponent(Graphics g) {
            g.drawImage(this.img, this.getWidth() / 2 - this.img.getWidth(null) / 2, this.getHeight() / 2 - this.img.getHeight(null) / 2, null);
        }
    }
}

