/*
 * Decompiled with CFR 0.152.
 */
package savant.view.tracks;

import savant.api.adapter.DataSourceAdapter;
import savant.api.adapter.RangeAdapter;
import savant.api.util.Resolution;
import savant.exception.SavantTrackCreationCancelledException;
import savant.settings.ResolutionSettings;
import savant.util.AxisRange;
import savant.util.AxisType;
import savant.util.ColourKey;
import savant.util.ColourScheme;
import savant.util.DrawingInstruction;
import savant.util.Range;
import savant.view.tracks.ContinuousTrackRenderer;
import savant.view.tracks.Track;

public class BAMCoverageTrack
extends Track {
    public BAMCoverageTrack(DataSourceAdapter dataSource) throws SavantTrackCreationCancelledException {
        super(dataSource, new ContinuousTrackRenderer());
    }

    @Override
    public void prepareForRendering(String ref, Range r) {
        Resolution res = this.getResolution(r);
        if (res != Resolution.HIGH) {
            this.renderer.addInstruction(DrawingInstruction.PROGRESS, "Retrieving coverage data...");
            this.renderer.addInstruction(DrawingInstruction.AXIS_RANGE, new AxisRange(r, new Range(0, 1)));
            this.requestData(ref, r);
        } else {
            this.saveNullData(r);
        }
        this.renderer.addInstruction(DrawingInstruction.REFERENCE_EXISTS, this.containsReference(ref));
        this.renderer.addInstruction(DrawingInstruction.COLOUR_SCHEME, this.getColourScheme());
        this.renderer.addInstruction(DrawingInstruction.RANGE, r);
        this.renderer.addInstruction(DrawingInstruction.RESOLUTION, (Object)res);
        this.renderer.addInstruction(DrawingInstruction.SELECTION_ALLOWED, true);
    }

    @Override
    public ColourScheme getDefaultColourScheme() {
        return new ColourScheme(ColourKey.CONTINUOUS_FILL, ColourKey.CONTINUOUS_LINE);
    }

    @Override
    public Resolution getResolution(RangeAdapter range) {
        switch (this.getDrawingMode()) {
            case ARC_PAIRED: {
                return range.getLength() > ResolutionSettings.getBAMArcModeLowToHighThreshold() ? Resolution.LOW : Resolution.HIGH;
            }
        }
        return range.getLength() > ResolutionSettings.getBAMLowToHighThreshold() ? Resolution.LOW : Resolution.HIGH;
    }

    @Override
    public AxisType getYAxisType(Resolution r) {
        return r == Resolution.HIGH ? AxisType.NONE : AxisType.REAL;
    }
}

