/*
 * Decompiled with CFR 0.152.
 */
package savant.view.tracks;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.adapter.GraphPaneAdapter;
import savant.api.data.Interval;
import savant.api.data.IntervalRecord;
import savant.api.data.Record;
import savant.api.data.Strand;
import savant.api.data.VariantType;
import savant.api.event.DataRetrievalEvent;
import savant.api.util.Resolution;
import savant.controller.GenomeController;
import savant.controller.LocationController;
import savant.data.types.BAMIntervalRecord;
import savant.data.types.Genome;
import savant.data.types.PileupRecord;
import savant.exception.RenderingException;
import savant.util.AxisRange;
import savant.util.ColourAccumulator;
import savant.util.ColourKey;
import savant.util.ColourScheme;
import savant.util.DrawingInstruction;
import savant.util.DrawingMode;
import savant.util.IntervalPacker;
import savant.util.MiscUtils;
import savant.util.Pileup;
import savant.util.Range;
import savant.util.SAMReadUtils;
import savant.view.tracks.BAMTrack;
import savant.view.tracks.TrackRenderer;

public class BAMTrackRenderer
extends TrackRenderer {
    private static final Log LOG = LogFactory.getLog(BAMTrackRenderer.class);
    private static final Font MISMATCH_FONT = LEGEND_FONT.deriveFont(8.0f);
    private byte[] refSeq = null;
    private DrawingMode lastMode;
    private Resolution lastResolution;
    private double arrowWidth;

    @Override
    public void handleEvent(DataRetrievalEvent evt) {
        switch (evt.getType()) {
            case COMPLETED: {
                if ((DrawingMode)((Object)this.instructions.get((Object)DrawingInstruction.MODE)) != DrawingMode.ARC_PAIRED) break;
                int maxDataValue = Math.max(BAMTrack.getArcYMax(evt.getData()), 1);
                Range range = (Range)this.instructions.get((Object)DrawingInstruction.RANGE);
                this.addInstruction(DrawingInstruction.AXIS_RANGE, new AxisRange(range, new Range(0, (int)Math.round((double)maxDataValue + (double)maxDataValue * 0.1))));
            }
        }
        super.handleEvent(evt);
    }

    @Override
    public void render(Graphics2D g2, GraphPaneAdapter gp) throws RenderingException {
        Genome genome;
        DrawingMode oldMode = this.lastMode;
        this.lastMode = (DrawingMode)((Object)this.instructions.get((Object)DrawingInstruction.MODE));
        Resolution res = (Resolution)((Object)this.instructions.get((Object)DrawingInstruction.RESOLUTION));
        if (res == Resolution.HIGH && this.lastMode != DrawingMode.STANDARD && this.lastMode != DrawingMode.SEQUENCE && (genome = GenomeController.getInstance().getGenome()).isSequenceSet()) {
            AxisRange axisRange = (AxisRange)this.instructions.get((Object)DrawingInstruction.AXIS_RANGE);
            String ref = LocationController.getInstance().getReferenceName();
            Range r = axisRange.getXRange();
            try {
                this.refSeq = genome.getSequence(ref, r);
            }
            catch (Exception e) {
                throw new RenderingException(e.getMessage(), 3);
            }
            if (this.refSeq == null) {
                throw new RenderingException("No sequence data for " + ref + "\nSwitch to standard display mode", 2);
            }
        }
        if (this.lastMode != DrawingMode.ARC_PAIRED && this.lastMode != DrawingMode.SNP && this.lastMode != DrawingMode.STRAND_SNP) {
            if (this.lastResolution != res || oldMode == DrawingMode.ARC_PAIRED || oldMode == DrawingMode.SNP || oldMode == DrawingMode.STRAND_SNP) {
                if (res == Resolution.HIGH) {
                    gp.getParentFrame().setHeightFromSlider();
                } else {
                    gp.setScaledToFit(true);
                }
                this.lastResolution = res;
            }
        } else if (oldMode != DrawingMode.ARC_PAIRED && oldMode != DrawingMode.SNP && oldMode != DrawingMode.STRAND_SNP) {
            gp.setScaledToFit(true);
        }
        this.renderPreCheck();
        switch (this.lastMode) {
            case STANDARD: 
            case MISMATCH: 
            case SEQUENCE: {
                if (res != Resolution.HIGH) break;
                this.renderPackMode(g2, gp, res);
                break;
            }
            case STANDARD_PAIRED: {
                if (res != Resolution.HIGH) break;
                this.renderStandardPairedMode(g2, gp);
                break;
            }
            case ARC_PAIRED: {
                this.renderArcPairedMode(g2, gp);
                break;
            }
            case SNP: {
                if (res != Resolution.HIGH) break;
                this.renderSNPMode(g2, gp, res);
                break;
            }
            case STRAND_SNP: {
                if (res != Resolution.HIGH) break;
                this.renderStrandSNPMode(g2, gp, res);
            }
        }
        if (this.data.isEmpty()) {
            throw new RenderingException("No data in range", 1);
        }
    }

    private void renderPackMode(Graphics2D g2, GraphPaneAdapter gp, Resolution r) throws RenderingException {
        Genome genome;
        if (this.lastMode == DrawingMode.MISMATCH && !(genome = GenomeController.getInstance().getGenome()).isSequenceSet()) {
            throw new RenderingException("No reference sequence loaded\nSwitch to standard display mode", 2);
        }
        AxisRange axisRange = (AxisRange)this.instructions.get((Object)DrawingInstruction.AXIS_RANGE);
        Range range = axisRange.getXRange();
        if (!gp.isScaledToFit()) {
            this.arrowWidth = gp.getUnitHeight() * 0.25;
        }
        double pixelsPerBase = Math.max(0.01, (double)gp.getWidth() / (double)range.getLength());
        int breathingRoom = (int)Math.ceil(2.0 * (this.arrowWidth / pixelsPerBase) + 2.0);
        List<List<IntervalRecord>> intervals = new IntervalPacker(this.data).pack(breathingRoom);
        gp.setXRange(range);
        int numIntervals = intervals.size();
        int maxYRange = numIntervals <= 10 ? 10 : (numIntervals <= 20 ? 20 : (numIntervals <= 50 ? 50 : (numIntervals <= 100 ? 100 : numIntervals)));
        gp.setYRange(new Range(0, maxYRange));
        if (gp.needsToResize()) {
            return;
        }
        for (int level = 0; level < intervals.size(); ++level) {
            List<IntervalRecord> intervalsThisLevel = intervals.get(level);
            for (IntervalRecord intervalRecord : intervalsThisLevel) {
                BAMIntervalRecord bamRecord = (BAMIntervalRecord)intervalRecord;
                if (bamRecord.getSAMRecord().getReadUnmappedFlag()) {
                    this.recordToShapeMap.put(intervalRecord, null);
                    continue;
                }
                Shape readshape = this.renderRead(g2, gp, bamRecord, level, range, gp.getUnitHeight());
                this.recordToShapeMap.put(intervalRecord, readshape);
            }
        }
    }

    private Shape renderRead(Graphics2D g2, GraphPaneAdapter gp, BAMIntervalRecord rec, int level, Range range, double readHeight) {
        SAMRecord samRec = rec.getSAMRecord();
        boolean reverseStrand = samRec.getReadNegativeStrandFlag();
        ColourScheme cs = (ColourScheme)this.instructions.get((Object)DrawingInstruction.COLOUR_SCHEME);
        Color readColor = cs.getColor(reverseStrand ? ColourKey.REVERSE_STRAND : ColourKey.FORWARD_STRAND);
        Color override = rec.getColor();
        if (override != null) {
            readColor = override;
        }
        if (((Boolean)this.instructions.get((Object)DrawingInstruction.MAPPING_QUALITY)).booleanValue()) {
            int alpha = BAMTrackRenderer.getConstrainedAlpha(samRec.getMappingQuality());
            readColor = new Color(readColor.getRed(), readColor.getGreen(), readColor.getBlue(), alpha);
        }
        double leftMostX = gp.transformXPos(range.getFrom());
        double rightMostX = gp.transformXPos(range.getTo() + 1);
        double x = gp.transformXPos(rec.getInterval().getStart());
        double y = gp.transformYPos(0.0) - (double)(level + 1) * readHeight - (double)gp.getOffset();
        double w = (double)rec.getInterval().getLength() * gp.getUnitWidth();
        double x2 = rightMostX < x + w ? rightMostX : x + w;
        if (leftMostX > x) {
            x = leftMostX;
        }
        w = x2 - x;
        Shape pointyBar = this.getPointyBar(reverseStrand, x, y, w, readHeight);
        boolean baseQuality = (Boolean)this.instructions.get((Object)DrawingInstruction.BASE_QUALITY);
        if (this.lastMode != DrawingMode.SEQUENCE && !baseQuality) {
            g2.setColor(readColor);
            g2.fill(pointyBar);
        }
        if (this.lastMode != DrawingMode.STANDARD || baseQuality) {
            this.renderBases(g2, gp, samRec, level, this.refSeq, range, readHeight);
        }
        if (pointyBar.getBounds().getHeight() >= 4.0) {
            g2.setColor(cs.getColor(ColourKey.INTERVAL_LINE));
            g2.draw(pointyBar);
        }
        return pointyBar;
    }

    private Shape getPointyBar(boolean reverseStrand, double x, double y, double w, double h) {
        double arrowHeight = h * 0.5;
        if (w > this.arrowWidth) {
            if (reverseStrand) {
                return MiscUtils.createPolygon(x, y, x + w, y, x + w, y + h, x, y + h, x - this.arrowWidth, y + arrowHeight);
            }
            return MiscUtils.createPolygon(x, y, x + w, y, x + w + this.arrowWidth, y + arrowHeight, x + w, y + h, x, y + h);
        }
        return MiscUtils.createPolygon(x, y, x + w, y, x + w, y + h, x, y + h);
    }

    private ColourKey getSubPileColour(VariantType snpNuc, VariantType genomeNuc) {
        if (snpNuc == genomeNuc || snpNuc == VariantType.INSERTION) {
            return ColourKey.REVERSE_STRAND;
        }
        switch (snpNuc) {
            case SNP_A: {
                return ColourKey.A;
            }
            case SNP_C: {
                return ColourKey.C;
            }
            case SNP_G: {
                return ColourKey.G;
            }
            case SNP_T: {
                return ColourKey.T;
            }
            case DELETION: {
                return ColourKey.DELETED_BASE;
            }
            case OTHER: {
                return ColourKey.N;
            }
        }
        return null;
    }

    private void renderBases(Graphics2D g2, GraphPaneAdapter gp, SAMRecord samRecord, int level, byte[] refSeq, Range range, double unitHeight) {
        boolean fontFits;
        ColourScheme cs = (ColourScheme)this.instructions.get((Object)DrawingInstruction.COLOUR_SCHEME);
        boolean baseQualityEnabled = (Boolean)this.instructions.get((Object)DrawingInstruction.BASE_QUALITY);
        boolean drawingAllBases = this.lastMode == DrawingMode.SEQUENCE || baseQualityEnabled;
        double unitWidth = gp.getUnitWidth();
        int offset = gp.getOffset();
        double leftMostX = gp.transformXPos(range.getFrom());
        double rightMostX = gp.transformXPos(range.getTo()) + unitWidth;
        int alignmentStart = samRecord.getAlignmentStart();
        byte[] readBases = samRecord.getReadBases();
        byte[] baseQualities = samRecord.getBaseQualities();
        boolean sequenceSaved = readBases.length > 0;
        Cigar cigar = samRecord.getCigar();
        int sequenceCursor = alignmentStart;
        int readCursor = alignmentStart;
        ArrayList<Rectangle2D.Double> insertions = new ArrayList<Rectangle2D.Double>();
        FontMetrics fm = g2.getFontMetrics(MISMATCH_FONT);
        Rectangle2D charRect = fm.getStringBounds("G", g2);
        boolean bl = fontFits = charRect.getWidth() <= unitWidth && charRect.getHeight() <= unitHeight;
        if (fontFits) {
            g2.setFont(MISMATCH_FONT);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (CigarElement cigarElement : cigar.getCigarElements()) {
            int operatorLength = cigarElement.getLength();
            CigarOperator operator = cigarElement.getOperator();
            Rectangle2D.Double opRect = null;
            double opStart = gp.transformXPos(sequenceCursor);
            double opWidth = (double)operatorLength * unitWidth;
            double x2 = Math.min(rightMostX, opStart + opWidth);
            opStart = Math.max(leftMostX, opStart);
            opWidth = x2 - opStart;
            switch (operator) {
                case D: {
                    if (!(opWidth > 0.0)) break;
                    this.renderDeletion(g2, gp, opStart, level, operatorLength, unitHeight);
                    break;
                }
                case I: {
                    insertions.add(new Rectangle2D.Double(gp.transformXPos(sequenceCursor), gp.transformYPos(0.0) - (double)(level + 1) * unitHeight - (double)gp.getOffset(), unitWidth, unitHeight));
                    break;
                }
                case M: 
                case X: 
                case EQ: {
                    if (!sequenceSaved && operator != CigarOperator.X) break;
                    for (int i = 0; i < operatorLength; ++i) {
                        int readIndex = readCursor - alignmentStart + i;
                        boolean mismatched = false;
                        if (operator == CigarOperator.X) {
                            mismatched = true;
                        } else {
                            int refIndex = sequenceCursor + i - range.getFrom();
                            if (refIndex >= 0 && refSeq != null && refIndex < refSeq.length) {
                                boolean bl2 = mismatched = refSeq[refIndex] != readBases[readIndex];
                            }
                        }
                        if (!mismatched && !drawingAllBases) continue;
                        Color col = mismatched && this.lastMode != DrawingMode.STANDARD || this.lastMode == DrawingMode.SEQUENCE ? cs.getBaseColor((char)readBases[readIndex]) : cs.getColor(samRecord.getReadNegativeStrandFlag() ? ColourKey.REVERSE_STRAND : ColourKey.FORWARD_STRAND);
                        if (baseQualityEnabled && col != null) {
                            col = new Color(col.getRed(), col.getGreen(), col.getBlue(), BAMTrackRenderer.getConstrainedAlpha((int)Math.round((double)baseQualities[readIndex] * 0.025 * 255.0)));
                        }
                        double xCoordinate = gp.transformXPos(sequenceCursor + i);
                        double top = gp.transformYPos(0.0) - (double)(level + 1) * unitHeight - (double)offset;
                        if (col != null) {
                            opRect = new Rectangle2D.Double(xCoordinate, top, unitWidth, unitHeight);
                            g2.setColor(col);
                            g2.fill(opRect);
                        }
                        if (this.lastMode == DrawingMode.SEQUENCE || !mismatched || !fontFits) continue;
                        g2.setColor(new Color(10, 10, 10));
                        String s = new String(readBases, readIndex, 1);
                        charRect = fm.getStringBounds(s, g2);
                        g2.drawString(s, (float)(xCoordinate + (unitWidth - charRect.getWidth()) * 0.5), (float)(top + (double)fm.getAscent() + (unitHeight - charRect.getHeight()) * 0.5));
                    }
                    break;
                }
                case N: {
                    opRect = new Rectangle2D.Double(opStart, gp.transformYPos(0.0) - (double)(level + 1) * unitHeight - (double)offset, opWidth, unitHeight);
                    g2.setColor(cs.getColor(ColourKey.SKIPPED));
                    g2.fill(opRect);
                    break;
                }
            }
            if (operator.consumesReadBases()) {
                readCursor += operatorLength;
            }
            if (!operator.consumesReferenceBases()) continue;
            sequenceCursor += operatorLength;
        }
        for (Rectangle2D rectangle2D : insertions) {
            this.drawInsertion(g2, rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
    }

    private void renderDeletion(Graphics2D g2, GraphPaneAdapter gp, double opStart, int level, int operatorLength, double unitHeight) {
        double width = (double)operatorLength * gp.getUnitWidth();
        if (width < 1.0) {
            width = 1.0;
        }
        Rectangle2D.Double opRect = new Rectangle2D.Double(opStart, gp.transformYPos(0.0) - (double)(level + 1) * unitHeight - (double)gp.getOffset(), width, unitHeight);
        g2.setColor(Color.BLACK);
        g2.fill(opRect);
    }

    private Color makeTransparent(Color c) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), 90);
    }

    private void renderArcPairedMode(Graphics2D g2, GraphPaneAdapter gp) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        LOG.debug((Object)("YMAX for ARC mode: " + ((AxisRange)this.instructions.get((Object)DrawingInstruction.AXIS_RANGE)).getYMax()));
        AxisRange axisRange = (AxisRange)this.instructions.get((Object)DrawingInstruction.AXIS_RANGE);
        ColourScheme cs = (ColourScheme)this.instructions.get((Object)DrawingInstruction.COLOUR_SCHEME);
        int discordantMin = (Integer)this.instructions.get((Object)DrawingInstruction.DISCORDANT_MIN);
        int discordantMax = (Integer)this.instructions.get((Object)DrawingInstruction.DISCORDANT_MAX);
        Color normalArcColor = this.makeTransparent(cs.getColor(ColourKey.CONCORDANT_LENGTH));
        Color invertedReadColor = this.makeTransparent(cs.getColor(ColourKey.ONE_READ_INVERTED));
        Color evertedPairColor = this.makeTransparent(cs.getColor(ColourKey.EVERTED_PAIR));
        Color discordantLengthColor = this.makeTransparent(cs.getColor(ColourKey.DISCORDANT_LENGTH));
        Color unmappedMateColor = this.makeTransparent(cs.getColor(ColourKey.UNMAPPED_MATE));
        gp.setXRange(axisRange.getXRange());
        gp.setYRange(axisRange.getYRange());
        LOG.debug((Object)("BAMTrackRenderer.renderArcMatePairMode: " + this.data.size() + " records."));
        for (Record record : this.data) {
            int intervalStart;
            int alignmentStart;
            int alignmentStart2;
            BAMIntervalRecord bamRecord = (BAMIntervalRecord)record;
            SAMRecord samRecord = bamRecord.getSAMRecord();
            SAMReadUtils.PairedSequencingProtocol prot = (SAMReadUtils.PairedSequencingProtocol)((Object)this.instructions.get((Object)DrawingInstruction.PAIRED_PROTOCOL));
            SAMReadUtils.PairMappingType type = SAMReadUtils.getPairType(samRecord, prot);
            if (!samRecord.getReadPairedFlag() || type == null) continue;
            if (samRecord.getMateUnmappedFlag()) {
                alignmentStart2 = samRecord.getAlignmentStart();
                double x = gp.transformXPos(alignmentStart2);
                double radius = 4.0;
                double top = gp.transformYPos((double)axisRange.getYRange().getTo() * 0.25) + radius;
                g2.setColor(unmappedMateColor);
                g2.setStroke(ONE_STROKE);
                Path2D.Double flower = new Path2D.Double();
                ((Path2D)flower).moveTo(x, gp.transformYPos(0.0));
                ((Path2D)flower).lineTo(x, top);
                ((Path2D)flower).moveTo(x - radius, top - radius);
                ((Path2D)flower).lineTo(x + radius, top + radius);
                ((Path2D)flower).moveTo(x - radius, top + radius);
                ((Path2D)flower).lineTo(x + radius, top - radius);
                g2.draw(flower);
                this.recordToShapeMap.put(record, flower);
                continue;
            }
            if (!samRecord.getMateReferenceName().equals(samRecord.getReferenceName())) {
                alignmentStart2 = samRecord.getAlignmentStart();
                double x = gp.transformXPos(alignmentStart2);
                double arrowWidth = 10.0;
                double arrowHeight = 15.0;
                double top = gp.transformYPos((double)axisRange.getYRange().getTo() * 0.9);
                g2.setColor(invertedReadColor);
                g2.setStroke(TWO_STROKE);
                Path2D.Double stem = new Path2D.Double();
                ((Path2D)stem).moveTo(x, gp.transformYPos(0.0));
                ((Path2D)stem).lineTo(x, top + arrowHeight);
                g2.draw(stem);
                Path2D.Double pointer = new Path2D.Double();
                ((Path2D)pointer).moveTo(x, top);
                ((Path2D)pointer).lineTo(x - arrowWidth / 2.0, top + arrowHeight);
                ((Path2D)pointer).lineTo(x + arrowWidth / 2.0, top + arrowHeight);
                ((Path2D)pointer).lineTo(x, top);
                g2.fill(pointer);
                pointer.append(stem, false);
                this.recordToShapeMap.put(record, pointer);
                continue;
            }
            int arcLength = Math.abs(samRecord.getInferredInsertSize());
            if (arcLength == 0) continue;
            int mateAlignmentStart = samRecord.getMateAlignmentStart();
            if (samRecord.getAlignmentStart() > mateAlignmentStart) {
                if (mateAlignmentStart >= LocationController.getInstance().getRangeStart()) continue;
                alignmentStart = mateAlignmentStart;
            } else {
                alignmentStart = samRecord.getAlignmentStart();
            }
            switch (type) {
                case INVERTED_READ: 
                case INVERTED_MATE: {
                    intervalStart = alignmentStart;
                    g2.setColor(invertedReadColor);
                    g2.setStroke(TWO_STROKE);
                    break;
                }
                case EVERTED: {
                    intervalStart = alignmentStart;
                    g2.setColor(evertedPairColor);
                    g2.setStroke(TWO_STROKE);
                    break;
                }
                default: {
                    intervalStart = alignmentStart;
                    if (arcLength > discordantMax || arcLength < discordantMin) {
                        g2.setColor(discordantLengthColor);
                        g2.setStroke(TWO_STROKE);
                        break;
                    }
                    g2.setColor(normalArcColor);
                    g2.setStroke(ONE_STROKE);
                }
            }
            int arcHeight = arcLength;
            double rectWidth = (double)arcLength * gp.getUnitWidth();
            double rectHeight = (double)(arcHeight * 2) * gp.getUnitHeight();
            double xOrigin = gp.transformXPos(intervalStart);
            double yOrigin = gp.transformYPos(arcHeight);
            Arc2D.Double arc = new Arc2D.Double(xOrigin, yOrigin, rectWidth, rectHeight, -180.0, -180.0, 0);
            g2.draw(arc);
            this.recordToShapeMap.put(record, arc);
        }
    }

    private void renderSNPMode(Graphics2D g2, GraphPaneAdapter gp, Resolution r) throws RenderingException {
        Genome genome = GenomeController.getInstance().getGenome();
        if (!genome.isSequenceSet()) {
            throw new RenderingException("No reference sequence loaded\nSwitch to standard display mode", 2);
        }
        AxisRange axisRange = (AxisRange)this.instructions.get((Object)DrawingInstruction.AXIS_RANGE);
        ColourScheme cs = (ColourScheme)this.instructions.get((Object)DrawingInstruction.COLOUR_SCHEME);
        ArrayList<Pileup> pileups = new ArrayList<Pileup>();
        int length = axisRange.getXMax() - axisRange.getXMin() + 1;
        assert (Math.abs(axisRange.getXMin()) <= Integer.MAX_VALUE);
        int startPosition = axisRange.getXMin();
        for (int j = 0; j < length; ++j) {
            pileups.add(new Pileup(startPosition + j));
        }
        for (Record record : this.data) {
            SAMRecord samRecord = ((BAMIntervalRecord)record).getSAMRecord();
            this.updatePileupsFromSAMRecord(pileups, samRecord, startPosition);
        }
        double maxHeight = 0.0;
        for (Pileup p : pileups) {
            int current = p.getTotalCoverage(null);
            if (!((double)current > maxHeight)) continue;
            maxHeight = current;
        }
        gp.setXRange(axisRange.getXRange());
        gp.setYRange(new Range(0, (int)Math.rint(maxHeight / 0.9)));
        double unitHeight = Math.rint(gp.transformYPos(0.0) * 0.9) / maxHeight;
        double unitWidth = gp.getUnitWidth();
        ColourAccumulator accumulator = new ColourAccumulator(cs);
        ArrayList<Rectangle2D.Double> insertions = new ArrayList<Rectangle2D.Double>();
        for (Pileup pileup : pileups) {
            double h;
            VariantType genomeNuc;
            int totalCoverage = pileup.getTotalCoverage(null);
            if (totalCoverage <= 0) continue;
            double bottom = gp.transformYPos(0.0);
            double x = gp.transformXPos(pileup.getPosition());
            VariantType snpNuc = genomeNuc = VariantType.fromChar((char)this.refSeq[pileup.getPosition() - startPosition]);
            if (totalCoverage > pileup.getCoverage(genomeNuc, null)) {
                h = unitHeight * (double)(totalCoverage - pileup.getCoverage(VariantType.INSERTION, null));
                this.recordToShapeMap.put(new PileupRecord(pileup, false), new Rectangle2D.Double(x, bottom - h, unitWidth, h));
            }
            while (genome.isSequenceSet() && (snpNuc = pileup.getLargestVariantType(genomeNuc)) != null || (snpNuc = pileup.getLargestVariantType(VariantType.OTHER)) != null) {
                h = unitHeight * (double)pileup.getCoverage(snpNuc, null);
                Rectangle2D.Double rect = new Rectangle2D.Double(x, bottom - h, unitWidth, h);
                accumulator.addShape(this.getSubPileColour(snpNuc, genomeNuc), (Shape)rect);
                if (snpNuc == VariantType.INSERTION) {
                    insertions.add(rect);
                } else {
                    bottom -= h;
                }
                pileup.clearVariantType(snpNuc);
            }
        }
        accumulator.fill(g2);
        for (Rectangle2D rectangle2D : insertions) {
            this.drawInsertion(g2, rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
    }

    private void renderStrandSNPMode(Graphics2D g2, GraphPaneAdapter gp, Resolution r) throws RenderingException {
        Genome genome = GenomeController.getInstance().getGenome();
        if (!genome.isSequenceSet()) {
            throw new RenderingException("No reference sequence loaded\nSwitch to standard display mode", 2);
        }
        AxisRange axisRange = (AxisRange)this.instructions.get((Object)DrawingInstruction.AXIS_RANGE);
        int xMin = axisRange.getXMin();
        int xMax = axisRange.getXMax();
        ColourScheme cs = (ColourScheme)this.instructions.get((Object)DrawingInstruction.COLOUR_SCHEME);
        ArrayList<Pileup> pileups = new ArrayList<Pileup>();
        for (int j = xMin; j <= xMax; ++j) {
            pileups.add(new Pileup(j));
        }
        for (Record record : this.data) {
            SAMRecord samRecord = ((BAMIntervalRecord)record).getSAMRecord();
            this.updatePileupsFromSAMRecord(pileups, samRecord, xMin);
        }
        double maxHeight = 0.0;
        for (Pileup p : pileups) {
            int current1 = p.getTotalCoverage(Strand.REVERSE);
            int current2 = p.getTotalCoverage(Strand.FORWARD);
            if ((double)current1 > maxHeight) {
                maxHeight = current1;
            }
            if (!((double)current2 > maxHeight)) continue;
            maxHeight = current2;
        }
        int yMax = (int)Math.ceil(maxHeight / 0.9);
        gp.setYRange(new Range(-yMax, yMax));
        this.instructions.put(DrawingInstruction.AXIS_RANGE, new AxisRange(xMin, xMax, -yMax, yMax));
        ColourAccumulator accumulator = new ColourAccumulator(cs);
        ArrayList<Rectangle2D.Double> insertions = new ArrayList<Rectangle2D.Double>();
        double unitHeight = gp.getUnitHeight();
        double unitWidth = gp.getUnitWidth();
        double axis = gp.transformYPos(0.0);
        for (Pileup pileup : pileups) {
            int totalCoverage;
            if (pileup.getTotalCoverage(null) <= 0) continue;
            VariantType snpNuc = null;
            double bottom = axis;
            double top = axis;
            double x = gp.transformXPos(pileup.getPosition());
            VariantType genomeNuc = null;
            if (genome.isSequenceSet()) {
                snpNuc = genomeNuc = VariantType.fromChar((char)this.refSeq[pileup.getPosition() - xMin]);
            }
            if ((totalCoverage = pileup.getTotalCoverage(null)) > pileup.getCoverage(genomeNuc, null)) {
                double h = unitHeight * (double)(totalCoverage - pileup.getCoverage(VariantType.INSERTION, null));
                this.recordToShapeMap.put(new PileupRecord(pileup, true), new Rectangle2D.Double(x, bottom - unitHeight * (double)(pileup.getTotalCoverage(Strand.FORWARD) - pileup.getCoverage(VariantType.INSERTION, Strand.FORWARD)), unitWidth, h));
            }
            while (genome.isSequenceSet() && (snpNuc = pileup.getLargestVariantType(genomeNuc)) != null || (snpNuc = pileup.getLargestVariantType(null)) != null) {
                Rectangle2D.Double rect;
                double h;
                int forwardCoverage = pileup.getCoverage(snpNuc, Strand.FORWARD);
                int reverseCoverage = pileup.getCoverage(snpNuc, Strand.REVERSE);
                ColourKey col = this.getSubPileColour(snpNuc, genomeNuc);
                if (forwardCoverage > 0) {
                    h = unitHeight * (double)forwardCoverage;
                    rect = new Rectangle2D.Double(x, bottom - h, unitWidth, h);
                    accumulator.addShape(col == ColourKey.REVERSE_STRAND ? ColourKey.FORWARD_STRAND : col, (Shape)rect);
                    if (snpNuc == VariantType.INSERTION) {
                        insertions.add(rect);
                    } else {
                        bottom -= h;
                    }
                }
                if (reverseCoverage > 0) {
                    h = unitHeight * (double)reverseCoverage;
                    rect = new Rectangle2D.Double(x, top, unitWidth, h);
                    accumulator.addShape(col, (Shape)rect);
                    if (snpNuc == VariantType.INSERTION) {
                        insertions.add(rect);
                    } else {
                        top += h;
                    }
                }
                pileup.clearVariantType(snpNuc);
            }
        }
        accumulator.fill(g2);
        for (Rectangle2D rectangle2D : insertions) {
            this.drawInsertion(g2, rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        g2.setColor(Color.BLACK);
        g2.draw(new Line2D.Double(0.0, axis, gp.getWidth(), axis));
    }

    private void updatePileupsFromSAMRecord(List<Pileup> pileups, SAMRecord samRecord, int startPosition) {
        byte[] readBases = samRecord.getReadBases();
        if (readBases.length == 0) {
            return;
        }
        Strand strand = samRecord.getReadNegativeStrandFlag() ? Strand.REVERSE : Strand.FORWARD;
        int alignmentStart = samRecord.getAlignmentStart();
        Cigar cigar = samRecord.getCigar();
        byte[] baseQualities = samRecord.getBaseQualities();
        int sequenceCursor = alignmentStart;
        int readCursor = alignmentStart;
        for (CigarElement cigarElement : cigar.getCigarElements()) {
            int operatorLength = cigarElement.getLength();
            CigarOperator operator = cigarElement.getOperator();
            switch (operator) {
                case D: {
                    for (int i = 0; i < operatorLength; ++i) {
                        int j = i + sequenceCursor - startPosition;
                        if (j < 0 || j >= pileups.size()) continue;
                        Pileup p = pileups.get(j);
                        p.pileOn(VariantType.DELETION, baseQualities[readCursor - alignmentStart], strand);
                    }
                    break;
                }
                case I: {
                    int insPos = sequenceCursor - startPosition;
                    if (insPos < 0 || insPos >= pileups.size()) break;
                    Pileup p = pileups.get(insPos);
                    p.pileOn(VariantType.INSERTION, readCursor - alignmentStart, strand);
                    break;
                }
                case M: 
                case X: {
                    for (int i = 0; i < operatorLength; ++i) {
                        int readIndex = readCursor - alignmentStart + i;
                        VariantType readN = VariantType.fromChar((char)readBases[readIndex]);
                        int j = i + sequenceCursor - startPosition;
                        if (j < 0 || j >= pileups.size()) continue;
                        Pileup p = pileups.get(j);
                        p.pileOn(readN, baseQualities[readIndex], strand);
                    }
                    break;
                }
            }
            if (operator.consumesReadBases()) {
                readCursor += operatorLength;
            }
            if (!operator.consumesReferenceBases()) continue;
            sequenceCursor += operatorLength;
        }
    }

    public void renderReadsFromArc(Graphics2D g2, GraphPaneAdapter gp, BAMIntervalRecord rec1, BAMIntervalRecord rec2, Range range) {
        int readHeight = gp.getParentFrame().getIntervalHeight();
        this.renderRead(g2, gp, rec1, 0, range, readHeight);
        if (rec2 != null) {
            this.renderRead(g2, gp, rec2, 0, range, readHeight);
        }
    }

    private void renderStandardPairedMode(Graphics2D g2, GraphPaneAdapter gp) throws RenderingException {
        AxisRange axisRange = (AxisRange)this.instructions.get((Object)DrawingInstruction.AXIS_RANGE);
        ColourScheme cs = (ColourScheme)this.instructions.get((Object)DrawingInstruction.COLOUR_SCHEME);
        Color linecolor = cs.getColor(ColourKey.INTERVAL_LINE);
        Range range = axisRange.getXRange();
        int effectiveEnd = range.getTo() + 1;
        int effectiveStart = range.getFrom() - 1;
        gp.setXRange(axisRange.getXRange());
        HashMap mateQueue = new HashMap();
        ArrayList<ArrayList<Interval>> levels = new ArrayList<ArrayList<Interval>>();
        levels.add(new ArrayList());
        ArrayList<DrawStore> savedDraws = new ArrayList<DrawStore>();
        for (int i = 0; i < this.data.size(); ++i) {
            BAMIntervalRecord bamRecord = (BAMIntervalRecord)this.data.get(i);
            Interval interval = bamRecord.getInterval();
            SAMRecord samRecord = bamRecord.getSAMRecord();
            SAMReadUtils.PairedSequencingProtocol prot = (SAMReadUtils.PairedSequencingProtocol)((Object)this.instructions.get((Object)DrawingInstruction.PAIRED_PROTOCOL));
            SAMReadUtils.PairMappingType type = SAMReadUtils.getPairType(samRecord, prot);
            int arcLength = Math.abs(samRecord.getInferredInsertSize());
            if (samRecord.getReadUnmappedFlag() || !samRecord.getReadPairedFlag() || samRecord.getMateUnmappedFlag() || type == null || arcLength == 0) {
                this.recordToShapeMap.put(bamRecord, null);
                continue;
            }
            if (samRecord.getMateAlignmentStart() > range.getTo()) {
                int level = this.computePiledIntervalLevel(levels, Interval.valueOf(interval.getStart(), effectiveEnd));
                savedDraws.add(new DrawStore(bamRecord, level, Interval.valueOf(effectiveEnd + 1, Integer.MAX_VALUE), null));
                continue;
            }
            BAMIntervalRecord mate = this.popMate((ArrayList)mateQueue.get(samRecord.getMateAlignmentStart()), samRecord);
            if (mate != null) {
                int level = this.computePiledIntervalLevel(levels, Interval.valueOf(Math.min(interval.getStart(), mate.getInterval().getStart()), Math.max(interval.getEnd(), mate.getInterval().getEnd())));
                savedDraws.add(new DrawStore(bamRecord, level, null, null));
                savedDraws.add(new DrawStore(mate, level, interval, bamRecord));
                continue;
            }
            if (mateQueue.get(interval.getStart()) == null) {
                mateQueue.put(interval.getStart(), new ArrayList());
            }
            ((ArrayList)mateQueue.get(interval.getStart())).add(bamRecord);
        }
        for (ArrayList list : mateQueue.values()) {
            for (BAMIntervalRecord bamRecord : list) {
                Interval interval = bamRecord.getInterval();
                int level = this.computePiledIntervalLevel(levels, Interval.valueOf(effectiveStart, interval.getEnd()));
                savedDraws.add(new DrawStore(bamRecord, level, Interval.valueOf(0, effectiveStart - 1), null));
            }
        }
        gp.setYRange(new Range(0, levels.size() + 2));
        if (gp.needsToResize()) {
            return;
        }
        for (DrawStore drawStore : savedDraws) {
            Shape readshape = this.renderRead(g2, gp, drawStore.intervalRecord, drawStore.level, range, gp.getUnitHeight());
            this.recordToShapeMap.put(drawStore.intervalRecord, readshape);
            if (drawStore.mateInterval == null) continue;
            this.connectPiledInterval(g2, gp, drawStore.intervalRecord.getInterval(), drawStore.mateInterval, drawStore.level, linecolor, drawStore.intervalRecord, drawStore.mateIntervalRecord);
        }
    }

    private BAMIntervalRecord popMate(ArrayList<BAMIntervalRecord> records, SAMRecord samRecord) {
        if (records == null) {
            return null;
        }
        for (int i = 0; i < records.size(); ++i) {
            SAMRecord samRecord2 = records.get(i).getSAMRecord();
            if (!MiscUtils.isMate(samRecord, samRecord2, false)) continue;
            BAMIntervalRecord intervalRecord = records.get(i);
            records.remove(i);
            return intervalRecord;
        }
        return null;
    }

    private void connectPiledInterval(Graphics2D g2, GraphPaneAdapter gp, Interval i1, Interval i2, int level, Color linecolor, IntervalRecord ir1, IntervalRecord ir2) {
        Interval mateInterval = this.computeMateInterval(i1, i2);
        Stroke currentStroke = g2.getStroke();
        BasicStroke drawingStroke = new BasicStroke(1.0f);
        double yPos = gp.transformYPos(0.0) - (double)(level + 1) * gp.getUnitHeight() + gp.getUnitHeight() / 2.0 - (double)gp.getOffset();
        Line2D.Double line = new Line2D.Double(gp.transformXPos(mateInterval.getStart()) + this.arrowWidth, yPos, gp.transformXPos(mateInterval.getEnd()) - this.arrowWidth, yPos);
        g2.setStroke(drawingStroke);
        g2.setColor(linecolor);
        g2.draw(line);
        g2.setStroke(currentStroke);
        Rectangle2D.Double bound = new Rectangle2D.Double(Math.min(gp.transformXPos(mateInterval.getStart()), gp.transformXPos(mateInterval.getEnd())), yPos - gp.getUnitHeight() / 2.0, Math.abs(gp.transformXPos(mateInterval.getEnd()) - gp.transformXPos(mateInterval.getStart())), gp.getUnitHeight());
        if (ir1 != null) {
            this.artifactMap.put(ir1, bound);
        }
        if (ir2 != null) {
            this.artifactMap.put(ir2, bound);
        }
    }

    private Interval computeMateInterval(Interval i1, Interval i2) {
        int end;
        int start;
        if (i1.getEnd() < i2.getEnd()) {
            start = i1.getEnd();
            end = i2.getStart();
        } else {
            start = i2.getEnd();
            end = i1.getStart();
        }
        return Interval.valueOf(start + 1, end);
    }

    private int computePiledIntervalLevel(ArrayList<ArrayList<Interval>> levels, Interval interval) {
        for (int i = 0; i < levels.size(); ++i) {
            ArrayList<Interval> level = levels.get(i);
            boolean conflict = false;
            for (Interval current : level) {
                if (!current.intersects(interval)) continue;
                conflict = true;
                break;
            }
            if (conflict) continue;
            level.add(interval);
            return i;
        }
        levels.add(new ArrayList());
        levels.get(levels.size() - 1).add(interval);
        return levels.size() - 1;
    }

    @Override
    public Dimension getLegendSize(DrawingMode mode) {
        switch (mode) {
            case STANDARD: 
            case SEQUENCE: {
                return new Dimension(168, 42);
            }
            case MISMATCH: 
            case STANDARD_PAIRED: {
                return new Dimension(168, 78);
            }
            case ARC_PAIRED: {
                return new Dimension(125, 96);
            }
            case SNP: {
                return new Dimension(168, 42);
            }
            case STRAND_SNP: {
                return new Dimension(180, 60);
            }
        }
        return null;
    }

    @Override
    public void drawLegend(Graphics2D g2, DrawingMode mode) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x = 6;
        int y = 17;
        switch (mode) {
            case STANDARD: {
                this.drawStrandLegends(g2, x, y);
                break;
            }
            case MISMATCH: 
            case STANDARD_PAIRED: {
                this.drawStrandLegends(g2, x, y);
                this.drawBaseLegendExtended(g2, x, y += 36, ColourKey.A, ColourKey.C, ColourKey.G, ColourKey.T, ColourKey.SKIPPED);
                break;
            }
            case SEQUENCE: {
                this.drawBaseLegendExtended(g2, x, y, ColourKey.A, ColourKey.C, ColourKey.G, ColourKey.T, ColourKey.SKIPPED);
                break;
            }
            case ARC_PAIRED: {
                this.drawSimpleLegend(g2, 30, 15, ColourKey.CONCORDANT_LENGTH, ColourKey.DISCORDANT_LENGTH, ColourKey.ONE_READ_INVERTED, ColourKey.EVERTED_PAIR, ColourKey.UNMAPPED_MATE);
                break;
            }
            case SNP: {
                this.drawBaseLegendExtended(g2, x, y, ColourKey.A, ColourKey.C, ColourKey.G, ColourKey.T);
                break;
            }
            case STRAND_SNP: {
                this.drawBaseLegendExtended(g2, x, y, ColourKey.A, ColourKey.C, ColourKey.G, ColourKey.T);
                this.drawBaseLegend(g2, x, y += 36, ColourKey.FORWARD_STRAND);
                this.drawBaseLegend(g2, x += 90, y, ColourKey.REVERSE_STRAND);
                break;
            }
        }
    }

    private void drawStrandLegends(Graphics2D g2, int x, int y) {
        ColourScheme cs = (ColourScheme)this.instructions.get((Object)DrawingInstruction.COLOUR_SCHEME);
        Shape pointyBar = this.getPointyBar(false, x, y - 12, 36.0, 12.0);
        g2.setColor(cs.getColor(ColourKey.FORWARD_STRAND));
        g2.fill(pointyBar);
        g2.setColor(cs.getColor(ColourKey.INTERVAL_LINE));
        g2.draw(pointyBar);
        pointyBar = this.getPointyBar(true, x, y - 12 + 18, 36.0, 12.0);
        g2.setColor(cs.getColor(ColourKey.REVERSE_STRAND));
        g2.fill(pointyBar);
        g2.setColor(cs.getColor(ColourKey.INTERVAL_LINE));
        g2.draw(pointyBar);
        g2.setColor(Color.BLACK);
        g2.setFont(LEGEND_FONT);
        g2.drawString(ColourKey.FORWARD_STRAND.getName(), x + 45, y);
        g2.drawString(ColourKey.REVERSE_STRAND.getName(), x + 45, y + 18);
    }

    private void drawBaseLegendExtended(Graphics2D g2, int x, int y, ColourKey ... keys) {
        this.drawBaseLegend(g2, x, y, keys);
        g2.setColor(Color.BLACK);
        g2.fillRect(x, (y += 18) - BAMTrackRenderer.SWATCH_SIZE.height + 2, BAMTrackRenderer.SWATCH_SIZE.width, BAMTrackRenderer.SWATCH_SIZE.height);
        g2.setColor(Color.BLACK);
        g2.drawString("Deletion", x + BAMTrackRenderer.SWATCH_SIZE.width + 3, y);
        Shape s = this.drawInsertion(g2, x += 66, y - BAMTrackRenderer.SWATCH_SIZE.height + 2, 12.0, BAMTrackRenderer.SWATCH_SIZE.height);
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke(0.25f));
        g2.draw(s);
        g2.drawString("Insertion", x + 12, y);
    }

    private class DrawStore {
        public BAMIntervalRecord intervalRecord;
        public int level;
        public Interval mateInterval;
        public IntervalRecord mateIntervalRecord;

        public DrawStore(BAMIntervalRecord intervalRecord, int level, Interval mateInterval, IntervalRecord mateIntervalRecord) {
            this.intervalRecord = intervalRecord;
            this.level = level;
            this.mateInterval = mateInterval;
            this.mateIntervalRecord = mateIntervalRecord;
        }
    }
}

