/*
 * Decompiled with CFR 0.152.
 */
package savant.view.tracks;

import java.io.IOException;
import java.util.List;
import savant.api.adapter.DataSourceAdapter;
import savant.api.adapter.RangeAdapter;
import savant.api.data.SequenceRecord;
import savant.api.util.Resolution;
import savant.exception.SavantTrackCreationCancelledException;
import savant.settings.ResolutionSettings;
import savant.util.AxisRange;
import savant.util.ColourKey;
import savant.util.ColourScheme;
import savant.util.DrawingInstruction;
import savant.util.Range;
import savant.view.tracks.SequenceTrackRenderer;
import savant.view.tracks.Track;

public class SequenceTrack
extends Track {
    public SequenceTrack(DataSourceAdapter dataTrack) throws SavantTrackCreationCancelledException {
        super(dataTrack, new SequenceTrackRenderer());
    }

    @Override
    public ColourScheme getDefaultColourScheme() {
        return new ColourScheme(ColourKey.A, ColourKey.C, ColourKey.G, ColourKey.T, ColourKey.N);
    }

    @Override
    public Resolution getResolution(RangeAdapter range) {
        return range.getLength() > ResolutionSettings.getSequenceLowToHighThreshold() ? Resolution.LOW : Resolution.HIGH;
    }

    @Override
    public void prepareForRendering(String ref, Range r) {
        Resolution res = this.getResolution(r);
        if (res == Resolution.HIGH) {
            this.renderer.addInstruction(DrawingInstruction.PROGRESS, "Loading sequence data...");
            this.requestData(ref, r);
        } else {
            this.renderer.addInstruction(DrawingInstruction.ERROR, ZOOM_MESSAGE);
            this.saveNullData(r);
        }
        this.renderer.addInstruction(DrawingInstruction.RESOLUTION, (Object)res);
        this.renderer.addInstruction(DrawingInstruction.AXIS_RANGE, new AxisRange(r, new Range(0, 1)));
        this.renderer.addInstruction(DrawingInstruction.REFERENCE_EXISTS, this.containsReference(ref));
        this.renderer.addInstruction(DrawingInstruction.SELECTION_ALLOWED, false);
        if (res == Resolution.HIGH) {
            this.renderer.addInstruction(DrawingInstruction.RANGE, r);
            this.renderer.addInstruction(DrawingInstruction.COLOUR_SCHEME, this.getColourScheme());
        }
    }

    public byte[] getSequence(String ref, RangeAdapter r) throws IOException, InterruptedException {
        List recs = this.getDataSource().getRecords(ref, r, Resolution.HIGH, null);
        if (recs != null && recs.size() > 0) {
            return ((SequenceRecord)recs.get(0)).getSequence();
        }
        return null;
    }
}

