/*
 * Decompiled with CFR 0.152.
 */
package savant.view.tracks;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.adapter.GraphPaneAdapter;
import savant.api.data.Record;
import savant.api.event.DataRetrievalEvent;
import savant.api.util.Listener;
import savant.api.util.Resolution;
import savant.controller.LocationController;
import savant.exception.RenderingException;
import savant.selection.SelectionController;
import savant.util.ColourKey;
import savant.util.ColourScheme;
import savant.util.DrawingInstruction;
import savant.util.DrawingMode;
import savant.util.MiscUtils;

public abstract class TrackRenderer
implements Listener<DataRetrievalEvent> {
    private static final Log LOG = LogFactory.getLog(TrackRenderer.class);
    private static final int MIN_TRANSPARENCY = 20;
    private static final int MAX_TRANSPARENCY = 255;
    protected static final Font LEGEND_FONT = new Font("Sans-Serif", 0, 10);
    protected static final Stroke ONE_STROKE = new BasicStroke(1.0f);
    protected static final Stroke TWO_STROKE = new BasicStroke(2.0f);
    protected static final Dimension SWATCH_SIZE = new Dimension(6, 13);
    protected static final int LEGEND_LINE_HEIGHT = 18;
    protected List<Record> data;
    protected final EnumMap<DrawingInstruction, Object> instructions = new EnumMap(DrawingInstruction.class);
    protected String trackName;
    protected Map<Record, Shape> recordToShapeMap = new HashMap<Record, Shape>();
    protected Map<Record, Shape> artifactMap = new HashMap<Record, Shape>();

    protected TrackRenderer() {
    }

    public void setTrackName(String name) {
        this.trackName = name;
    }

    @Override
    public void handleEvent(DataRetrievalEvent evt) {
        switch (evt.getType()) {
            case STARTED: {
                this.data = null;
                break;
            }
            case COMPLETED: {
                LOG.debug((Object)"TrackRenderer received dataRetrievalCompleted, removing PROGRESS.");
                this.instructions.remove((Object)DrawingInstruction.PROGRESS);
                this.data = evt.getData();
                break;
            }
            case FAILED: {
                this.instructions.remove((Object)DrawingInstruction.PROGRESS);
                this.instructions.put(DrawingInstruction.ERROR, (Object)new RenderingException(MiscUtils.getMessage(evt.getError()), 3));
            }
        }
    }

    public boolean isWaitingForData() {
        return this.data == null && this.instructions.containsKey((Object)DrawingInstruction.PROGRESS);
    }

    public void addInstruction(DrawingInstruction key, Object value) {
        if (key == DrawingInstruction.AXIS_RANGE) {
            // empty if block
        }
        this.instructions.put(key, value);
    }

    public Object getInstruction(DrawingInstruction key) {
        return this.instructions.get((Object)key);
    }

    public void clearInstructions() {
        this.instructions.clear();
    }

    public abstract void render(Graphics2D var1, GraphPaneAdapter var2) throws RenderingException;

    protected void renderPreCheck() throws RenderingException {
        this.recordToShapeMap.clear();
        this.artifactMap.clear();
        Boolean refExists = (Boolean)this.instructions.get((Object)DrawingInstruction.REFERENCE_EXISTS);
        if (refExists == null || !refExists.booleanValue()) {
            throw new RenderingException("No data for " + LocationController.getInstance().getReferenceName(), 1);
        }
        RenderingException error = (RenderingException)this.instructions.get((Object)DrawingInstruction.ERROR);
        if (error != null) {
            throw error;
        }
        if (this.data == null || this.data.isEmpty()) {
            throw new RenderingException("No data in range", 1);
        }
    }

    public boolean selectionAllowed(boolean checkRes) {
        Object instr_res;
        Object instr_select = this.instructions.get((Object)DrawingInstruction.SELECTION_ALLOWED);
        if (instr_select == null || instr_select.equals(false)) {
            return false;
        }
        return !checkRes || (instr_res = this.instructions.get((Object)DrawingInstruction.RESOLUTION)) != null && instr_res.equals((Object)Resolution.HIGH);
    }

    public boolean hasMappedValues() {
        return !this.recordToShapeMap.isEmpty();
    }

    public Map<Record, Shape> searchPoint(Point p) {
        if (!this.hasMappedValues() || this.data == null) {
            return null;
        }
        DrawingMode mode = (DrawingMode)((Object)this.instructions.get((Object)DrawingInstruction.MODE));
        HashMap<Record, Shape> map = new HashMap<Record, Shape>();
        boolean allowFuzzySNPs = true;
        Rectangle2D.Double testIntersection = new Rectangle2D.Double(p.x - 3, p.y - 3, 7.0, 7.0);
        for (Record rec : this.recordToShapeMap.keySet()) {
            Shape artifact;
            Shape s = this.recordToShapeMap.get(rec);
            if (s != null) {
                boolean hit = false;
                hit = mode == DrawingMode.ARC || mode == DrawingMode.ARC_PAIRED ? s.intersects(testIntersection) && (!s.contains(p.x - 3, p.y - 3) || !s.contains(p.x + 3, p.y - 3)) : s.contains(p);
                if (mode == DrawingMode.SNP || mode == DrawingMode.STRAND_SNP || mode == DrawingMode.MATRIX) {
                    if (hit) {
                        if (allowFuzzySNPs) {
                            map.clear();
                            allowFuzzySNPs = false;
                        }
                    } else if (allowFuzzySNPs) {
                        hit = s.intersects(testIntersection);
                    }
                }
                if (hit) {
                    map.put(rec, s);
                    continue;
                }
            } else {
                LOG.info((Object)("Why is shape null for " + rec));
            }
            if ((artifact = this.artifactMap.get(rec)) == null || !artifact.contains(p.x, p.y)) continue;
            map.put(rec, s);
        }
        return map.isEmpty() ? null : map;
    }

    public boolean rectangleSelect(Rectangle2D rect) {
        if (!this.selectionAllowed(false) || !this.hasMappedValues()) {
            return false;
        }
        boolean repaint = false;
        ArrayList<Record> toAdd = new ArrayList<Record>();
        for (Record o : this.recordToShapeMap.keySet()) {
            Shape s = this.recordToShapeMap.get(o);
            if (s == null || !s.intersects(rect)) continue;
            toAdd.add(o);
            repaint = true;
        }
        if (repaint) {
            SelectionController.getInstance().addMultipleSelections(this.trackName, toAdd);
        }
        return repaint;
    }

    public void addToSelected(Record rec) {
        if (this.selectionAllowed(false)) {
            SelectionController.getInstance().toggleSelection(this.trackName, rec);
        }
    }

    public void forceAddToSelected(Record i) {
        SelectionController.getInstance().addSelection(this.trackName, i);
    }

    public List<Shape> getCurrentSelectedShapes(GraphPaneAdapter gp) {
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        List<Record> currentSelected = SelectionController.getInstance().getSelectedFromList(this.trackName, LocationController.getInstance().getRange(), this.data);
        for (int i = 0; i < currentSelected.size(); ++i) {
            Shape s = this.recordToShapeMap.get(currentSelected.get(i));
            if (s == null) continue;
            shapes.add(s);
        }
        return shapes;
    }

    public static int getConstrainedAlpha(int alpha) {
        return alpha < 20 ? 20 : (alpha > 255 ? 255 : alpha);
    }

    public void toggleGroup(ArrayList<Record> recs) {
        if (this.selectionAllowed(false)) {
            SelectionController.getInstance().toggleGroup(this.trackName, recs);
        }
    }

    public void drawFeatureLabel(Graphics2D g2, String geneName, double startXPos, double y) {
        FontMetrics fm = g2.getFontMetrics();
        double stringstartx = startXPos - (double)fm.stringWidth(geneName) - 5.0;
        if (stringstartx <= 0.0) {
            Rectangle2D r = fm.getStringBounds(geneName, g2);
            int b = 2;
            Color textColor = g2.getColor();
            g2.setColor(new Color(255, 255, 255, 200));
            g2.fill(new RoundRectangle2D.Double(3.0, y - (double)(fm.getHeight() - fm.getDescent()) - (double)b, r.getWidth() + (double)(2 * b), r.getHeight() + (double)(2 * b), 8.0, 8.0));
            g2.setColor(textColor);
            g2.drawString(geneName, 5.0f, (float)y);
        } else {
            g2.drawString(geneName, (float)stringstartx, (float)y);
        }
    }

    public Shape drawInsertion(Graphics2D g2, double x, double y, double unitWidth, double unitHeight) {
        ColourScheme cs = (ColourScheme)this.instructions.get((Object)DrawingInstruction.COLOUR_SCHEME);
        g2.setColor(cs.getColor(ColourKey.INSERTED_BASE));
        double w = unitWidth * 0.5;
        Path2D.Double rhombus = new Path2D.Double();
        rhombus.moveTo(x, y);
        rhombus.lineTo(x + w, y + unitHeight * 0.5);
        rhombus.lineTo(x, y + unitHeight);
        rhombus.lineTo(x - w, y + unitHeight * 0.5);
        rhombus.closePath();
        g2.fill(rhombus);
        return rhombus;
    }

    public Dimension getLegendSize(DrawingMode mode) {
        return null;
    }

    public void drawLegend(Graphics2D g2, DrawingMode mode) {
    }

    protected void drawSimpleLegend(Graphics2D g2, int x, int y, ColourKey ... keys) {
        ColourScheme cs = (ColourScheme)this.instructions.get((Object)DrawingInstruction.COLOUR_SCHEME);
        g2.setFont(LEGEND_FONT);
        for (ColourKey k : keys) {
            String legendString = k.getName();
            g2.setColor(cs.getColor(k));
            g2.setStroke(TWO_STROKE);
            Rectangle2D stringRect = LEGEND_FONT.getStringBounds(legendString, g2.getFontRenderContext());
            g2.drawLine(x - 25, y - (int)stringRect.getHeight() / 2, x - 5, y - (int)stringRect.getHeight() / 2);
            g2.setColor(cs.getColor(ColourKey.INTERVAL_LINE));
            g2.setStroke(ONE_STROKE);
            g2.drawString(legendString, x, y);
            y += 18;
        }
    }

    protected void drawBaseLegend(Graphics2D g2, int x, int y, ColourKey ... keys) {
        ColourScheme cs = (ColourScheme)this.instructions.get((Object)DrawingInstruction.COLOUR_SCHEME);
        g2.setFont(LEGEND_FONT);
        for (ColourKey k : keys) {
            g2.setColor(cs.getColor(k));
            g2.fillRect(x, y - TrackRenderer.SWATCH_SIZE.height + 2, TrackRenderer.SWATCH_SIZE.width, TrackRenderer.SWATCH_SIZE.height);
            g2.setColor(Color.BLACK);
            g2.drawString(k.getName(), x + TrackRenderer.SWATCH_SIZE.width + 3, y);
            x += 27;
        }
    }
}

