/*
 * Decompiled with CFR 0.152.
 */
package savant.view.variation.swing;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.data.Record;
import savant.api.data.VariantRecord;
import savant.controller.LocationController;
import savant.settings.BrowserSettings;
import savant.settings.ColourSettings;
import savant.util.ColourAccumulator;
import savant.util.ColourKey;
import savant.util.ColourScheme;
import savant.util.Range;
import savant.view.tracks.VariantTrackRenderer;
import savant.view.variation.ParticipantRecord;
import savant.view.variation.VariationController;
import savant.view.variation.swing.VariantPopper;
import savant.view.variation.swing.VariationPlot;

public class VariantMap
extends VariationPlot {
    private static final Log LOG = LogFactory.getLog(VariantMap.class);

    VariantMap(VariationController vc) {
        super(vc);
        this.setFont(BrowserSettings.getTrackFont());
        VariantPopper popper = new VariantPopper(this);
        this.addMouseListener(popper);
        this.addMouseMotionListener(popper);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int h = this.getHeight();
        int w = this.getWidth();
        GradientPaint gp0 = new GradientPaint(0.0f, 0.0f, ColourSettings.getColor(ColourKey.GRAPH_PANE_BACKGROUND_TOP), 0.0f, h, ColourSettings.getColor(ColourKey.GRAPH_PANE_BACKGROUND_BOTTOM));
        g2.setPaint(gp0);
        g2.fillRect(0, 0, w, h);
        List<VariantRecord> data = this.controller.getData();
        if (data != null && !data.isEmpty()) {
            double boxTop = Double.NaN;
            double boxBottom = Double.NaN;
            Range browseRange = LocationController.getInstance().getRange();
            int participantCount = this.controller.getParticipantCount();
            this.unitHeight = (double)h / (double)data.size();
            this.unitWidth = (double)w / (double)participantCount;
            boolean gappable = this.unitHeight > 18.0;
            ColourScheme cs = new ColourScheme(ColourKey.A, ColourKey.C, ColourKey.G, ColourKey.T, ColourKey.INSERTED_BASE, ColourKey.DELETED_BASE, ColourKey.N);
            ColourAccumulator accumulator = new ColourAccumulator(cs);
            double y = 0.0;
            double topGap = 0.0;
            for (int i = 0; i < data.size(); ++i) {
                VariantRecord nextRec;
                VariantRecord varRec = data.get(i);
                double bottomGap = 0.0;
                if (gappable && i + 1 < data.size() && (nextRec = data.get(i + 1)).getPosition() - varRec.getPosition() > 1) {
                    bottomGap = 4.5;
                }
                if (Double.isNaN(boxTop) && browseRange.getFrom() <= varRec.getPosition() && browseRange.getTo() >= varRec.getPosition()) {
                    boxTop = y + topGap;
                    boxBottom = boxTop + this.unitHeight;
                } else if (varRec.getPosition() <= browseRange.getTo()) {
                    boxBottom = y + this.unitHeight - bottomGap;
                }
                double x = 0.0;
                for (int j = 0; j < participantCount; ++j) {
                    VariantTrackRenderer.accumulateZygoteShapes(varRec.getVariantsForParticipant(j), accumulator, new Rectangle2D.Double(x, y + topGap, this.unitWidth, this.unitHeight - topGap - bottomGap));
                    x += this.unitWidth;
                }
                topGap = bottomGap;
                y += this.unitHeight;
            }
            accumulator.fill(g2);
            if (gappable) {
                this.drawGapSizes(g2);
            } else {
                this.labelVerticalAxis(g2);
            }
            g2.setClip(null);
            g2.setColor(Color.BLUE);
            g2.draw(new Rectangle2D.Double(0.0, boxTop, (double)w - 1.0, boxBottom - boxTop - 1.0));
        }
    }

    @Override
    public Record pointToRecord(Point pt) {
        VariantRecord varRec = this.pointToVariantRecord(pt);
        if (varRec != null) {
            int logicalX = (int)((double)pt.x / this.unitWidth);
            return new ParticipantRecord(varRec, logicalX, this.controller.getParticipants()[logicalX]);
        }
        return null;
    }
}

