/*
 * Decompiled with CFR 0.152.
 */
package savant.view.variation.swing;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.data.VariantRecord;
import savant.api.event.LocationChangedEvent;
import savant.api.util.DialogUtils;
import savant.api.util.Listener;
import savant.controller.LocationController;
import savant.settings.ResolutionSettings;
import savant.util.Bookmark;
import savant.util.MiscUtils;
import savant.util.Range;
import savant.util.swing.ProgressPanel;
import savant.util.swing.RecordTable;
import savant.view.icon.SavantIconFactory;
import savant.view.variation.VariationController;
import savant.view.variation.swing.AlleleFrequencyPlot;
import savant.view.variation.swing.CaseControlDialog;
import savant.view.variation.swing.LDPlot;
import savant.view.variation.swing.VariantMap;
import savant.view.variation.swing.VariantTableModel;

public class VariationModule
extends JPanel {
    static final Log LOG = LogFactory.getLog(VariationModule.class);
    private static final String ZOOM_MESSAGE = MiscUtils.MAC ? "<html><center>Zoom in to see data<br><small>To view data at this range, change Preferences > Track Resolutions</small></center></html>" : "<html><center>Zoom in to see data<br><small>To view data at this range, change Edit > Preferences > Track Resolutions</small></center></html>";
    static final Font MESSAGE_FONT = new Font("Sans-Serif", 0, 24);
    private static final Insets MESSAGE_INSETS = new Insets(20, 20, 20, 20);
    private VariationController controller;
    private JTabbedPane tabs;
    private JPanel messagePanel;
    private ProgressPanel progressPanel;
    private JComponent currentCard;
    private JTable table;
    private VariantMap map;
    private AlleleFrequencyPlot frequencyPlot;
    private LDPlot ldPlot;
    private JTextField rangeField;
    private List<JScrollBar> scrollers = new ArrayList<JScrollBar>();
    private ButtonGroup methodGroup;
    private JLabel messageLabel;
    private AdjustmentListener scrollerListener = new AdjustmentListener(){

        @Override
        public void adjustmentValueChanged(AdjustmentEvent ae) {
            if (!ae.getValueIsAdjusting()) {
                VariationModule.this.controller.setVisibleRange(ae.getValue());
            }
        }
    };
    private MouseWheelListener wheelListener = new MouseWheelListener(){

        @Override
        public void mouseWheelMoved(MouseWheelEvent mwe) {
            int notches = mwe.getWheelRotation();
            Range visRange = VariationModule.this.controller.getVisibleRange();
            VariationModule.this.controller.setVisibleRange(visRange.getFrom() + visRange.getLength() * notches / 10);
        }
    };

    public VariationModule(VariationController vc) {
        super(new GridBagLayout());
        this.controller = vc;
        JToolBar tools = new JToolBar();
        tools.setFloatable(false);
        this.rangeField = new JTextField();
        this.rangeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String text = VariationModule.this.rangeField.getText();
                try {
                    Bookmark bm = new Bookmark(text, VariationModule.this.controller.getReference(), VariationModule.this.controller.getVisibleRange());
                    VariationModule.this.controller.setLocation(bm.getReference(), (Range)bm.getRange());
                }
                catch (ParseException x) {
                    DialogUtils.displayMessage(String.format("Unable to parse \"%s\" as a location.", text));
                }
            }
        });
        tools.add(this.rangeField);
        tools.addSeparator();
        JButton zoomInButton = new JButton();
        zoomInButton.setIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.ZOOMIN));
        zoomInButton.setBorderPainted(false);
        zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariationModule.this.controller.zoomIn();
            }
        });
        tools.add(zoomInButton);
        JButton zoomOutButton = new JButton();
        zoomOutButton.setIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.ZOOMOUT));
        zoomOutButton.setBorderPainted(false);
        zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariationModule.this.controller.zoomOut();
            }
        });
        tools.add(zoomOutButton);
        tools.addSeparator();
        JButton controlsButton = new JButton("Controls");
        controlsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VariationModule.this.controller.getTracks().length > 0) {
                    new CaseControlDialog(VariationModule.this.controller).setVisible(true);
                    VariationModule.this.frequencyPlot.repaint();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        });
        tools.add(controlsButton);
        this.tabs = new JTabbedPane();
        this.table = new RecordTable(new VariantTableModel(null));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    VariationModule.this.controller.navigateToRecord(VariationModule.this.controller.getData().get(VariationModule.this.table.getSelectedRow()));
                }
            }
        });
        this.tabs.addTab("Table", new JScrollPane(this.table));
        this.map = new VariantMap(this.controller);
        this.map.addMouseWheelListener(this.wheelListener);
        LocationController.getInstance().addListener(new Listener<LocationChangedEvent>(){

            @Override
            public void handleEvent(LocationChangedEvent event) {
                VariationModule.this.map.repaint();
            }
        });
        JPanel mapPanel = this.populatePanel(this.map);
        this.tabs.addTab("Map", mapPanel);
        this.frequencyPlot = new AlleleFrequencyPlot(this.controller);
        this.frequencyPlot.addMouseWheelListener(this.wheelListener);
        JPanel frequencyPanel = this.populatePanel(this.frequencyPlot);
        this.tabs.addTab("Allele Frequency", frequencyPanel);
        JPanel ldPanel = new JPanel();
        ldPanel.setLayout(new GridBagLayout());
        ActionListener redrawForcer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VariationModule.this.ldPlot.repaint();
            }
        };
        JRadioButton dPrimeButton = new JRadioButton("D\u2032", true);
        dPrimeButton.setActionCommand("true");
        dPrimeButton.addActionListener(redrawForcer);
        JRadioButton rSquaredButton = new JRadioButton("r\u00b2", false);
        rSquaredButton.setActionCommand("false");
        rSquaredButton.addActionListener(redrawForcer);
        this.methodGroup = new ButtonGroup();
        JPanel methodPanel = new JPanel();
        methodPanel.setBorder(BorderFactory.createTitledBorder("Calculation Method"));
        methodPanel.add(dPrimeButton);
        this.methodGroup.add(dPrimeButton);
        methodPanel.add(rSquaredButton);
        this.methodGroup.add(rSquaredButton);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        ldPanel.add((Component)methodPanel, gbc);
        this.ldPlot = new LDPlot(this.controller);
        JPanel lowerLDPanel = this.populatePanel(this.ldPlot);
        gbc.weighty = 1.0;
        ldPanel.add((Component)lowerLDPanel, gbc);
        this.tabs.addTab("LD Plot", ldPanel);
        gbc.weighty = 0.0;
        this.add((Component)tools, gbc);
        this.messageLabel = new JLabel();
        this.messageLabel.setFont(MESSAGE_FONT);
        this.messagePanel = this.populatePanel(this.messageLabel);
        this.progressPanel = new ProgressPanel(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VariationModule.this.controller.cancelDataRequests();
            }
        });
        this.showCard(this.tabs, null);
    }

    private JPanel populatePanel(JComponent content) {
        JScrollBar scroller = new JScrollBar();
        scroller.setMinimum(1);
        scroller.addAdjustmentListener(this.scrollerListener);
        this.scrollers.add(scroller);
        JPanel container = new JPanel();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        if (content instanceof JLabel) {
            gbc.anchor = 11;
            gbc.insets = MESSAGE_INSETS;
            gbc.fill = 2;
        } else {
            gbc.weighty = 1.0;
            gbc.fill = 1;
        }
        container.add((Component)content, gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 0, 0, 0);
        container.add((Component)scroller, gbc);
        return container;
    }

    public boolean isDPrimeSelected() {
        return Boolean.parseBoolean(this.methodGroup.getSelection().getActionCommand());
    }

    private void showCard(JComponent card, String message) {
        if (this.currentCard != card) {
            if (this.currentCard != null) {
                this.remove(this.currentCard);
            }
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.anchor = 11;
            if (message != null) {
                if (card == this.messagePanel) {
                    this.messageLabel.setText(message);
                } else {
                    gbc.insets = new Insets(20, 20, 20, 20);
                    gbc.fill = 2;
                    this.progressPanel.setMessage(message);
                }
            }
            this.add((Component)card, gbc);
            this.currentCard = card;
            this.repaint();
            this.validate();
        }
    }

    public void showTabs() {
        this.showCard(this.tabs, null);
    }

    public void showMessage(String message) {
        this.showCard(this.messagePanel, message);
    }

    public void showProgress(String message, double fract) {
        this.showCard(this.progressPanel, message);
        this.progressPanel.setFraction(fract);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visibleRangeChanged(String ref, Range r) {
        if (r.getLength() > ResolutionSettings.getVariantLowToHighThreshold()) {
            this.showMessage(ZOOM_MESSAGE);
        } else {
            try {
                for (JScrollBar sb : this.scrollers) {
                    sb.removeAdjustmentListener(this.scrollerListener);
                }
                for (JScrollBar sb : this.scrollers) {
                    sb.setMaximum(LocationController.getInstance().getMaxRangeEnd());
                    sb.setValue(r.getFrom());
                    sb.setVisibleAmount(r.getLength());
                    sb.setBlockIncrement(r.getLength());
                    sb.repaint();
                }
            }
            finally {
                for (JScrollBar sb : this.scrollers) {
                    sb.addAdjustmentListener(this.scrollerListener);
                }
            }
        }
        this.rangeField.setText(String.format("%s:%d-%d", ref, r.getFrom(), r.getTo()));
    }

    public void recalculated(List<VariantRecord> data) {
        this.table.setModel(new VariantTableModel(data));
        if (data != null && data.size() > 0) {
            this.showCard(this.tabs, null);
            this.map.repaint();
            this.ldPlot.recalculate();
        } else {
            this.showMessage("No data in range");
        }
    }
}

