/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.genemania.dto.AddAttributeGroupEngineRequestDto;
import org.genemania.dto.AddAttributeGroupEngineResponseDto;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.config.Config;
import org.genemania.engine.core.data.AttributeData;
import org.genemania.engine.core.data.AttributeGroups;
import org.genemania.engine.core.data.NodeIds;
import org.genemania.engine.core.utils.Logging;
import org.genemania.engine.exception.CancellationException;
import org.genemania.engine.matricks.Matrix;
import org.genemania.exception.ApplicationException;

public class AddAttributeGroup {
    private static Logger logger = Logger.getLogger(AddAttributeGroup.class);
    private DataCache cache;
    private AddAttributeGroupEngineRequestDto request;
    AddAttributeGroupEngineResponseDto response = null;
    private long requestStartTimeMillis;
    private long requestEndTimeMillis;

    public AddAttributeGroup(DataCache cache, AddAttributeGroupEngineRequestDto request) {
        this.cache = cache;
        this.request = request;
    }

    public AddAttributeGroupEngineResponseDto process() throws ApplicationException {
        try {
            this.requestStartTimeMillis = System.currentTimeMillis();
            this.logStart();
            this.checkQuery();
            this.logQuery();
            this.response = new AddAttributeGroupEngineResponseDto();
            this.addAttributeGroup();
            this.addAttributes();
            this.addAttributeData();
            this.requestEndTimeMillis = System.currentTimeMillis();
            this.logEnd();
            return this.response;
        }
        catch (CancellationException e) {
            logger.info((Object)"request was cancelled");
            return null;
        }
    }

    AddAttributeGroupEngineResponseDto addAttributeGroup() throws ApplicationException {
        AttributeGroups attributeGroups = this.loadCreateGroups();
        HashMap<Long, ArrayList<Long>> groupIds = attributeGroups.getAttributeGroups();
        groupIds.put(this.request.getAttributeGroupId(), new ArrayList());
        this.cache.putAttributeGroups(attributeGroups);
        AttributeData attributeData = new AttributeData(this.request.getNamespace(), this.request.getOrganismId(), this.request.getAttributeGroupId());
        this.cache.putAttributeData(attributeData);
        return new AddAttributeGroupEngineResponseDto();
    }

    AttributeGroups loadCreateGroups() throws ApplicationException {
        this.cache.initNamespace(this.request.getNamespace(), this.request.getOrganismId());
        AttributeGroups attributeGroups = null;
        try {
            attributeGroups = this.cache.getAttributeGroups(this.request.getNamespace(), this.request.getOrganismId());
        }
        catch (ApplicationException e) {
            if ("CORE".equals(this.request.getNamespace())) {
                attributeGroups = new AttributeGroups(this.request.getNamespace(), this.request.getOrganismId());
                HashMap<Long, ArrayList<Long>> groupIds = new HashMap<Long, ArrayList<Long>>();
                attributeGroups.setAttributeGroups(groupIds);
            }
            throw e;
        }
        return attributeGroups;
    }

    void addAttributes() throws ApplicationException {
        AttributeGroups attributeGroups = this.cache.getAttributeGroups(this.request.getNamespace(), this.request.getOrganismId());
        attributeGroups.getAttributeGroups().get(this.request.getAttributeGroupId()).addAll(this.request.getAttributeIds());
        this.cache.putAttributeGroups(attributeGroups);
        AttributeData attributeData = this.cache.getAttributeData(this.request.getNamespace(), this.request.getOrganismId(), this.request.getAttributeGroupId());
        if (attributeData.getData() != null) {
            throw new ApplicationException("consistency error");
        }
        NodeIds nodeIds = this.cache.getNodeIds(this.request.getOrganismId());
        int numNodes = nodeIds.getNodeIds().length;
        int numAttributes = attributeGroups.getAttributeGroups().get(this.request.getAttributeGroupId()).size();
        Matrix data = Config.instance().getMatrixFactory().sparseColMatrix(numNodes, numAttributes);
        attributeData.setData(data);
        this.cache.putAttributeData(attributeData);
    }

    void addAttributeData() throws ApplicationException {
        AttributeData attributeData = this.cache.getAttributeData(this.request.getNamespace(), this.request.getOrganismId(), this.request.getAttributeGroupId());
        NodeIds nodeIds = this.cache.getNodeIds(this.request.getOrganismId());
        AttributeGroups attributeGroups = this.cache.getAttributeGroups(this.request.getNamespace(), this.request.getOrganismId());
        Matrix data = attributeData.getData();
        for (List assocs : this.request.getNodeAttributeAssociations()) {
            if (assocs == null || assocs.size() <= 1) continue;
            long nodeId = (Long)assocs.get(0);
            for (int k = 1; k < assocs.size(); ++k) {
                long attributeId = (Long)assocs.get(k);
                int i = nodeIds.getIndexForId(nodeId);
                int j = attributeGroups.getIndexForAttributeId(this.request.getAttributeGroupId(), attributeId);
                data.set(i, j, 1.0);
            }
        }
        this.cache.putAttributeData(attributeData);
    }

    void logStart() {
    }

    void logEnd() {
        logger.info((Object)("completed processing request, duration = " + Logging.duration(this.requestStartTimeMillis, this.requestEndTimeMillis)));
    }

    void logQuery() {
        logger.info((Object)String.format("request for new attribute group for organism %s in namespace %s with id %d", this.request.getOrganismId(), this.request.getNamespace(), this.request.getAttributeGroupId()));
    }

    void checkQuery() throws ApplicationException {
        if (this.request == null) {
            throw new ApplicationException("request object was null");
        }
        if (this.request.getProgressReporter() == null) {
            throw new ApplicationException("ProgressReporter was null");
        }
        if (this.request.getNamespace().equals("CORE")) {
            if (this.request.getAttributeGroupId() < 0L) {
                throw new ApplicationException("CORE attribute groups must have id >= 0");
            }
        } else if (this.request.getAttributeGroupId() >= 0L) {
            throw new ApplicationException("user attribute groups must have id < 0");
        }
    }
}

