/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.actions;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.genemania.dto.AddEnrichmentAttributesEngineRequestDto;
import org.genemania.dto.AddEnrichmentAttributesEngineResponseDto;
import org.genemania.engine.actions.AddOrganism;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.config.Config;
import org.genemania.engine.core.data.CategoryIds;
import org.genemania.engine.core.data.GoAnnotations;
import org.genemania.engine.core.data.GoIds;
import org.genemania.engine.core.data.NodeIds;
import org.genemania.engine.matricks.Matrix;
import org.genemania.exception.ApplicationException;

public class AddEnrichmentAttributes {
    private static Logger logger = Logger.getLogger(AddOrganism.class);
    DataCache cache;
    AddEnrichmentAttributesEngineRequestDto request;
    GoAnnotations annos;
    GoIds goIds;
    CategoryIds catIds;
    Set<Long> UniqueCategoryIds = new HashSet<Long>();

    public AddEnrichmentAttributes(DataCache cache, AddEnrichmentAttributesEngineRequestDto request) {
        this.cache = cache;
        this.request = request;
    }

    public AddEnrichmentAttributesEngineResponseDto process() throws ApplicationException {
        logger.info((Object)String.format("adding ontology %s for organism %s", this.request.getOntologyId(), this.request.getOrganismId()));
        this.check();
        this.load();
        this.write();
        AddEnrichmentAttributesEngineResponseDto response = new AddEnrichmentAttributesEngineResponseDto();
        return response;
    }

    protected void load() throws ApplicationException {
        this.annos = new GoAnnotations(this.request.getOrganismId(), "" + this.request.getOntologyId());
        int numCategories = this.UniqueCategoryIds.size();
        NodeIds nodeIds = this.cache.getNodeIds(this.request.getOrganismId());
        int numGenes = nodeIds.getNodeIds().length;
        Matrix data = Config.instance().getMatrixFactory().sparseMatrix(numGenes, numCategories);
        this.annos.setData(data);
        this.goIds = new GoIds(this.request.getOrganismId(), "" + this.request.getOntologyId());
        this.catIds = new CategoryIds(this.request.getOrganismId(), this.request.getOntologyId());
        String[] catNames = new String[numCategories];
        long[] catIdList = new long[numCategories];
        int ix = 0;
        for (long categoryId : this.UniqueCategoryIds) {
            catNames[ix] = "tmp" + categoryId;
            catIdList[ix] = categoryId;
            ++ix;
        }
        this.goIds.setGoIds(catNames);
        this.catIds.setCategoryIds(catIdList);
        int n = this.request.getCategoryIds().size();
        for (int i = 0; i < n; ++i) {
            int nodeIx = nodeIds.getIndexForId((Long)this.request.getNodeIds().get(i));
            int catIx = this.catIds.getIndexForId((Long)this.request.getCategoryIds().get(i));
            data.set(nodeIx, catIx, 1.0);
        }
    }

    protected void check() throws ApplicationException {
        int i;
        boolean ok = false;
        try {
            this.cache.getGoAnnotations(this.request.getOrganismId(), "" + this.request.getOntologyId());
        }
        catch (ApplicationException e) {
            ok = true;
        }
        if (!ok) {
            throw new ApplicationException(String.format("the ontology %s already exists", this.request.getOntologyId()));
        }
        ok = false;
        try {
            this.cache.getGoIds(this.request.getOrganismId(), "" + this.request.getOntologyId());
        }
        catch (ApplicationException e) {
            ok = true;
        }
        if (!ok) {
            throw new ApplicationException(String.format("the ontology %s already exists", this.request.getOntologyId()));
        }
        ok = false;
        try {
            this.cache.getCategoryIds(this.request.getOrganismId(), this.request.getOntologyId());
        }
        catch (ApplicationException e) {
            ok = true;
        }
        if (!ok) {
            throw new ApplicationException(String.format("the ontology %s already exists", this.request.getOntologyId()));
        }
        int n = this.request.getCategoryIds().size();
        if (this.request.getNodeIds().size() != n) {
            throw new ApplicationException("inconsistent length of annotation mappings");
        }
        if (this.hasNames() && this.request.getCategoryNames().size() != n) {
            throw new ApplicationException("inconsistent length of annotation mappings");
        }
        NodeIds nodeIds = this.cache.getNodeIds(this.request.getOrganismId());
        for (i = 0; i < n; ++i) {
            if (this.request.getNodeIds().get(i) == null) {
                throw new ApplicationException("null node id");
            }
            try {
                int ix = nodeIds.getIndexForId((Long)this.request.getNodeIds().get(i));
                continue;
            }
            catch (ApplicationException e) {
                throw new ApplicationException(String.format("The given node id %s does not belong to organism %s", this.request.getNodeIds().get(i), this.request.getOrganismId()));
            }
        }
        for (i = 0; i < n; ++i) {
            Long categoryId = (Long)this.request.getCategoryIds().get(i);
            if (categoryId == null) {
                throw new ApplicationException("null category id");
            }
            this.UniqueCategoryIds.add(categoryId);
        }
    }

    protected boolean hasNames() {
        return this.request.getCategoryNames() != null && this.request.getCategoryNames().size() != 0;
    }

    protected void write() throws ApplicationException {
        this.cache.putGoAnnotations(this.annos);
        this.cache.putGoIds(this.goIds);
        this.cache.putCategoryIds(this.catIds);
    }
}

