/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.genemania.dto.AddOrganismEngineRequestDto;
import org.genemania.dto.AddOrganismEngineResponseDto;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.core.data.AttributeGroups;
import org.genemania.engine.core.data.DatasetInfo;
import org.genemania.engine.core.data.NetworkIds;
import org.genemania.engine.core.data.NodeIds;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;

public class AddOrganism {
    private static Logger logger = Logger.getLogger(AddOrganism.class);
    DataCache cache;
    AddOrganismEngineRequestDto request;

    public AddOrganism(DataCache cache, AddOrganismEngineRequestDto request) {
        this.cache = cache;
        this.request = request;
    }

    public AddOrganismEngineResponseDto process() throws ApplicationException {
        this.checkId();
        try {
            this.cache.initNamespace("CORE", this.request.getOrganismId());
            this.buildNodeIds(this.request.getOrganismId(), this.request.getNodeIds());
            this.buildDatasetInfo(this.request.getOrganismId(), this.request.getNodeIds().size());
            this.buildEmptyNetworkIds(this.request.getOrganismId());
            this.buildEmptyAttributeGroupIds(this.request.getOrganismId());
        }
        catch (DataStoreException e) {
            throw new ApplicationException("failed to add organism", (Throwable)e);
        }
        AddOrganismEngineResponseDto response = new AddOrganismEngineResponseDto();
        return response;
    }

    public void checkId() throws ApplicationException {
    }

    public void buildDatasetInfo(long organismId, int numNodes) throws ApplicationException {
        DatasetInfo info = new DatasetInfo(organismId);
        info.setNumGenes(numNodes);
        this.cache.putDatasetInfo(info);
    }

    public void buildNodeIds(long organismId, Collection<Long> allNodeIds) throws ApplicationException, DataStoreException {
        logger.info((Object)("building node/index mapping for organism " + organismId));
        long[] table = AddOrganism.buildPrimitiveTable(allNodeIds);
        NodeIds nodeIds = new NodeIds(organismId);
        nodeIds.setNodeIds(table);
        this.cache.putNodeIds(nodeIds);
    }

    public void buildEmptyNetworkIds(long organimsId) throws ApplicationException, DataStoreException {
        logger.info((Object)("building empty network ids for organism " + organimsId));
        long[] table = new long[]{};
        NetworkIds networkIds = new NetworkIds("CORE", organimsId);
        networkIds.setNetworkIds(table);
        this.cache.putNetworkIds(networkIds);
    }

    public void buildEmptyAttributeGroupIds(long organismId) throws ApplicationException {
        AttributeGroups attributeGroups = new AttributeGroups("CORE", organismId);
        HashMap<Long, ArrayList<Long>> groupIds = new HashMap<Long, ArrayList<Long>>();
        attributeGroups.setAttributeGroups(groupIds);
        this.cache.putAttributeGroups(attributeGroups);
    }

    public static long[] buildPrimitiveTable(Collection<Long> list) {
        long[] table = new long[list.size()];
        int i = 0;
        Iterator<Long> i$ = list.iterator();
        while (i$.hasNext()) {
            long id;
            table[i] = id = i$.next().longValue();
            ++i;
        }
        return table;
    }
}

