/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.actions;

import org.genemania.dto.AttributeDto;
import org.genemania.dto.InteractionVisitor;
import org.genemania.dto.NetworkCombinationRequestDto;
import org.genemania.dto.NetworkCombinationResponseDto;
import org.genemania.dto.NetworkDto;
import org.genemania.engine.Constants;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.core.data.NodeIds;
import org.genemania.engine.core.integration.CombineNetworksOnly;
import org.genemania.engine.core.integration.CombinedKernelBuilder;
import org.genemania.engine.core.integration.Feature;
import org.genemania.engine.core.integration.FeatureWeightMap;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.engine.matricks.custom.MultiOPCSymMatrix;
import org.genemania.engine.matricks.custom.OuterProductComboSymMatrix;
import org.genemania.exception.ApplicationException;

public class CombineNetworks {
    DataCache cache;
    NetworkCombinationRequestDto request;

    public CombineNetworks(DataCache cache, NetworkCombinationRequestDto request) {
        this.cache = cache;
        this.request = request;
    }

    public NetworkCombinationResponseDto process() throws ApplicationException {
        SymMatrix combined = this.combine();
        this.visit(combined);
        return new NetworkCombinationResponseDto();
    }

    private SymMatrix combine() throws ApplicationException {
        FeatureWeightMap weights = this.buildWeightMap();
        SymMatrix combined = CombineNetworksOnly.combine(weights, this.request.getNamespace(), this.request.getOrganismId(), this.cache, this.request.getProgressReporter());
        CombinedKernelBuilder builder = new CombinedKernelBuilder(this.cache);
        combined = builder.build(this.request.getOrganismId(), this.request.getNamespace(), combined, weights);
        return combined;
    }

    private FeatureWeightMap buildWeightMap() {
        Feature feature;
        FeatureWeightMap weightMap = new FeatureWeightMap();
        for (NetworkDto network : this.request.getNetworks()) {
            if (network.getWeight() == 0.0) continue;
            feature = new Feature(Constants.NetworkType.SPARSE_MATRIX, 1L, network.getId());
            weightMap.put(feature, network.getWeight());
        }
        for (AttributeDto attribute : this.request.getAttributes()) {
            if (attribute.getWeight() == 0.0) continue;
            feature = new Feature(Constants.NetworkType.ATTRIBUTE_VECTOR, attribute.getGroupId(), attribute.getId());
            weightMap.put(feature, attribute.getWeight());
        }
        return weightMap;
    }

    private void visit(SymMatrix combined) throws ApplicationException {
        if (combined instanceof MultiOPCSymMatrix) {
            this.visitMultiOPCSymMatrix((MultiOPCSymMatrix)combined);
        } else {
            this.visitSymMatrix(combined);
        }
    }

    private void visitMultiOPCSymMatrix(MultiOPCSymMatrix combined) throws ApplicationException {
        OuterProductComboSymMatrix[] combos = combined.getCombos();
        SymMatrix matrix = combined.getMatrix();
        for (OuterProductComboSymMatrix combo : combos) {
            matrix.add(1.0, combo);
        }
        this.visitSymMatrix(matrix);
    }

    private void visitSymMatrix(SymMatrix combined) throws ApplicationException {
        InteractionVisitor visitor = this.request.getInteractionVistor();
        NodeIds nodeIds = this.cache.getNodeIds(this.request.getOrganismId());
        MatrixCursor cursor = combined.cursor();
        while (cursor.next()) {
            int col;
            int row = cursor.row();
            if (row <= (col = cursor.col())) continue;
            long node1 = nodeIds.getIdForIndex(row);
            long node2 = nodeIds.getIdForIndex(col);
            visitor.visit(node1, node2, cursor.val());
        }
    }
}

