/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Vector;
import org.apache.commons.math.special.Gamma;
import org.apache.log4j.Logger;
import org.genemania.dto.EnrichmentEngineRequestDto;
import org.genemania.dto.EnrichmentEngineResponseDto;
import org.genemania.dto.OntologyCategoryDto;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.core.MatrixUtils;
import org.genemania.engine.core.data.CategoryIds;
import org.genemania.engine.core.data.DatasetInfo;
import org.genemania.engine.core.data.GoAnnotations;
import org.genemania.engine.core.data.GoIds;
import org.genemania.engine.core.data.NodeDegrees;
import org.genemania.engine.core.data.NodeIds;
import org.genemania.engine.core.utils.Logging;
import org.genemania.engine.exception.CancellationException;
import org.genemania.engine.matricks.Matrix;
import org.genemania.exception.ApplicationException;

public class ComputeEnrichment {
    private static Logger logger = Logger.getLogger(ComputeEnrichment.class);
    private DataCache cache;
    private EnrichmentEngineRequestDto request;
    private long requestStartTimeMillis;
    private long requestEndTimeMillis;

    public ComputeEnrichment(DataCache cache, EnrichmentEngineRequestDto request) {
        this.cache = cache;
        this.request = request;
    }

    public EnrichmentEngineResponseDto process() throws ApplicationException {
        try {
            this.requestStartTimeMillis = System.currentTimeMillis();
            this.logStart();
            this.checkQuery();
            this.logQuery();
            EnrichmentEngineResponseDto response = this.computeEnrichment();
            this.requestEndTimeMillis = System.currentTimeMillis();
            this.logEnd();
            return response;
        }
        catch (CancellationException e) {
            logger.info((Object)"request was cancelled");
            return null;
        }
    }

    EnrichmentEngineResponseDto computeEnrichment() throws CancellationException, ApplicationException {
        GoAnnotations goAnnos = this.cache.getGoAnnotations(this.request.getOrganismId(), "" + this.request.getOntologyId());
        GoIds goIds = this.cache.getGoIds(this.request.getOrganismId(), "" + this.request.getOntologyId());
        CategoryIds catIds = this.cache.getCategoryIds(this.request.getOrganismId(), this.request.getOntologyId());
        DatasetInfo datasetInfo = this.cache.getDatasetInfo(this.request.getOrganismId());
        NodeDegrees nodeDegrees = this.cache.getNodeDegrees("CORE", this.request.getOrganismId());
        int numCategories = goAnnos.getData().numCols();
        int numGenes = goAnnos.getData().numRows();
        logger.debug((Object)String.format("num genes: %d, num categories: %d", numGenes, numCategories));
        DenseVector backgroundMask = this.makeGeneMaskVector(nodeDegrees.getDegrees().getData(), numGenes);
        DenseVector backgroundCounts = new DenseVector(numCategories);
        Matrix annoData = goAnnos.getData();
        annoData.transMult(backgroundMask.getData(), backgroundCounts.getData());
        NodeIds nodeIds = this.cache.getNodeIds(this.request.getOrganismId());
        DenseVector sampleMask = this.makeGeneMaskVector(nodeIds, numGenes);
        this.dotMult(sampleMask, backgroundMask);
        DenseVector sampleCounts = new DenseVector(numCategories);
        annoData.transMult(sampleMask.getData(), sampleCounts.getData());
        long n = Math.round(MatrixUtils.sum((Vector)sampleMask));
        int N = datasetInfo.getNumInteractingGenes();
        logger.debug((Object)String.format("enrichment sample size: %d, background size: %d", n, N));
        DenseVector pvals = new DenseVector(numCategories);
        for (int category = 0; category < numCategories; ++category) {
            if (this.request.getProgressReporter().isCanceled()) {
                throw new CancellationException();
            }
            long x = Math.round(sampleCounts.get(category));
            long k = Math.round(backgroundCounts.get(category));
            double pval = ComputeEnrichment.computeCumulHyperGeo(x, N, n, k);
            pvals.set(category, pval);
        }
        DenseVector qvals = ComputeEnrichment.computeFDRqval(N, pvals);
        boolean[] shouldReturn = ComputeEnrichment.selectCategoriesToReturn(qvals, this.request.getqValueThreshold(), this.request.getMinCategories());
        HashMap<String, OntologyCategoryDto> categoryIdToVO = new HashMap<String, OntologyCategoryDto>();
        ArrayList<OntologyCategoryDto> enrichedCategories = new ArrayList<OntologyCategoryDto>();
        for (int category = 0; category < numCategories; ++category) {
            if (!shouldReturn[category]) continue;
            String categoryName = goIds.getIdForIndex(category);
            long catId = catIds.getIdForIndex(category);
            OntologyCategoryDto categoryVO = new OntologyCategoryDto();
            categoryVO.setId(catId);
            categoryVO.setpValue(pvals.get(category));
            categoryVO.setqValue(qvals.get(category));
            categoryVO.setNumAnnotatedInSample((int)Math.round(sampleCounts.get(category)));
            categoryVO.setNumAnnotatedInTotal((int)Math.round(backgroundCounts.get(category)));
            enrichedCategories.add(categoryVO);
            categoryIdToVO.put(categoryName, categoryVO);
        }
        Map<Long, Collection<OntologyCategoryDto>> annotations = this.makeAnnotationsMap(goAnnos, goIds, nodeIds, categoryIdToVO);
        EnrichmentEngineResponseDto response = new EnrichmentEngineResponseDto();
        response.setEnrichedCategories(enrichedCategories);
        response.setAnnotations(annotations);
        logger.debug((Object)String.format("returning %d categories", enrichedCategories.size()));
        return response;
    }

    protected static boolean[] selectCategoriesToReturn(DenseVector qvals, double threshold, int minToReturn) {
        int i;
        boolean[] shouldReturn = new boolean[qvals.size()];
        DenseVector ranks = qvals.copy();
        MatrixUtils.rank((Vector)ranks);
        DenseVector ordered = new DenseVector(qvals.size());
        int[] unrank = new int[qvals.size()];
        int i2 = 0;
        while (i2 < ranks.size()) {
            int p = (int)Math.round(ranks.get(i2)) - 1;
            ordered.set(p, qvals.get(i2));
            unrank[p] = i2++;
        }
        int numSelected = 0;
        for (i = 0; i < ranks.size() && !(ordered.get(i) > threshold); ++i) {
            shouldReturn[unrank[i]] = true;
            ++numSelected;
        }
        while (numSelected < minToReturn && i < ranks.size() && !(ordered.get(i) > 1.0)) {
            shouldReturn[unrank[i]] = true;
            ++numSelected;
            ++i;
        }
        return shouldReturn;
    }

    private Map<Long, Collection<OntologyCategoryDto>> makeAnnotationsMap(GoAnnotations goAnnos, GoIds goIds, NodeIds nodeIds, Map<String, OntologyCategoryDto> categoryIdToVO) throws ApplicationException {
        HashMap<Long, Collection<OntologyCategoryDto>> annotations = new HashMap<Long, Collection<OntologyCategoryDto>>();
        int numCategories = goAnnos.getData().numCols();
        Matrix annoData = goAnnos.getData();
        for (Long nodeId : this.request.getNodes()) {
            ArrayList<OntologyCategoryDto> categories = new ArrayList<OntologyCategoryDto>();
            int index = nodeIds.getIndexForId(nodeId);
            for (int category = 0; category < numCategories; ++category) {
                String categoryName;
                OntologyCategoryDto categoryVO;
                double x = annoData.get(index, category);
                long longx = Math.round(x);
                if (longx != 1L || (categoryVO = categoryIdToVO.get(categoryName = goIds.getIdForIndex(category))) == null) continue;
                categories.add(categoryVO);
            }
            annotations.put(nodeId, categories);
        }
        return annotations;
    }

    public static double computeHyperGeo(double x, double N, double n, double k) {
        double h = Gamma.logGamma((double)(k + 1.0)) - Gamma.logGamma((double)(k - x + 1.0)) - Gamma.logGamma((double)(x + 1.0)) + Gamma.logGamma((double)(N - k + 1.0)) - Gamma.logGamma((double)(N - k - n + x + 1.0)) - Gamma.logGamma((double)(n - x + 1.0)) - Gamma.logGamma((double)(N + 1.0)) + Gamma.logGamma((double)(N - n + 1.0)) + Gamma.logGamma((double)(n + 1.0));
        return Math.exp(h);
    }

    public static double computeCumulHyperGeo(double x, double N, double n, double k) {
        double p = 0.0;
        double upperBound = Math.min(n, k);
        for (double i = x; i <= upperBound; i += 1.0) {
            p += ComputeEnrichment.computeHyperGeo(i, N, n, k);
        }
        return p;
    }

    public static DenseVector computeFDRqval(int N, DenseVector pvals) {
        DenseVector ranks = pvals.copy();
        MatrixUtils.rank((Vector)ranks);
        DenseVector ordered = new DenseVector(pvals.size());
        for (int i = 0; i < ranks.size(); ++i) {
            int p = (int)Math.round(ranks.get(i)) - 1;
            ordered.set(p, pvals.get(i));
        }
        DenseVector qval = new DenseVector(pvals.size());
        double minSoFar = Double.MAX_VALUE;
        for (int i = ranks.size() - 1; i >= 0; --i) {
            double p = ordered.get(i);
            int m = i + 1;
            minSoFar = Math.min(minSoFar, (double)N * p / (double)m);
            qval.set(i, minSoFar);
        }
        DenseVector unOrderedqval = new DenseVector(pvals.size());
        for (int i = 0; i < unOrderedqval.size(); ++i) {
            int p = (int)Math.round(ranks.get(i)) - 1;
            unOrderedqval.set(i, qval.get(p));
        }
        return unOrderedqval;
    }

    void setTo(DenseVector v, double val) {
        for (int i = 0; i < v.size(); ++i) {
            v.set(i, val);
        }
    }

    DenseVector makeGeneMaskVector(NodeIds nodeIds, int numGenes) throws ApplicationException {
        DenseVector mask = new DenseVector(numGenes);
        Iterator i$ = this.request.getNodes().iterator();
        while (i$.hasNext()) {
            long nodeId = (Long)i$.next();
            int index = nodeIds.getIndexForId(nodeId);
            mask.set(index, 1.0);
        }
        return mask;
    }

    DenseVector makeGeneMaskVector(double[] degree, int numGenes) throws ApplicationException {
        if (degree.length != numGenes) {
            throw new ApplicationException("inconsistent data");
        }
        DenseVector mask = new DenseVector(numGenes);
        for (int index = 0; index < degree.length; ++index) {
            if (!(degree[index] > 0.0)) continue;
            mask.set(index, 1.0);
        }
        return mask;
    }

    void dotMult(DenseVector x, DenseVector y) {
        for (int i = 0; i < x.size(); ++i) {
            x.set(i, x.get(i) * y.get(i));
        }
    }

    void logStart() {
    }

    void logEnd() {
        logger.info((Object)("completed processing request, duration = " + Logging.duration(this.requestStartTimeMillis, this.requestEndTimeMillis)));
    }

    void logQuery() {
        logger.info((Object)String.format("request for enrichment for organism %s with a set of %d genes using ontology %s qval threshold %f for a minimum of %d categories", this.request.getOrganismId(), this.request.getNodes().size(), this.request.getOntologyId(), this.request.getqValueThreshold(), this.request.getMinCategories()));
        logger.debug((Object)String.format("sample nodes: " + this.request.getNodes(), new Object[0]));
    }

    void checkQuery() throws ApplicationException {
        if (this.request == null) {
            throw new ApplicationException("request object was null");
        }
        if (this.request.getNodes() == null) {
            throw new ApplicationException("list of sample nodes was null");
        }
        if (this.request.getNodes().size() == 0) {
            throw new ApplicationException("list of sample nodes was empty");
        }
        if (this.request.getProgressReporter() == null) {
            throw new ApplicationException("ProgressReporter was null");
        }
    }
}

