/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.actions.support;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.genemania.dto.UploadNetworkEngineRequestDto;
import org.genemania.dto.UploadNetworkEngineResponseDto;
import org.genemania.engine.actions.support.UserDataPrecomputer;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.converter.sym.FileNetworkSymMatrixProvider;
import org.genemania.engine.core.data.Network;
import org.genemania.engine.core.evaluation.ProfileToNetworkDriver;
import org.genemania.engine.core.evaluation.correlation.CorrelationFactory;
import org.genemania.engine.exception.CancellationException;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.exception.ApplicationException;
import org.genemania.type.DataLayout;
import org.genemania.type.NetworkProcessingMethod;
import org.genemania.util.ProgressReporter;

public class UserNetworkProcessor {
    private static Logger logger = Logger.getLogger(UserNetworkProcessor.class);
    private DataCache cache;
    private String tempDirname;

    public UserNetworkProcessor(DataCache cache, String tempDirname) {
        this.cache = cache;
        this.tempDirname = tempDirname;
    }

    private void checkRequest(UploadNetworkEngineRequestDto request) throws ApplicationException {
        if (request == null) {
            throw new ApplicationException("invalid null request");
        }
        if (request.getNamespace() == null || request.getNamespace().trim().equals("")) {
            throw new ApplicationException("no namespace specified");
        }
        if (request.getNetworkId() >= 0L) {
            throw new ApplicationException("user networks must have id < 0");
        }
        if (request.getNetworkId() < Integer.MIN_VALUE) {
            throw new ApplicationException("network ids values must be in integer range, given id: " + request.getNetworkId());
        }
        if (request.getLayout() == DataLayout.PROFILE) {
            if (request.getMethod() != NetworkProcessingMethod.PEARSON) {
                throw new ApplicationException("unsupported processing method for PROFILE data layout");
            }
        } else if (request.getLayout() == DataLayout.WEIGHTED_NETWORK) {
            if (request.getMethod() != NetworkProcessingMethod.DIRECT) {
                throw new ApplicationException("unsupported processing method for WEIGHTED_NETWORK data layout");
            }
        } else if (request.getLayout() == DataLayout.SPARSE_PROFILE) {
            if (request.getMethod() != NetworkProcessingMethod.LOG_FREQUENCY) {
                throw new ApplicationException("unsupported processing method for SPARSE_PROFILE data layout");
            }
        } else if (request.getLayout() == DataLayout.BINARY_NETWORK) {
            if (request.getMethod() != NetworkProcessingMethod.LOG_FREQUENCY && request.getMethod() != NetworkProcessingMethod.DIRECT) {
                throw new ApplicationException("unsupported processing method for BINARY_NETWORK data layout");
            }
        } else {
            throw new ApplicationException("unsupported data layout");
        }
    }

    private void logRequestParams(UploadNetworkEngineRequestDto request) {
        logger.info((Object)String.format("processing upload network request for user %s organism %d network id %d with layout %s using processing method %s", request.getNamespace(), request.getOrganismId(), request.getNetworkId(), request.getLayout(), request.getMethod()));
    }

    public UploadNetworkEngineResponseDto process(UploadNetworkEngineRequestDto request) throws ApplicationException {
        this.checkRequest(request);
        this.logRequestParams(request);
        request.getProgressReporter().setStatus("processing network");
        request.getProgressReporter().setProgress(1);
        SymMatrix network = this.convertNetwork(request);
        if (request.getProgressReporter().isCanceled()) {
            throw new CancellationException();
        }
        this.saveNetwork(request, network);
        this.precompute(request, network, request.getProgressReporter());
        UploadNetworkEngineResponseDto response = UserNetworkProcessor.computeStats(network);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SymMatrix convertNetwork(UploadNetworkEngineRequestDto request) throws ApplicationException {
        SymMatrix matrix = null;
        if (request.getMethod() == NetworkProcessingMethod.PEARSON && request.getLayout() == DataLayout.PROFILE) {
            ProfileToNetworkDriver p2n = new ProfileToNetworkDriver();
            try {
                File tempFile = this.getTempFile(request.getNamespace(), (int)request.getOrganismId(), (int)request.getNetworkId());
                logger.debug((Object)("writing temp output to " + tempFile));
                BufferedWriter result = new BufferedWriter(new FileWriter(tempFile));
                try {
                    p2n.setSynReader(this.makeIdMapping((int)request.getOrganismId()));
                    p2n.setNoHeader(true);
                    p2n.setK(request.getSparsification());
                    p2n.setCorrelationType(CorrelationFactory.CorrelationType.PEARSON);
                    p2n.setProfileType("CONTINUOUS");
                    p2n.setProgressReporter(request.getProgressReporter());
                    p2n.process(request.getData(), result);
                }
                finally {
                    ((Writer)result).close();
                }
                matrix = this.convertToMatrixRepresentation(request.getOrganismId(), request.getNetworkId(), request.getNamespace(), request.getProgressReporter(), false);
            }
            catch (IOException e) {
                throw new ApplicationException("Failed to convert profile to network", (Throwable)e);
            }
        }
        if (request.getMethod() == NetworkProcessingMethod.DIRECT && request.getLayout() == DataLayout.WEIGHTED_NETWORK) {
            try {
                File tempFile = this.getTempFile(request.getNamespace(), (int)request.getOrganismId(), (int)request.getNetworkId());
                logger.debug((Object)("writing temp output to " + tempFile));
                BufferedWriter result = new BufferedWriter(new FileWriter(tempFile));
                try {
                    int n;
                    char[] buf = new char[1024];
                    Reader data = request.getData();
                    while ((n = data.read(buf)) > 0) {
                        ((Writer)result).write(buf, 0, n);
                    }
                }
                finally {
                    ((Writer)result).close();
                }
                matrix = this.convertToMatrixRepresentation(request.getOrganismId(), request.getNetworkId(), request.getNamespace(), request.getProgressReporter(), false);
            }
            catch (Exception e) {
                throw new ApplicationException("Failed to load direct network", (Throwable)e);
            }
        }
        if (request.getMethod() == NetworkProcessingMethod.DIRECT && request.getLayout() == DataLayout.BINARY_NETWORK) {
            try {
                File tempFile = this.getTempFile(request.getNamespace(), (int)request.getOrganismId(), (int)request.getNetworkId());
                logger.debug((Object)("writing temp output to " + tempFile));
                BufferedWriter result = new BufferedWriter(new FileWriter(tempFile));
                try {
                    int n;
                    char[] buf = new char[1024];
                    Reader data = request.getData();
                    while ((n = data.read(buf)) > 0) {
                        ((Writer)result).write(buf, 0, n);
                    }
                }
                finally {
                    ((Writer)result).close();
                }
                matrix = this.convertToMatrixRepresentation(request.getOrganismId(), request.getNetworkId(), request.getNamespace(), request.getProgressReporter(), true);
            }
            catch (Exception e) {
                throw new ApplicationException("Failed to load binary network", (Throwable)e);
            }
        }
        if (request.getMethod() == NetworkProcessingMethod.LOG_FREQUENCY && request.getLayout() == DataLayout.SPARSE_PROFILE) {
            ProfileToNetworkDriver p2n = new ProfileToNetworkDriver();
            try {
                File tempFile = this.getTempFile(request.getNamespace(), (int)request.getOrganismId(), (int)request.getNetworkId());
                logger.debug((Object)("writing temp output to " + tempFile));
                BufferedWriter result = new BufferedWriter(new FileWriter(tempFile));
                try {
                    p2n.setSynReader(this.makeIdMapping((int)request.getOrganismId()));
                    p2n.setNoHeader(true);
                    p2n.setK(request.getSparsification());
                    p2n.setCorrelationType(CorrelationFactory.CorrelationType.PEARSON_BIN_LOG_NO_NORM);
                    p2n.setProfileType("BINARY");
                    p2n.setKeepAllTies(true);
                    p2n.setLimitTies(true);
                    p2n.setProgressReporter(request.getProgressReporter());
                    p2n.process(request.getData(), result);
                }
                finally {
                    ((Writer)result).close();
                }
                matrix = this.convertToMatrixRepresentation(request.getOrganismId(), request.getNetworkId(), request.getNamespace(), request.getProgressReporter(), false);
            }
            catch (IOException e) {
                throw new ApplicationException("Failed to convert profile to network", (Throwable)e);
            }
        }
        if (request.getMethod() == NetworkProcessingMethod.LOG_FREQUENCY && request.getLayout() == DataLayout.BINARY_NETWORK) {
            ProfileToNetworkDriver p2n = new ProfileToNetworkDriver();
            try {
                File tempFile = this.getTempFile(request.getNamespace(), (int)request.getOrganismId(), (int)request.getNetworkId());
                logger.debug((Object)("writing temp output to " + tempFile));
                BufferedWriter result = new BufferedWriter(new FileWriter(tempFile));
                try {
                    p2n.setSynReader(this.makeIdMapping((int)request.getOrganismId()));
                    p2n.setNoHeader(true);
                    p2n.setK(request.getSparsification());
                    p2n.setCorrelationType(CorrelationFactory.CorrelationType.PEARSON_BIN_LOG_NO_NORM);
                    p2n.setProfileType("NETWORK");
                    p2n.setKeepAllTies(true);
                    p2n.setLimitTies(true);
                    p2n.setProgressReporter(request.getProgressReporter());
                    p2n.process(request.getData(), result);
                }
                finally {
                    ((Writer)result).close();
                }
                matrix = this.convertToMatrixRepresentation(request.getOrganismId(), request.getNetworkId(), request.getNamespace(), request.getProgressReporter(), false);
            }
            catch (IOException e) {
                throw new ApplicationException("Failed to convert profile to network", (Throwable)e);
            }
        }
        throw new ApplicationException("unsupported processing method/data layout combination");
        return matrix;
    }

    private File getTempFile(String namespace, int organismId, int networkId) {
        String dirName = this.getUserTempDirname(namespace);
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            dir.mkdir();
        }
        String fileName = dirName + File.separator + String.format("%d.%d.txt", organismId, networkId);
        return new File(fileName);
    }

    private String getTempDirname() {
        return this.tempDirname;
    }

    private String getUserTempDirname(String namespace) {
        return this.getTempDirname() + File.separator + namespace;
    }

    SymMatrix convertToMatrixRepresentation(long organismId, long networkId, String namespace, ProgressReporter progress, boolean isBinary) throws ApplicationException {
        FileNetworkSymMatrixProvider provider = new FileNetworkSymMatrixProvider(organismId, this.getUserTempDirname(namespace), this.cache.getNodeIds(organismId), isBinary);
        SymMatrix matrix = provider.getNetworkMatrix(networkId, progress);
        matrix.compact();
        return matrix;
    }

    void saveNetwork(UploadNetworkEngineRequestDto request, SymMatrix network) throws ApplicationException {
        this.cache.initNamespace(request.getNamespace(), request.getOrganismId());
        Network networkObj = new Network(request.getNamespace(), request.getOrganismId(), request.getNetworkId());
        networkObj.setData(network);
        this.cache.putNetwork(networkObj);
    }

    void precompute(UploadNetworkEngineRequestDto request, SymMatrix network, ProgressReporter progress) throws ApplicationException {
        UserDataPrecomputer precomputer = new UserDataPrecomputer(request.getNamespace(), (int)request.getOrganismId(), this.cache, request.getProgressReporter());
        precomputer.addNetwork((int)request.getNetworkId(), network);
    }

    static UploadNetworkEngineResponseDto computeStats(SymMatrix network) {
        UploadNetworkEngineResponseDto response = new UploadNetworkEngineResponseDto();
        int numInteractions = 0;
        double minVal = Double.POSITIVE_INFINITY;
        double maxVal = Double.NEGATIVE_INFINITY;
        MatrixCursor cursor = network.cursor();
        while (cursor.next()) {
            double val = cursor.val();
            if (val == 0.0) continue;
            ++numInteractions;
            if (val > maxVal) {
                maxVal = val;
            }
            if (!(val < minVal)) continue;
            minVal = val;
        }
        response.setNumInteractions(numInteractions /= 2);
        response.setMinValue(minVal);
        response.setMaxValue(maxVal);
        return response;
    }

    Reader makeIdMapping(long organismId) throws ApplicationException {
        long[] mapping = this.cache.getNodeIds(organismId).getNodeIds();
        if (mapping == null) {
            throw new ApplicationException("Failed to read node mapping from cache");
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < mapping.length; ++i) {
            builder.append(String.format("%s\t%s\n", mapping[i], mapping[i]));
        }
        StringReader reader = new StringReader(builder.toString());
        return reader;
    }
}

