/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.apps;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Scanner;
import org.apache.log4j.Logger;
import org.genemania.domain.Organism;
import org.genemania.engine.apps.AbstractEngineApp;
import org.genemania.engine.config.Config;
import org.genemania.engine.converter.SymbolCache;
import org.genemania.engine.core.data.GoAnnotations;
import org.genemania.engine.core.data.GoIds;
import org.genemania.engine.matricks.Matrix;
import org.genemania.exception.ApplicationException;
import org.kohsuke.args4j.Option;

public class AnnotationCacheBuilder
extends AbstractEngineApp {
    private static Logger logger = Logger.getLogger(AnnotationCacheBuilder.class);
    @Option(name="-annodir", usage="annotation data dir")
    String annoDir;
    @Option(name="-orgId", usage="optional organism id, otherwise will process all oganisms")
    private long orgId = -1L;
    private static int TERM_COL = 2;
    private static int GENE_SYMBOL_COL = 6;

    public String getAnnoDir() {
        return this.annoDir;
    }

    public void setAnnoDir(String annoDir) {
        this.annoDir = annoDir;
    }

    public long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(long orgId) {
        this.orgId = orgId;
    }

    public void logParams() {
        logger.info((Object)("cache dir: " + this.getCacheDir()));
        logger.info((Object)("annotations dir: " + this.annoDir));
    }

    @Override
    public void process() throws Exception {
        if (this.orgId != -1L) {
            throw new ApplicationException("single organism processing not implemented");
        }
        for (Organism organism : this.organismMediator.getAllOrganisms()) {
            this.processOrganism(organism);
        }
    }

    public void processOrganism(Organism organism) throws Exception {
        logger.info((Object)String.format("processing organism %d (%s)", organism.getId(), organism.getName()));
        String annoFile = this.getAnnoFilename(organism.getId());
        GoIds goIds = this.loadTerms(organism, annoFile);
        this.cache.putGoIds(goIds);
        GoAnnotations goAnnos = this.loadAnnos(organism, annoFile, goIds);
        this.cache.putGoAnnotations(goAnnos);
    }

    String getAnnoFilename(long organismId) {
        return String.format("%s%s%d.annos.txt", this.annoDir, File.separator, organismId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GoIds loadTerms(Organism organism, String annoFile) throws IOException {
        HashSet<String> uniqueTerms = new HashSet<String>();
        Scanner scanner = new Scanner(new File(annoFile));
        try {
            while (scanner.hasNextLine()) {
                String[] tokens;
                String termName;
                String line = scanner.nextLine();
                if (line.startsWith("#") || "all".equalsIgnoreCase(termName = (tokens = line.split("\t"))[TERM_COL])) continue;
                uniqueTerms.add(termName);
            }
        }
        finally {
            scanner.close();
        }
        logger.info((Object)("total number of unique terms extracted: " + uniqueTerms.size()));
        GoIds goIds = new GoIds(organism.getId(), "ALL");
        String[] goIdList = uniqueTerms.toArray(new String[0]);
        goIds.setGoIds(goIdList);
        return goIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GoAnnotations loadAnnos(Organism organism, String annoFile, GoIds goIds) throws IOException, ApplicationException {
        Scanner scanner = new Scanner(new File(annoFile));
        SymbolCache symbolCache = new SymbolCache(organism, this.getGeneMediator(), this.getCache());
        int numCats = goIds.getGoIds().length;
        int numNodes = this.cache.getNodeIds(organism.getId()).getNodeIds().length;
        Matrix annoData = Config.instance().getMatrixFactory().sparseMatrix(numNodes, numCats);
        try {
            while (scanner.hasNextLine()) {
                Integer geneIndex;
                String line = scanner.nextLine();
                if (line.startsWith("#")) continue;
                String[] tokens = line.split("\t");
                String termName = tokens[TERM_COL];
                String geneSymbol = tokens[GENE_SYMBOL_COL];
                if ("all".equalsIgnoreCase(termName) || (geneIndex = symbolCache.getIndexForSymbol(geneSymbol)) == null) continue;
                int termIndex = goIds.getIndexForId(termName);
                annoData.set(geneIndex, termIndex, 1.0);
            }
        }
        finally {
            scanner.close();
        }
        GoAnnotations goAnnos = new GoAnnotations(organism.getId(), "ALL");
        goAnnos.setData(annoData);
        return goAnnos;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.logParams();
    }

    public static void main(String[] args) throws Exception {
        AnnotationCacheBuilder acb = new AnnotationCacheBuilder();
        if (!acb.getCommandLineArgs(args)) {
            System.exit(1);
        }
        acb.setupLogging();
        try {
            acb.init();
            acb.process();
            acb.cleanup();
        }
        catch (Exception e) {
            logger.error((Object)"Fatal error", (Throwable)e);
            System.exit(1);
        }
    }
}

