/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.apps;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.genemania.domain.Organism;
import org.genemania.engine.apps.AbstractEngineApp;
import org.genemania.engine.summary.AttributesDumper;
import org.genemania.engine.summary.GMTReporterFactory;
import org.genemania.engine.summary.IdentifiersDumper;
import org.genemania.engine.summary.NetworksDumper;
import org.genemania.engine.summary.PrecombinedDumper;
import org.genemania.engine.summary.PreferredNames;
import org.genemania.engine.summary.ReporterFactory;
import org.genemania.engine.summary.Summarizer;
import org.genemania.engine.summary.TabularReporterFactory;
import org.kohsuke.args4j.Option;

public class DatasetPublisher
extends AbstractEngineApp {
    private static Logger logger = Logger.getLogger(DatasetPublisher.class);
    @Option(name="-reportDir", usage="location of report directory")
    private String reportDir;
    @Option(name="-combined", usage="what combined networks do we want, defaults to 'BP.DEFAULT', other values 'ALL', 'NONE'")
    private String combinedNetworksFilter = "BP.DEFAULT";
    private String reportSubdir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void summarize(Summarizer summarizer, ReporterFactory reporterFactory) throws Exception {
        summarizer.setUp();
        try {
            summarizer.summarize(reporterFactory);
        }
        finally {
            summarizer.tearDown();
        }
    }

    @Override
    public void init() throws Exception {
        super.init();
    }

    void summarizeOrganism(Organism organism) throws Exception {
        String orgname = organism.getAlias();
        orgname = orgname.replace(' ', '_');
        String reportLocation = this.reportSubdir + File.separator + orgname;
        TabularReporterFactory reporterFactory = new TabularReporterFactory(reportLocation);
        Summarizer summarizer = null;
        PreferredNames preferredNames = new PreferredNames(organism.getId(), this.dataConnector, "Ensembl Gene ID", "Entrez Gene ID", "TAIR ID", "Gene Name", "Entrez Gene Name", "Ensembl Gene Name", "Ensembl Protein ID", "Uniprot ID");
        summarizer = new NetworksDumper(organism, this.dataConnector, preferredNames);
        this.summarize(summarizer, reporterFactory);
        summarizer = new IdentifiersDumper(organism, this.dataConnector, preferredNames);
        this.summarize(summarizer, reporterFactory);
        summarizer = new AttributesDumper(organism, this.dataConnector, preferredNames);
        this.summarize(summarizer, new GMTReporterFactory(reportLocation));
        if (!"NONE".equalsIgnoreCase(this.combinedNetworksFilter)) {
            reporterFactory = new TabularReporterFactory(this.reportSubdir + File.separator + orgname + ".COMBINED");
            summarizer = new PrecombinedDumper(organism, this.dataConnector, this.combinedNetworksFilter, preferredNames);
            this.summarize(summarizer, reporterFactory);
        }
    }

    @Override
    public void process() throws Exception {
        Date datasetDate = this.getStatsMediator().getLatestStatistics().getDate();
        System.out.println(datasetDate);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String dirName = df.format(datasetDate);
        this.reportSubdir = this.reportDir + File.separator + dirName;
        logger.info((Object)("writing report to " + this.reportSubdir));
        for (Organism organism : this.organismMediator.getAllOrganisms()) {
            logger.info((Object)String.format("Organism %d: %s", organism.getId(), organism.getName()));
            this.summarizeOrganism(organism);
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            DatasetPublisher instance = new DatasetPublisher();
            instance.getCommandLineArgs(args);
            instance.setupLogging();
            instance.init();
            instance.process();
            instance.cleanup();
            logger.info((Object)"summary report completed.");
        }
        catch (Exception e) {
            logger.error((Object)"Fatal error", (Throwable)e);
            System.exit(1);
        }
    }

    public String getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(String reportDir) {
        this.reportDir = reportDir;
    }

    public String getCombinedNetworksFilter() {
        return this.combinedNetworksFilter;
    }

    public void setCombinedNetworksFilter(String combinedNetworksFilter) {
        this.combinedNetworksFilter = combinedNetworksFilter;
    }
}

