/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.apps;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import no.uib.cipr.matrix.DenseMatrix;
import org.apache.log4j.Logger;
import org.genemania.domain.Organism;
import org.genemania.engine.Constants;
import org.genemania.engine.apps.AbstractEngineApp;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.core.data.AttributeGroups;
import org.genemania.engine.core.data.CoAnnotationSet;
import org.genemania.engine.core.data.FeatureTargetCorrelation;
import org.genemania.engine.core.data.GoAnnotations;
import org.genemania.engine.core.data.KtK;
import org.genemania.engine.core.data.KtKFeatures;
import org.genemania.engine.core.data.KtT;
import org.genemania.engine.core.data.NetworkIds;
import org.genemania.engine.core.integration.CoAnnoTargetBuilder;
import org.genemania.engine.core.integration.CorrelatedAttributeSelector;
import org.genemania.engine.core.integration.Feature;
import org.genemania.engine.core.integration.FeatureList;
import org.genemania.engine.core.integration.TargetMatricesGenerator;
import org.genemania.engine.core.integration.gram.BasicGramBuilder;
import org.genemania.exception.ApplicationException;
import org.genemania.mediator.GeneMediator;
import org.genemania.mediator.NetworkMediator;
import org.genemania.mediator.NodeMediator;
import org.genemania.mediator.OrganismMediator;
import org.genemania.util.NullProgressReporter;
import org.genemania.util.ProgressReporter;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class FastWeightCacheBuilder
extends AbstractEngineApp {
    private static Logger logger = Logger.getLogger(FastWeightCacheBuilder.class);
    @Option(name="-qdir", usage="name of file name containing positiver go terms")
    private static String queryDir;
    @Option(name="-orgId", usage="optional organism id, otherwise will process all oganisms")
    private static int orgId;
    @Option(name="-incAttr", usage="include attributes in KtK/KtT")
    private boolean includeAttributes = false;

    @Override
    public NodeMediator getNodeMediator() {
        return this.nodeMediator;
    }

    @Override
    public void setNodeMediator(NodeMediator nodeMediator) {
        this.nodeMediator = nodeMediator;
    }

    @Override
    public OrganismMediator getOrganismMediator() {
        return this.organismMediator;
    }

    @Override
    public void setOrganismMediator(OrganismMediator organismMediator) {
        this.organismMediator = organismMediator;
    }

    @Override
    public NetworkMediator getNetworkMediator() {
        return this.networkMediator;
    }

    @Override
    public void setNetworkMediator(NetworkMediator networkMediator) {
        this.networkMediator = networkMediator;
    }

    @Override
    public GeneMediator getGeneMediator() {
        return this.geneMediator;
    }

    @Override
    public void setGeneMediator(GeneMediator geneMediator) {
        this.geneMediator = geneMediator;
    }

    @Override
    public void setCache(DataCache cache) {
        this.cache = cache;
    }

    @Override
    public DataCache getCache() {
        return this.cache;
    }

    public void setIncludeAttributes(boolean includeAttributes) {
        this.includeAttributes = includeAttributes;
    }

    public boolean isIncludeAttributes() {
        return this.includeAttributes;
    }

    public void processAllOrganisms() throws Exception {
        this.processAllOrganisms(NullProgressReporter.instance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAllOrganisms(ProgressReporter progress) throws Exception {
        for (Organism organism : this.organismMediator.getAllOrganisms()) {
            this.processOrganism(organism, progress);
        }
    }

    public void processOrganism(int organismId, ProgressReporter progress) throws Exception {
        Organism organism = this.organismMediator.getOrganism((long)organismId);
        this.processOrganism(organism, progress);
    }

    public void processOrganism(Organism organism, ProgressReporter progress) throws Exception {
        this.loadAnnos(organism);
        this.buildFastWeightDataForOrganism(organism, progress);
    }

    public void loadAnnos(Organism organism) throws ApplicationException, IOException {
        TargetMatricesGenerator gen = new TargetMatricesGenerator(organism, this.getGeneMediator(), this.getCache());
        String filebase = queryDir + File.separator + organism.getId();
        for (String goBranch : Constants.goBranches) {
            String filename = filebase + "_" + goBranch + ".txt";
            logger.info((Object)("getting labels from file: " + filename));
            gen.load(filename, goBranch);
        }
    }

    public void buildFastWeightDataForOrganism(Organism organism, ProgressReporter progress) throws ApplicationException {
        logger.info((Object)("processing organism " + organism.getId() + " " + organism.getName()));
        Collection<Collection<Long>> groupedIdList = FastWeightCacheBuilder.getAllNetworks(organism);
        int numNetworks = FastWeightCacheBuilder.count(groupedIdList);
        NetworkIds networkIds = this.makeNetworkIds(organism, groupedIdList);
        this.cache.putNetworkIds(networkIds);
        logger.debug((Object)("Number of Network is : " + numNetworks));
        HashSet<Feature> attributesForAllBranches = new HashSet<Feature>();
        HashMap<Long, FeatureTargetCorrelation> ftcMap = new HashMap<Long, FeatureTargetCorrelation>();
        for (String goBranch : Constants.goBranches) {
            logger.info((Object)("processing branch: " + goBranch));
            GoAnnotations goAnnos = this.cache.getGoAnnotations(organism.getId(), goBranch);
            CoAnnotationSet annoSet = CoAnnoTargetBuilder.computeCoAnnoationSet(organism.getId(), goBranch, goAnnos.getData());
            this.cache.putCoAnnotationSet(annoSet);
            if (!this.includeAttributes) continue;
            int attributesLimit = 30;
            ArrayList<Long> attributeGroupIds = this.getAttributeGroupIds("CORE", organism);
            FeatureList attributesForBranch = this.computeAttributeCorrelations(ftcMap, "CORE", organism, goBranch, attributeGroupIds, attributesLimit);
            attributesForAllBranches.addAll(attributesForBranch);
        }
        if (this.includeAttributes) {
            for (FeatureTargetCorrelation featureTargetCorrelations : ftcMap.values()) {
                this.cache.putData(featureTargetCorrelations);
            }
        }
        BasicGramBuilder builder = new BasicGramBuilder(this.cache, "CORE", organism.getId(), NullProgressReporter.instance());
        FeatureList networkFeatureList = this.makeNetworkFeatureList(networkIds);
        FeatureList networksAndAttributes = new FeatureList();
        networksAndAttributes.addAll(networkFeatureList);
        networksAndAttributes.addAll(attributesForAllBranches);
        Collections.sort(networksAndAttributes);
        networksAndAttributes.addBias();
        logger.debug((Object)String.format("building KtK, size %dx%d", networksAndAttributes.size(), networksAndAttributes.size()));
        DenseMatrix basicKtK = builder.buildBasicKtK(networksAndAttributes, NullProgressReporter.instance());
        KtK ktk = new KtK("CORE", organism.getId(), Constants.DataFileNames.KtK_BASIC.getCode());
        ktk.setData(basicKtK);
        this.cache.putKtK(ktk);
        KtKFeatures ktkFeatures = new KtKFeatures("CORE", organism.getId());
        ktkFeatures.setFeatures(networksAndAttributes);
        this.cache.putData(ktkFeatures);
        for (String goBranch : Constants.goBranches) {
            logger.info((Object)("processing branch: " + goBranch));
            CoAnnotationSet annoSet = this.cache.getCoAnnotationSet(organism.getId(), goBranch);
            DenseMatrix Ktt = builder.buildKtT(networksAndAttributes, annoSet, NullProgressReporter.instance());
            KtT kttData = new KtT("CORE", organism.getId(), goBranch);
            kttData.setData(Ktt);
            this.cache.putKtT(kttData);
        }
    }

    public FeatureList computeAttributeCorrelations(HashMap<Long, FeatureTargetCorrelation> ftcMap, String namespace, Organism organism, String goBranch, ArrayList<Long> attributeGroupIds, int maxAttributes) throws ApplicationException {
        FeatureList topCorrelatedAttributesForAllGroups = new FeatureList();
        for (long attributeGroupId : attributeGroupIds) {
            FeatureTargetCorrelation ftc = ftcMap.get(attributeGroupId);
            if (ftc == null) {
                ftc = new FeatureTargetCorrelation(namespace, organism.getId(), attributeGroupId);
                ftc.setCorrelations(new HashMap<String, FeatureList>());
                ftcMap.put(attributeGroupId, ftc);
            }
            CorrelatedAttributeSelector attributeSelector = new CorrelatedAttributeSelector(this.cache, goBranch, 0);
            FeatureList attributesForBranch = attributeSelector.selectAttributes(organism.getId(), attributeGroupId);
            ftc.getCorrelations().put(goBranch, attributesForBranch);
            topCorrelatedAttributesForAllGroups.addAll(attributesForBranch.subList(0, maxAttributes));
        }
        return topCorrelatedAttributesForAllGroups;
    }

    private ArrayList<Long> getAttributeGroupIds(String namespace, Organism organism) throws ApplicationException {
        ArrayList<Long> attributeGroupIds = new ArrayList<Long>();
        try {
            AttributeGroups groups = this.cache.getAttributeGroups(namespace, organism.getId());
            attributeGroupIds.addAll(groups.getAttributeGroups().keySet());
        }
        catch (ApplicationException e) {
            logger.warn((Object)String.format("no attribute groups found for %d, skipping (%s)", organism.getId(), e.toString()));
        }
        return attributeGroupIds;
    }

    public NetworkIds makeNetworkIds(Organism organism, Collection<Collection<Long>> ids) {
        int numNetworks = FastWeightCacheBuilder.count(ids);
        long[] idsTable = new long[numNetworks];
        int i = 0;
        for (Collection<Long> group : ids) {
            for (Long id : group) {
                idsTable[i] = id;
                ++i;
            }
        }
        NetworkIds networkIds = new NetworkIds("CORE", organism.getId());
        networkIds.setNetworkIds(idsTable);
        return networkIds;
    }

    public FeatureList makeNetworkFeatureList(NetworkIds networkIds) {
        FeatureList featureList = new FeatureList();
        long fakeGroupId = 1L;
        for (long networkId : networkIds.getNetworkIds()) {
            Feature feature = new Feature(Constants.NetworkType.SPARSE_MATRIX, fakeGroupId, networkId);
            featureList.add(feature);
        }
        return featureList;
    }

    public void selectAttributes() {
        if (this.includeAttributes) {
            // empty if block
        }
    }

    @Override
    public boolean getCommandLineArgs(String[] args) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java -jar myprogram.jar [options...] arguments...");
            parser.printUsage((OutputStream)System.err);
            return false;
        }
        return true;
    }

    @Override
    public void process() throws Exception {
        if (orgId == -1) {
            this.processAllOrganisms();
        } else {
            this.processOrganism(orgId, NullProgressReporter.instance());
        }
    }

    public static void main(String[] args) throws Exception {
        FastWeightCacheBuilder cacheBuilder = new FastWeightCacheBuilder();
        cacheBuilder.getCommandLineArgs(args);
        try {
            cacheBuilder.init();
            cacheBuilder.process();
            cacheBuilder.cleanup();
        }
        catch (Exception e) {
            logger.error((Object)"Fatal exception", (Throwable)e);
            System.exit(1);
        }
    }

    static {
        orgId = -1;
    }
}

