/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.apps;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.FlexCompColMatrix;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.genemania.engine.converter.Mapping;
import org.genemania.engine.core.MatrixUtils;
import org.genemania.engine.utils.FileUtils;
import org.genemania.exception.ApplicationException;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class NetworkNormalizer {
    private static Logger logger = Logger.getLogger(NetworkNormalizer.class);
    private static String MAPPING_FILE_ENCODING = "utf8";
    private static String NETWORK_FILE_ENCODING = "utf8";
    @Option(name="-in", usage="name of input file containing network data")
    private String inFilename;
    @Option(name="-out", usage="name of output file to contain output network")
    private String outFilename;
    @Option(name="-log", usage="name of processing log file to create (will truncate old file)")
    private String logFilename;
    @Option(name="-syn", usage="name of identifier naming files")
    private String synFilename;
    @Option(name="-norm", usage="normalize the interactions, -norm {true|false}, defaults to true")
    private String normalize = "true";
    @Option(name="-outtype", usage="output network using names or unique ids, -outtype {name,uid,uidstripped}, defaults to uid")
    private String outType = "uid";
    @Option(name="-k", usage="nearest k neighbours threshold, no sparsification if not given")
    private int k = 0;
    boolean forceUpper = true;
    boolean isNormalizationEnabled;
    Mapping<String, String> mapping;
    Matrix network;
    Set<String> unrecognizedIdentifiers = new HashSet<String>();

    public String getOutType() {
        return this.outType;
    }

    public void setOutType(String outType) {
        this.outType = outType;
    }

    public static void main(String[] args) throws Exception {
        NetworkNormalizer normalizer = new NetworkNormalizer();
        if (!normalizer.getCommandLineArgs(args)) {
            System.exit(1);
        }
        normalizer.setupLogging();
        try {
            normalizer.process();
        }
        catch (Exception e) {
            logger.error((Object)"Fatal error", (Throwable)e);
        }
    }

    public String getInFilename() {
        return this.inFilename;
    }

    public void setInFilename(String inFilename) {
        this.inFilename = inFilename;
    }

    public String getOutFilename() {
        return this.outFilename;
    }

    public void setOutFilename(String outFilename) {
        this.outFilename = outFilename;
    }

    public String getLogFilename() {
        return this.logFilename;
    }

    public void setLogFilename(String logFilename) {
        this.logFilename = logFilename;
    }

    public String getSynFilename() {
        return this.synFilename;
    }

    public void setSynFilename(String synFilename) {
        this.synFilename = synFilename;
    }

    protected boolean getCommandLineArgs(String[] args) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
            this.isNormalizationEnabled = Boolean.parseBoolean(this.normalize);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java -jar myprogram.jar [options...] arguments...");
            parser.printUsage((OutputStream)System.err);
            return false;
        }
        return true;
    }

    public String getNormalize() {
        return this.normalize;
    }

    public void setNormalize(String normalize) {
        this.normalize = normalize;
    }

    public boolean isNormalizationEnabled() {
        return this.isNormalizationEnabled;
    }

    public void setNormalizationEnabled(boolean isNormalizationEnabled) {
        this.isNormalizationEnabled = isNormalizationEnabled;
    }

    private void setupLogging() throws Exception {
        if (this.logFilename == null) {
            return;
        }
        SimpleLayout layout = new SimpleLayout();
        FileAppender appender = new FileAppender((Layout)layout, this.logFilename, false);
        logger.addAppender((Appender)appender);
        logger.setLevel(Level.DEBUG);
    }

    public void process() throws Exception {
        this.loadMapping();
        this.loadNetwork(this.inFilename, '\t', 0, 1, 2);
        MatrixUtils.setDiagonalZero(this.network);
        if (this.k > 0) {
            logger.info((Object)("sparsifying to top " + this.k + " interactions"));
            NetworkNormalizer.sparsifyRowsTopKPositives(this.network, this.k);
        }
        MatrixUtils.setToMaxTranspose(this.network);
        if (this.isNormalizationEnabled()) {
            MatrixUtils.normalizeNetwork(this.network);
        }
        this.writeNetwork();
    }

    void loadMapping() throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.synFilename), MAPPING_FILE_ENCODING));
        this.mapping = FileUtils.loadMapping(reader, '\t', 0, 1, this.forceUpper);
        ((Reader)reader).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadNetwork(String fileName, char delim, int sourceColNum, int targetColNum, int weightColNum) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.inFilename), NETWORK_FILE_ENCODING));
        try {
            this.network = this.loadNetwork(reader, delim, sourceColNum, targetColNum, weightColNum);
        }
        finally {
            ((Reader)reader).close();
        }
    }

    public Matrix loadNetwork(Reader source, char delim, int sourceColNum, int targetColNum, int weightColNum) throws Exception {
        String[] nextLine;
        CSVReader reader = new CSVReader(source, delim);
        FlexCompColMatrix m = new FlexCompColMatrix(this.mapping.size(), this.mapping.size());
        FlexCompColMatrix counts = new FlexCompColMatrix(this.mapping.size(), this.mapping.size());
        while ((nextLine = reader.readNext()) != null) {
            double weight;
            String toSymbol;
            String fromSymbol;
            try {
                fromSymbol = nextLine[sourceColNum].trim();
                toSymbol = nextLine[targetColNum].trim();
                if (this.forceUpper) {
                    fromSymbol = fromSymbol.toUpperCase();
                    toSymbol = toSymbol.toUpperCase();
                }
                weight = Double.parseDouble(nextLine[weightColNum]);
            }
            catch (NumberFormatException e) {
                System.out.println("ignoring: " + e);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println("ignoring: " + e);
                continue;
            }
            int fromIndex = this.mapping.getIndexForUniqueId(this.mapping.getUniqueIdForAlias(fromSymbol));
            int toIndex = this.mapping.getIndexForUniqueId(this.mapping.getUniqueIdForAlias(toSymbol));
            if (fromIndex == -1) {
                if (this.unrecognizedIdentifiers.contains(fromSymbol)) continue;
                logger.warn((Object)String.format("failed to find symbol: \"%s\"", fromSymbol));
                this.unrecognizedIdentifiers.add(fromSymbol);
                continue;
            }
            if (toIndex == -1) {
                if (this.unrecognizedIdentifiers.contains(toSymbol)) continue;
                logger.warn((Object)String.format("failed to find symbol: \"%s\"", toSymbol));
                this.unrecognizedIdentifiers.add(toSymbol);
                continue;
            }
            double count = counts.get(fromIndex, toIndex);
            if (count > 0.0 || m.get(fromIndex, toIndex) != 0.0) {
                m.set(fromIndex, toIndex, m.get(fromIndex, toIndex) + weight);
                counts.set(fromIndex, toIndex, count += 1.0);
                continue;
            }
            m.set(fromIndex, toIndex, weight);
        }
        for (MatrixEntry e : counts) {
            if (e.row() == e.column()) continue;
            double newValue = m.get(e.row(), e.column()) / (e.get() + 1.0);
            m.set(e.row(), e.column(), newValue);
        }
        reader.close();
        return m;
    }

    public static void sparsifyRowsTopKPositives(Matrix m, int k) {
        for (int i = 0; i < m.numRows(); ++i) {
            Vector v = MatrixUtils.extractRowToVector(m, i);
            int[] indices = MatrixUtils.getIndicesForSortedValues(v);
            for (int j = k; j < indices.length && v.get(indices[j]) > 0.0; ++j) {
                m.set(i, indices[j], 0.0);
            }
        }
    }

    public void writeNetwork() throws Exception {
        PrintWriter writer = new PrintWriter(new File(this.outFilename));
        if (this.outType.equalsIgnoreCase("uid")) {
            FileUtils.dump(writer, this.network, this.mapping, '\t', true, false);
        } else if (this.outType.equalsIgnoreCase("uidstripped")) {
            FileUtils.dump(writer, this.network, this.mapping, '\t', true, true);
        } else if (this.outType.equalsIgnoreCase("name")) {
            FileUtils.dump(writer, this.network, this.mapping, '\t', false, false);
        } else {
            throw new ApplicationException("Unexpected output type: " + this.outType);
        }
        writer.close();
    }
}

