/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.apps;

import java.util.Collection;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.genemania.domain.Organism;
import org.genemania.engine.apps.AbstractEngineApp;
import org.genemania.engine.apps.CacheBuilder;
import org.genemania.engine.core.data.DatasetInfo;
import org.genemania.engine.core.data.Network;
import org.genemania.engine.core.data.NodeDegrees;
import org.genemania.engine.core.data.NodeIds;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.exception.ApplicationException;
import org.kohsuke.args4j.Option;

public class NodeDegreeComputer
extends AbstractEngineApp {
    private static Logger logger = Logger.getLogger(CacheBuilder.class);
    @Option(name="-orgId", usage="optional organism id, otherwise will process all oganisms")
    private long orgId = -1L;
    int numGenes;
    DenseVector degreesInOrganism;
    int numConnectedGenes;

    public long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(long orgId) {
        this.orgId = orgId;
    }

    public int getNumConnectedGenes() {
        return this.numConnectedGenes;
    }

    @Override
    public void setupLogging() throws Exception {
        if (this.logFilename == null) {
            return;
        }
        SimpleLayout layout = new SimpleLayout();
        FileAppender appender = new FileAppender((Layout)layout, this.logFilename, false);
        logger.addAppender((Appender)appender);
        logger.setLevel(Level.DEBUG);
    }

    public void logParams() {
        logger.info((Object)("cache dir: " + this.getCacheDir()));
    }

    public void processAllOrganisms() throws Exception {
        for (Organism organism : this.organismMediator.getAllOrganisms()) {
            this.processOrganism(organism);
        }
    }

    public void processOrganism(Organism organism) throws Exception {
        logger.info((Object)String.format("computing degrees for organism %d (%s)", organism.getId(), organism.getName()));
        this.allocDataStructures(organism);
        this.computeDegrees(organism);
        this.countNodesWithPositiveDegree();
        this.write(organism);
        this.log();
    }

    protected void allocDataStructures(Organism organism) throws ApplicationException {
        NodeIds nodeIds = this.cache.getNodeIds(organism.getId());
        this.numGenes = nodeIds.getNodeIds().length;
        this.degreesInOrganism = new DenseVector(this.numGenes);
    }

    protected void computeDegrees(Organism organism) throws ApplicationException {
        Collection<Collection<Long>> groupedNetworks = NodeDegreeComputer.getAllNetworks(organism);
        this.degreesInOrganism.zero();
        DenseVector degreesInNetwork = new DenseVector(this.numGenes);
        for (Collection<Long> networks : groupedNetworks) {
            for (long networkId : networks) {
                degreesInNetwork.zero();
                Network network = this.cache.getNetwork("CORE", organism.getId(), networkId);
                SymMatrix networkData = network.getData();
                networkData.columnSums(degreesInNetwork.getData());
                this.degreesInOrganism.add((Vector)degreesInNetwork);
            }
        }
    }

    protected int countNodesWithPositiveDegree() {
        this.numConnectedGenes = 0;
        for (VectorEntry e : this.degreesInOrganism) {
            if (!(e.get() > 0.0)) continue;
            ++this.numConnectedGenes;
        }
        return this.numConnectedGenes;
    }

    protected void write(Organism organism) throws ApplicationException {
        NodeDegrees nodeDegrees = new NodeDegrees("CORE", organism.getId());
        nodeDegrees.setDegrees(this.degreesInOrganism);
        this.cache.putNodeDegrees(nodeDegrees);
        DatasetInfo datasetInfo = this.cache.getDatasetInfo(organism.getId());
        datasetInfo.setNumInteractingGenes(this.numConnectedGenes);
        this.cache.putDatasetInfo(datasetInfo);
    }

    protected void log() throws ApplicationException {
        logger.info((Object)String.format("Total genes: %d, num interacting genes: %d", this.numGenes, this.numConnectedGenes));
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.logParams();
    }

    @Override
    public void process() throws Exception {
        if (this.orgId != -1L) {
            Organism organism = this.getOrganismMediator().getOrganism(this.orgId);
            if (organism == null) {
                throw new ApplicationException("failed to find organims: " + this.orgId);
            }
            this.processOrganism(organism);
        } else {
            this.processAllOrganisms();
        }
    }

    public static void main(String[] args) throws Exception {
        NodeDegreeComputer ndc = new NodeDegreeComputer();
        if (!ndc.getCommandLineArgs(args)) {
            System.exit(1);
        }
        try {
            ndc.init();
            ndc.process();
            ndc.cleanup();
        }
        catch (Exception e) {
            logger.error((Object)"Fatal error", (Throwable)e);
            System.exit(1);
        }
    }
}

