/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.cache;

import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import org.genemania.engine.cache.IObjectCache;
import org.genemania.engine.cache.SoftRefObjectCache;
import org.genemania.exception.ApplicationException;

public class MemObjectCache
implements IObjectCache {
    private static Logger logger = Logger.getLogger(MemObjectCache.class);
    IObjectCache underlyingCache;
    SoftRefObjectCache memCache = SoftRefObjectCache.instance();
    public static final String CORE = "core";

    public MemObjectCache(IObjectCache underlyingCache) {
        this.underlyingCache = underlyingCache;
    }

    @Override
    public String getCacheDir() throws ApplicationException {
        return this.underlyingCache.getCacheDir();
    }

    protected String makeMemCacheKey(String namespace, String key) {
        if (namespace == null) {
            return String.format("%s.%s", CORE, key);
        }
        return String.format("%s.%s", namespace, key);
    }

    @Override
    public void put(String[] key, Object value, boolean isVolatile) throws ApplicationException {
        if (!isVolatile) {
            this.memCache.put(this.makeMemCacheKey(key), value);
        }
        this.underlyingCache.put(key, value, isVolatile);
    }

    @Override
    public Object get(String[] key, boolean isVolatile) throws ApplicationException {
        Object object = null;
        String memCacheKey = this.makeMemCacheKey(key);
        if (isVolatile) {
            logger.debug((Object)String.format("volatile object %s, skipping memory cache", memCacheKey));
            object = this.underlyingCache.get(key, isVolatile);
        } else {
            object = this.memCache.get(memCacheKey);
            if (object == null) {
                logger.debug((Object)String.format("memory cache miss for %s", memCacheKey));
                object = this.underlyingCache.get(key, isVolatile);
                this.memCache.put(memCacheKey, object);
            }
        }
        return object;
    }

    @Override
    public void remove(String[] key) throws ApplicationException {
        this.memCache.remove(this.makeMemCacheKey(key));
        this.underlyingCache.remove(key);
    }

    @Override
    public boolean exists(String[] key) throws ApplicationException {
        return this.underlyingCache.exists(key);
    }

    @Override
    public List<String[]> list(String[] key) throws ApplicationException {
        return this.underlyingCache.list(key);
    }

    private String makeMemCacheKey(String[] key) throws ApplicationException {
        StringBuilder path = new StringBuilder();
        for (int i = 0; i < key.length; ++i) {
            path.append(File.separator);
            if (key[i] == null || key[i].equals("")) {
                throw new ApplicationException("missing key part at position " + i);
            }
            path.append(key[i]);
        }
        return path.toString();
    }
}

