/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core;

import java.util.ArrayList;
import java.util.List;

public class KHeap {
    private int maxSize;
    private double[] data;
    private int size;
    private boolean extensible = false;
    private List<Double> additionalData;

    public KHeap(int maxSize) {
        this.maxSize = maxSize;
        this.data = new double[2 * maxSize];
    }

    public KHeap(int maxSize, boolean extensible) {
        this.maxSize = maxSize;
        this.data = new double[2 * maxSize];
        this.extensible = extensible;
    }

    public boolean offer(int id, double weight) {
        if (this.size < this.maxSize) {
            this.data[2 * this.size] = weight;
            this.data[2 * this.size + 1] = id;
            ++this.size;
            this.siftUp(this.size - 1);
            return true;
        }
        if (this.extensible) {
            if (weight < this.data[0]) {
                return false;
            }
            if (weight == this.data[0]) {
                if (this.additionalData == null) {
                    this.additionalData = new ArrayList<Double>();
                }
                this.additionalData.add(weight);
                this.additionalData.add(Double.valueOf(id));
                return true;
            }
            double minWeight = this.data[0];
            double idForMinWeight = this.data[1];
            this.data[0] = weight;
            this.data[1] = id;
            this.siftDown(0);
            if (this.data[0] > minWeight) {
                this.additionalData = null;
            } else {
                if (this.additionalData == null) {
                    this.additionalData = new ArrayList<Double>();
                }
                this.additionalData.add(weight);
                this.additionalData.add(idForMinWeight);
            }
            return true;
        }
        if (weight <= this.data[0]) {
            return false;
        }
        this.data[0] = weight;
        this.data[1] = id;
        this.siftDown(0);
        return true;
    }

    private void swap(int i, int j) {
        double weight = this.data[2 * i];
        double id = this.data[2 * i + 1];
        this.data[2 * i] = this.data[2 * j];
        this.data[2 * i + 1] = this.data[2 * j + 1];
        this.data[2 * j] = weight;
        this.data[2 * j + 1] = id;
    }

    private void siftUp(int index) {
        if (index <= 0) {
            return;
        }
        int ip = (index - 1) / 2;
        if (this.data[2 * ip] > this.data[2 * index]) {
            this.swap(ip, index);
        }
        this.siftUp(ip);
    }

    private void siftDown(int index) {
        if (index >= this.size) {
            return;
        }
        int ip = index;
        int ilc = 2 * index + 1;
        int irc = 2 * index + 2;
        if (ilc > this.size - 1) {
            return;
        }
        if (irc > this.size - 1) {
            if (this.data[2 * ilc] < this.data[2 * ip]) {
                this.swap(index, ilc);
                this.siftDown(ilc);
                return;
            }
        } else {
            if (this.data[2 * ilc] < this.data[2 * ip] && this.data[2 * ilc] <= this.data[2 * irc]) {
                this.swap(index, ilc);
                this.siftDown(ilc);
                return;
            }
            if (this.data[2 * irc] < this.data[2 * ip] && this.data[2 * irc] < this.data[2 * ilc]) {
                this.swap(index, irc);
                this.siftDown(irc);
                return;
            }
        }
    }

    public int size() {
        int additional = this.additionalData == null ? 0 : this.additionalData.size() / 2;
        return this.size + additional;
    }

    public void dump() {
        for (int i = 0; i < this.size; ++i) {
            System.out.print(" " + this.getWeight(i));
        }
        if (this.additionalData != null) {
            for (double e : this.additionalData) {
                System.out.print(" " + e);
            }
        }
        System.out.println("");
    }

    public long getId(int i) {
        if (i < this.size) {
            return Math.round(this.data[2 * i + 1]);
        }
        if (this.additionalData != null) {
            return Math.round(this.additionalData.get(2 * (i - this.size) + 1));
        }
        throw new IndexOutOfBoundsException();
    }

    public double getWeight(int i) {
        if (i < this.size) {
            return this.data[2 * i];
        }
        if (this.additionalData != null) {
            return this.additionalData.get(2 * (i - this.size));
        }
        throw new IndexOutOfBoundsException();
    }

    public int getExtensionSize() {
        if (this.additionalData == null) {
            return 0;
        }
        return this.additionalData.size() / 2;
    }

    public boolean pop() {
        if (this.size() == 0) {
            return false;
        }
        if (this.size() == 1) {
            --this.size;
            return true;
        }
        if (this.additionalData != null) {
            int additionalSize = this.additionalData.size();
            if (additionalSize == 2) {
                this.additionalData = null;
                return true;
            }
            this.additionalData.remove(additionalSize - 1);
            this.additionalData.remove(additionalSize - 2);
            return true;
        }
        --this.size;
        this.data[0] = this.data[2 * this.size];
        this.data[1] = this.data[2 * this.size + 1];
        this.additionalData = null;
        this.siftDown(0);
        return true;
    }

    public int popLE(double threshold) {
        int numPopped = 0;
        if (this.getWeight(0) <= threshold && this.additionalData != null) {
            numPopped = this.additionalData.size() / 2;
            this.additionalData = null;
        }
        boolean popped = true;
        while (popped & this.size > 0 && this.getWeight(0) <= threshold) {
            popped = this.pop();
            if (!popped) continue;
            ++numPopped;
        }
        return numPopped;
    }
}

