/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.sparse.CompColMatrix;
import no.uib.cipr.matrix.sparse.FlexCompColMatrix;
import no.uib.cipr.matrix.sparse.SparseVector;
import org.apache.log4j.Logger;
import org.genemania.engine.core.evaluation.correlation.PearsonRow;

public class MatrixUtils {
    private static Logger logger = Logger.getLogger(MatrixUtils.class);
    private static double DELTA = Math.pow(2.0, -20.0);

    public static Vector columnSums(Matrix m) {
        DenseVector sums = new DenseVector(m.numColumns());
        for (MatrixEntry e : m) {
            sums.set(e.column(), e.get() + sums.get(e.column()));
        }
        return sums;
    }

    public static void columnSums(Matrix m, double[] sums) {
        for (MatrixEntry e : m) {
            sums[e.column()] = e.get() + sums[e.column()];
        }
    }

    public static Vector columnSumsIgnoreMissingData(Matrix m) {
        DenseVector sums = new DenseVector(m.numColumns());
        for (MatrixEntry e : m) {
            if (Double.isNaN(e.get())) continue;
            sums.set(e.column(), e.get() + sums.get(e.column()));
        }
        return sums;
    }

    public static Vector rowSumsIgnoreMissingData(PearsonRow[] values) {
        DenseVector sums = new DenseVector(values.length);
        for (int i = 0; i < values.length; ++i) {
            PearsonRow r = values[i];
            double total = 0.0;
            for (int j = 0; j < r.getNumberOfElements(); ++j) {
                double value = r.getValueAt(j);
                if (Double.isNaN(value)) continue;
                total += value;
            }
            sums.set(i, total);
        }
        return sums;
    }

    public static Vector rowSums(Matrix m) {
        DenseVector sums = new DenseVector(m.numRows());
        for (MatrixEntry e : m) {
            sums.set(e.row(), e.get() + sums.get(e.row()));
        }
        return sums;
    }

    public static void rowSums(Matrix m, double[] result) {
        for (MatrixEntry e : m) {
            result[e.row()] = e.get() + result[e.row()];
        }
    }

    public static Vector rowSumsIgnoreMissingData(Matrix m) {
        DenseVector sums = new DenseVector(m.numRows());
        for (MatrixEntry e : m) {
            if (Double.isNaN(e.get())) continue;
            sums.set(e.row(), e.get() + sums.get(e.row()));
        }
        return sums;
    }

    public static Vector columnMean(Matrix m) {
        int n = m.numRows();
        Vector means = MatrixUtils.columnSums(m);
        means = means.scale(1.0 / (double)n);
        DenseVector corrections = new DenseVector(m.numColumns());
        for (MatrixEntry e : m) {
            corrections.set(e.column(), corrections.get(e.column()) + e.get() - means.get(e.column()));
        }
        corrections = corrections.scale(1.0 / (double)n);
        means = means.add((Vector)corrections);
        return means;
    }

    public static Vector columnCountsIgnoreMissingData(Matrix m) {
        DenseVector counts = new DenseVector(m.numColumns());
        for (MatrixEntry e : m) {
            if (Double.isNaN(e.get())) continue;
            counts.set(e.column(), counts.get(e.column()) + 1.0);
        }
        return counts;
    }

    public static Vector rowCountsIgnoreMissingData(List<Vector> values) {
        DenseVector counts = new DenseVector(values.size());
        for (int i = 0; i < values.size(); ++i) {
            Vector v = values.get(i);
            double numNonZeroes = 0.0;
            for (int j = 0; j < v.size(); ++j) {
                if (Double.isNaN(v.get(j))) continue;
                numNonZeroes += 1.0;
            }
            counts.set(i, numNonZeroes);
        }
        return counts;
    }

    public static Vector rowCountsIgnoreMissingData(Matrix m) {
        DenseVector counts = new DenseVector(m.numRows());
        for (MatrixEntry e : m) {
            if (Double.isNaN(e.get())) continue;
            counts.set(e.row(), counts.get(e.row()) + 1.0);
        }
        return counts;
    }

    public static Vector columnMeanIgnoreMissingData(Matrix m, Vector counts) {
        Vector means = MatrixUtils.columnSumsIgnoreMissingData(m);
        means = MatrixUtils.elementDiv(means, counts);
        DenseVector corrections = new DenseVector(m.numColumns());
        for (MatrixEntry e : m) {
            if (Double.isNaN(e.get())) continue;
            corrections.set(e.column(), corrections.get(e.column()) + e.get() - means.get(e.column()));
        }
        corrections = MatrixUtils.elementDiv((Vector)corrections, counts);
        means = means.add((Vector)corrections);
        return means;
    }

    public static Vector simpleColumnMeanIgnoreMissingData(Matrix m, Vector counts) {
        Vector means = MatrixUtils.columnSumsIgnoreMissingData(m);
        means = MatrixUtils.elementDiv(means, counts);
        return means;
    }

    public static Vector rowMeanIgnoreMissingDataPearsonRow(PearsonRow[] values, Vector counts) {
        Vector means = MatrixUtils.rowSumsIgnoreMissingData(values);
        means = MatrixUtils.elementDiv(means, counts);
        DenseVector corrections = new DenseVector(values.length);
        for (int i = 0; i < values.length; ++i) {
            PearsonRow r = values[i];
            double correction = 0.0;
            double mean = means.get(i);
            for (int j = 0; j < r.getNumberOfElements(); ++j) {
                double value = r.getValueAt(j);
                if (Double.isNaN(value)) continue;
                correction += value - mean;
            }
            corrections.add(i, correction);
        }
        corrections = MatrixUtils.elementDiv((Vector)corrections, counts);
        means = means.add((Vector)corrections);
        return means;
    }

    public static Vector rowMeanIgnoreMissingData(Matrix m) {
        Vector counts = MatrixUtils.rowCountsIgnoreMissingData(m);
        MatrixUtils.recip(counts);
        Vector means = MatrixUtils.rowSumsIgnoreMissingData(m);
        means = MatrixUtils.elementMult(means, counts);
        DenseVector corrections = new DenseVector(m.numRows());
        for (MatrixEntry e : m) {
            if (Double.isNaN(e.get())) continue;
            corrections.set(e.row(), corrections.get(e.row()) + e.get() - means.get(e.row()));
        }
        corrections = MatrixUtils.elementMult((Vector)corrections, counts);
        means = means.add((Vector)corrections);
        return means;
    }

    public static Vector columnVariance(Matrix m, Vector means) {
        DenseVector variances = new DenseVector(m.numColumns());
        DenseVector corrections = new DenseVector(m.numColumns());
        for (MatrixEntry e : m) {
            double d = e.get() - means.get(e.column());
            variances.set(e.column(), variances.get(e.column()) + d * d);
            corrections.set(e.column(), corrections.get(e.column()) + d);
        }
        MatrixUtils.elementMult((Vector)corrections, (Vector)corrections);
        corrections.scale(1.0 / (double)m.numRows());
        variances.add(-1.0, (Vector)corrections);
        variances.scale(1.0 / (double)m.numRows());
        return variances;
    }

    public static Vector columnVarianceIgnoreMissingData(Matrix m, Vector means) {
        DenseVector variances = new DenseVector(m.numColumns());
        DenseVector corrections = new DenseVector(m.numColumns());
        for (MatrixEntry e : m) {
            if (Double.isNaN(e.get())) continue;
            double d = e.get() - means.get(e.column());
            variances.set(e.column(), variances.get(e.column()) + d * d);
            corrections.set(e.column(), corrections.get(e.column()) + d);
        }
        MatrixUtils.elementMult((Vector)corrections, (Vector)corrections);
        Vector counts = MatrixUtils.columnCountsIgnoreMissingData(m);
        MatrixUtils.recip(counts);
        MatrixUtils.elementMult((Vector)corrections, counts);
        variances.add(-1.0, (Vector)corrections);
        MatrixUtils.elementMult((Vector)variances, counts);
        return variances;
    }

    public static Vector simpleColumnVarianceIgnoreMissingData(Matrix m, Vector means) {
        DenseVector variances = new DenseVector(m.numColumns());
        for (MatrixEntry e : m) {
            if (Double.isNaN(e.get())) continue;
            double d = e.get() - means.get(e.column());
            variances.set(e.column(), variances.get(e.column()) + d * d);
        }
        Vector counts = MatrixUtils.columnCountsIgnoreMissingData(m);
        MatrixUtils.recip(counts);
        MatrixUtils.elementMult((Vector)variances, counts);
        return variances;
    }

    public static Vector rowVarianceIgnoreMissingDataPearsonRow(PearsonRow[] values, Vector means, Vector counts) {
        DenseVector variances = new DenseVector(values.length);
        DenseVector corrections = new DenseVector(values.length);
        for (int i = 0; i < values.length; ++i) {
            PearsonRow r = values[i];
            double mean = means.get(i);
            double variance = 0.0;
            double correction = 0.0;
            for (int j = 0; j < r.getNumberOfElements(); ++j) {
                double value = r.getValueAt(j);
                if (Double.isNaN(value)) continue;
                double diff = value - mean;
                variance += diff * diff;
                correction += diff;
            }
            variances.add(i, variance);
            corrections.add(i, correction);
        }
        MatrixUtils.elementMult((Vector)corrections, (Vector)corrections);
        Vector countCopy = counts.copy();
        MatrixUtils.recip(countCopy);
        MatrixUtils.elementMult((Vector)corrections, countCopy);
        variances.add(-1.0, (Vector)corrections);
        MatrixUtils.elementMult((Vector)variances, countCopy);
        return variances;
    }

    public static Vector elementMult(Vector x, Vector y) {
        for (VectorEntry e : x) {
            e.set(e.get() * y.get(e.index()));
        }
        return x;
    }

    public static Vector elementDiv(Vector x, Vector y) {
        for (VectorEntry e : x) {
            e.set(e.get() / y.get(e.index()));
        }
        return x;
    }

    public static Vector recip(Vector x) {
        for (VectorEntry e : x) {
            e.set(1.0 / e.get());
        }
        return x;
    }

    public static Matrix elementMult(Matrix x, Matrix y) {
        for (MatrixEntry e : x) {
            e.set(e.get() * y.get(e.row(), e.column()));
        }
        return x;
    }

    public static Vector absRowSums(Matrix m) {
        DenseVector sums = new DenseVector(m.numRows());
        for (MatrixEntry e : m) {
            sums.set(e.row(), e.get() + Math.abs(sums.get(e.row())));
        }
        return sums;
    }

    public static int countMatches(Vector v, double x) {
        int c = 0;
        for (VectorEntry e : v) {
            if (e.get() != x) continue;
            ++c;
        }
        return c;
    }

    public static double sum(Matrix m) {
        double sum = 0.0;
        for (MatrixEntry e : m) {
            sum += e.get();
        }
        return sum;
    }

    public static double sum(Vector v) {
        double sum = 0.0;
        for (VectorEntry e : v) {
            sum += e.get();
        }
        return sum;
    }

    public static void setMatches(Vector v, double from, double to) {
        for (VectorEntry e : v) {
            if (e.get() != from) continue;
            e.set(to);
        }
    }

    public static int[] find(Vector v, double x) {
        int[] indices = new int[v.size()];
        int i = 0;
        for (VectorEntry e : v) {
            if (e.get() != x) continue;
            indices[i] = e.index();
            ++i;
        }
        int[] result = new int[i];
        System.arraycopy(indices, 0, result, 0, i);
        return result;
    }

    public static int[] findGT(Vector v, double x) {
        int[] indices = new int[v.size()];
        int i = 0;
        for (VectorEntry e : v) {
            if (!(e.get() > x)) continue;
            indices[i] = e.index();
            ++i;
        }
        int[] result = new int[i];
        System.arraycopy(indices, 0, result, 0, i);
        return result;
    }

    public static int[] findGE(Vector v, double x) {
        int[] indices = new int[v.size()];
        int i = 0;
        for (VectorEntry e : v) {
            if (!(e.get() >= x)) continue;
            indices[i] = e.index();
            ++i;
        }
        int[] result = new int[i];
        System.arraycopy(indices, 0, result, 0, i);
        return result;
    }

    public static int[] findLT(Vector v, double x) {
        int[] indices = new int[v.size()];
        int i = 0;
        for (VectorEntry e : v) {
            if (!(e.get() < x)) continue;
            indices[i] = e.index();
            ++i;
        }
        int[] result = new int[i];
        System.arraycopy(indices, 0, result, 0, i);
        return result;
    }

    public static int[] subArray(int[] array, int[] indices) {
        int[] result = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            result[i] = array[indices[i]];
        }
        return result;
    }

    public static int[] arrayJoin(int[] a, int[] b) {
        int[] result = new int[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    public static Matrix getSubMatrix(Matrix network, int[] wantedRowIndices, int[] wantedColumnIndices) {
        FlexCompColMatrix wanted = new FlexCompColMatrix(network.numRows(), network.numColumns());
        for (int ix = 0; ix < wantedRowIndices.length; ++ix) {
            int x = wantedRowIndices[ix];
            for (int iy = 0; iy < wantedColumnIndices.length; ++iy) {
                int y = wantedColumnIndices[iy];
                double weight = network.get(x, y);
                if (weight == 0.0) continue;
                wanted.add(x, y, weight);
            }
        }
        return new CompColMatrix((Matrix)wanted);
    }

    public static void setDiagonalZero(Matrix m) {
        int x = Math.min(m.numRows(), m.numColumns());
        for (int i = 0; i < x; ++i) {
            if (m.get(i, i) == 0.0) continue;
            m.set(i, i, 0.0);
        }
    }

    public static double elementMultiplySum(Matrix a, Matrix b) {
        double sum = 0.0;
        for (MatrixEntry e : a) {
            sum += e.get() * b.get(e.row(), e.column());
        }
        return sum;
    }

    public static int[] filter(int[] a, int x) {
        int[] intermediate = new int[a.length];
        int j = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == x) continue;
            intermediate[j] = a[i];
            ++j;
        }
        int[] result = new int[j];
        System.arraycopy(intermediate, 0, result, 0, j);
        return result;
    }

    public static void sqrt(Vector v) {
        for (VectorEntry e : v) {
            e.set(Math.sqrt(e.get()));
        }
    }

    public static void sqrt(Matrix m) {
        for (MatrixEntry e : m) {
            e.set(Math.sqrt(e.get()));
        }
    }

    public static void log(Matrix m) {
        for (int i = 0; i < m.numRows(); ++i) {
            for (int j = 0; j < m.numColumns(); ++j) {
                m.set(i, j, Math.log(m.get(i, j)));
            }
        }
    }

    public static void log(Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            v.set(i, Math.log(v.get(i)));
        }
    }

    public static void add(Vector v, double x) {
        for (int i = 0; i < v.size(); ++i) {
            v.set(i, v.get(i) + x);
        }
    }

    public static void add(Matrix m, double x) {
        for (int i = 0; i < m.numRows(); ++i) {
            for (int j = 0; j < m.numColumns(); ++j) {
                m.set(i, j, m.get(i, j) + x);
            }
        }
    }

    public static Vector findAllNoneZero(Vector v) {
        int i = 0;
        for (int j = 0; j < v.size(); ++j) {
            if (v.get(j) == 0.0) continue;
            ++i;
        }
        DenseVector temp = new DenseVector(i);
        i = 0;
        for (int j = 0; j < v.size(); ++j) {
            if (v.get(j) == 0.0) continue;
            temp.set(i, (double)j);
            ++i;
        }
        return temp;
    }

    public static <K, V> Map<K, V> makeValueSortedMap(Map<K, V> unsorted, final Comparator<V> comparator) {
        Set<Map.Entry<K, V>> entrySet = unsorted.entrySet();
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(entrySet);
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                Object v1 = o1.getValue();
                Object v2 = o2.getValue();
                return comparator.compare(v1, v2);
            }
        });
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> e : list) {
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }

    public static int[] getIndicesForTopScores(Vector scores, List<Integer> indicesForPositiveNodes, int limitResults, double threshold) {
        class IndexedScore
        implements Comparable {
            int index;
            double score;

            IndexedScore() {
            }

            public int compareTo(Object o) {
                IndexedScore oo = (IndexedScore)o;
                return -Double.compare(this.score, oo.score);
            }
        }
        java.util.Vector<IndexedScore> indexedScores = new java.util.Vector<IndexedScore>();
        for (VectorEntry e : scores) {
            int i = e.index();
            double score = e.get();
            IndexedScore is = new IndexedScore();
            is.index = i;
            is.score = score;
            indexedScores.add(is);
        }
        Collections.sort(indexedScores);
        HashSet<Integer> positiveSet = new HashSet<Integer>();
        positiveSet.addAll(indicesForPositiveNodes);
        int numQueryNodes = positiveSet.size();
        int totalResults = limitResults + positiveSet.size();
        int[] result = new int[totalResults];
        int j = 0;
        int numQueryNodesAdded = 0;
        int numNonQueryNodesAdded = 0;
        for (int i = 0; i < scores.size() && (numQueryNodesAdded < numQueryNodes || numNonQueryNodesAdded < limitResults); ++i) {
            IndexedScore is = (IndexedScore)indexedScores.get(i);
            if (positiveSet.contains(is.index)) {
                positiveSet.remove(is.index);
                ++numQueryNodesAdded;
                result[j] = is.index;
                ++j;
                continue;
            }
            if (numNonQueryNodesAdded >= limitResults || !(is.score > threshold + DELTA)) continue;
            ++numNonQueryNodesAdded;
            result[j] = is.index;
            ++j;
        }
        if (j < totalResults) {
            int[] tmp = new int[j];
            System.arraycopy(result, 0, tmp, 0, j);
            result = tmp;
        }
        return result;
    }

    public static int[] getIndicesForSortedValues(Vector v) {
        java.util.Vector<IndexedScore> indexedScores = new java.util.Vector<IndexedScore>();
        for (VectorEntry e : v) {
            int i = e.index();
            double score = e.get();
            IndexedScore is = new IndexedScore();
            is.index = i;
            is.score = score;
            indexedScores.add(is);
        }
        Collections.sort(indexedScores);
        int[] result = new int[indexedScores.size()];
        for (int i = 0; i < indexedScores.size(); ++i) {
            IndexedScore is = (IndexedScore)indexedScores.get(i);
            result[i] = is.index;
        }
        return result;
    }

    public static Vector extractColumnToVector(Matrix m, int columnIndex) {
        DenseVector result = new DenseVector(m.numRows());
        for (int i = 0; i < m.numRows(); ++i) {
            result.set(i, m.get(i, columnIndex));
        }
        return result;
    }

    public static Vector extractRowToVector(Matrix m, int rowIndex) {
        DenseVector result = new DenseVector(m.numColumns());
        for (int i = 0; i < m.numColumns(); ++i) {
            result.set(i, m.get(rowIndex, i));
        }
        return result;
    }

    public static void setToMaxTranspose(Matrix a) {
        for (MatrixEntry e : a) {
            double v;
            double u = e.get();
            if (u > (v = a.get(e.column(), e.row()))) {
                a.set(e.column(), e.row(), u);
                continue;
            }
            if (!(v > u)) continue;
            e.set(v);
        }
    }

    public static FlexCompColMatrix computeMaxTranspose(Matrix a) {
        FlexCompColMatrix b = new FlexCompColMatrix(a.numRows(), a.numColumns());
        for (MatrixEntry e : a) {
            double u = e.get();
            double v = a.get(e.column(), e.row());
            double max = Math.max(u, v);
            b.set(e.row(), e.column(), max);
            b.set(e.column(), e.row(), max);
        }
        return b;
    }

    public static void replaceMissingData(Matrix m, double value) {
        for (MatrixEntry e : m) {
            if (!Double.isNaN(e.get())) continue;
            e.set(value);
        }
    }

    public static void replaceMissingData(List<Vector> m, double value) {
        for (Vector v : m) {
            for (VectorEntry e : v) {
                if (!Double.isNaN(e.get())) continue;
                v.set(e.index(), value);
            }
        }
    }

    public static boolean[] checkColumnsforMissingDataThreshold(Matrix m, double thresholdPercentage) {
        int numRows = m.numRows();
        int maxNaNs = (int)(thresholdPercentage * (double)numRows / 100.0);
        Vector counts = MatrixUtils.columnCountsIgnoreMissingData(m);
        boolean[] goodCols = new boolean[m.numColumns()];
        for (int col = 0; col < counts.size(); ++col) {
            if ((double)numRows - counts.get(col) > (double)maxNaNs) {
                logger.info((Object)("column " + col + " has " + ((double)numRows - counts.get(col)) + " zeros, threshold is " + maxNaNs));
                goodCols[col] = false;
                continue;
            }
            goodCols[col] = true;
        }
        return goodCols;
    }

    public static double max(Vector v) {
        double m = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < v.size(); ++i) {
            double d = v.get(i);
            if (!(d > m)) continue;
            m = d;
        }
        return m;
    }

    public static void setColumns(Matrix m, int col, double value) {
        for (int row = 0; row < m.numRows(); ++row) {
            m.set(row, col, value);
        }
    }

    public static void setColumn(Matrix m, int col, Vector values) {
        for (int row = 0; row < m.numRows(); ++row) {
            m.set(row, col, values.get(row));
        }
    }

    public static void setRow(Matrix m, int row, Vector values) {
        for (int col = 0; col < m.numColumns(); ++col) {
            m.set(row, col, values.get(col));
        }
    }

    public static void setColumn(Matrix m, int col, double[] values) {
        for (int row = 0; row < m.numRows(); ++row) {
            m.set(row, col, values[row]);
        }
    }

    public static void setColumn(Matrix m, int col, Matrix from, int fromCol) {
        for (int row = 0; row < m.numRows(); ++row) {
            m.set(row, col, from.get(row, fromCol));
        }
    }

    public static void maskFalseColumns(Matrix m, boolean[] columnMasks, double value) {
        for (int col = 0; col < columnMasks.length; ++col) {
            if (columnMasks[col]) continue;
            MatrixUtils.setColumns(m, col, value);
        }
    }

    public static double pearson(double[] xlist, double[] ylist) {
        double xbar = 0.0;
        double ybar = 0.0;
        double sxx = 0.0;
        double sxy = 0.0;
        double syy = 0.0;
        double devx = 0.0;
        double devy = 0.0;
        int size = Math.min(xlist.length, ylist.length);
        int n = 0;
        for (int i = 0; i < size; ++i) {
            double x = xlist[i];
            double y = ylist[i];
            if (Double.isNaN(x) || Double.isNaN(y)) continue;
            devx = x - xbar;
            devy = y - ybar;
            sxx += devx * (x - (xbar += devx / (double)(++n)));
            sxy += devx * (y - (ybar += devy / (double)n));
            syy += devy * (y - ybar);
        }
        return sxy / Math.sqrt(sxx * syy);
    }

    public static double pearsonCleanData(double[] xlist, double[] ylist) {
        double xbar = 0.0;
        double ybar = 0.0;
        double sxx = 0.0;
        double sxy = 0.0;
        double syy = 0.0;
        double devx = 0.0;
        double devy = 0.0;
        int size = Math.min(xlist.length, ylist.length);
        int n = 0;
        for (int i = 0; i < size; ++i) {
            double x = xlist[i];
            double y = ylist[i];
            devx = x - xbar;
            devy = y - ybar;
            sxx += devx * (x - (xbar += devx / (double)(++n)));
            sxy += devx * (y - (ybar += devy / (double)n));
            syy += devy * (y - ybar);
        }
        return sxy / Math.sqrt(sxx * syy);
    }

    public static double dotprod(double[] xlist, double[] ylist) {
        double result = 0.0;
        int size = Math.min(xlist.length, ylist.length);
        boolean n = false;
        for (int i = 0; i < size; ++i) {
            result += xlist[i] * ylist[i];
        }
        return result;
    }

    public static int[] permutation(int n) {
        return MatrixUtils.permutation(n, null);
    }

    public static int[] permutation(int n, Random random) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            list.add(i);
        }
        if (random != null) {
            Collections.shuffle(list, random);
        } else {
            Collections.shuffle(list);
        }
        int[] result = new int[n];
        for (int i = 0; i < n; ++i) {
            result[i] = (Integer)list.get(i);
        }
        return result;
    }

    public static void tiedRank(Vector vector) {
        int valueSize;
        boolean isSparse = false;
        if (vector instanceof DenseVector) {
            valueSize = vector.size();
        } else if (vector instanceof SparseVector) {
            valueSize = ((SparseVector)vector).getUsed();
            isSparse = true;
        } else {
            throw new RuntimeException("unexpected vector type of " + vector.getClass().getName());
        }
        double[] values = new double[valueSize];
        int k = 0;
        for (VectorEntry e : vector) {
            values[k] = e.get();
            ++k;
        }
        MatrixUtils.tiedRank(values);
        if (isSparse) {
            int[] indices = ((SparseVector)vector).getIndex();
            for (int i = 0; i < values.length; ++i) {
                vector.set(indices[i], values[i]);
            }
        } else {
            for (int i = 0; i < values.length; ++i) {
                vector.set(i, values[i]);
            }
        }
    }

    public static void tiedRank(double[] values) {
        int i;
        double[] copy = (double[])values.clone();
        boolean hasNaN = false;
        double NaNrank = 0.0;
        int startRank = 1;
        int[] indices = new int[copy.length];
        for (i = 1; i < copy.length; ++i) {
            indices[i] = i;
        }
        MatrixUtils.mergeSort(copy, indices);
        i = 0;
        while (i < copy.length) {
            ArrayList<Integer> tieValueIndices = new ArrayList<Integer>();
            double currentValue = copy[i];
            int currentIndex = indices[i];
            ++i;
            while (i < copy.length && copy[i] == currentValue) {
                tieValueIndices.add(indices[i]);
                ++i;
            }
            tieValueIndices.add(currentIndex);
            int endRank = startRank + tieValueIndices.size() - 1;
            double actualRank = (double)((startRank + endRank) * (endRank - startRank + 1)) / (double)(2 * tieValueIndices.size());
            for (Integer e : tieValueIndices) {
                if (!hasNaN && Double.isNaN(values[e])) {
                    hasNaN = true;
                    NaNrank = actualRank;
                }
                values[e.intValue()] = actualRank;
            }
            startRank += tieValueIndices.size();
        }
        for (i = 0; i < values.length; ++i) {
            if (values[i] != NaNrank) continue;
            values[i] = Double.NaN;
        }
    }

    public static void mergeSort(double[] a, int[] indices) {
        double[] tmpArray = new double[a.length];
        int[] tmpIndices = new int[a.length];
        MatrixUtils.mergeSort(a, tmpArray, indices, tmpIndices, 0, a.length - 1);
    }

    private static void mergeSort(double[] a, double[] tmpArray, int[] aIndices, int[] tmpIndices, int left, int right) {
        if (left < right) {
            int center = (left + right) / 2;
            MatrixUtils.mergeSort(a, tmpArray, aIndices, tmpIndices, left, center);
            MatrixUtils.mergeSort(a, tmpArray, aIndices, tmpIndices, center + 1, right);
            MatrixUtils.merge(a, tmpArray, aIndices, tmpIndices, left, center + 1, right);
        }
    }

    private static void merge(double[] a, double[] tmpArray, int[] aIndices, int[] tmpIndices, int leftPos, int rightPos, int rightEnd) {
        int leftEnd = rightPos - 1;
        int tmpPos = leftPos;
        int numElements = rightEnd - leftPos + 1;
        while (leftPos <= leftEnd && rightPos <= rightEnd) {
            if (a[leftPos] <= a[rightPos]) {
                tmpArray[tmpPos] = a[leftPos];
                tmpIndices[tmpPos++] = aIndices[leftPos++];
                continue;
            }
            tmpArray[tmpPos] = a[rightPos];
            tmpIndices[tmpPos++] = aIndices[rightPos++];
        }
        while (leftPos <= leftEnd) {
            tmpArray[tmpPos] = a[leftPos];
            tmpIndices[tmpPos++] = aIndices[leftPos++];
        }
        while (rightPos <= rightEnd) {
            tmpArray[tmpPos] = a[rightPos];
            tmpIndices[tmpPos++] = aIndices[rightPos++];
        }
        int i = 0;
        while (i < numElements) {
            a[rightEnd] = tmpArray[rightEnd];
            aIndices[rightEnd] = tmpIndices[rightEnd];
            ++i;
            --rightEnd;
        }
    }

    public static void mergeSort(double[] a, boolean[] classes) {
        double[] tmpArray = new double[a.length];
        boolean[] tmpClasses = new boolean[a.length];
        MatrixUtils.mergeSort(a, tmpArray, classes, tmpClasses, 0, a.length - 1);
    }

    private static void mergeSort(double[] a, double[] tmpArray, boolean[] aIndices, boolean[] tmpClasses, int left, int right) {
        if (left < right) {
            int center = (left + right) / 2;
            MatrixUtils.mergeSort(a, tmpArray, aIndices, tmpClasses, left, center);
            MatrixUtils.mergeSort(a, tmpArray, aIndices, tmpClasses, center + 1, right);
            MatrixUtils.merge(a, tmpArray, aIndices, tmpClasses, left, center + 1, right);
        }
    }

    private static void merge(double[] a, double[] tmpArray, boolean[] aClasses, boolean[] tmpClasses, int leftPos, int rightPos, int rightEnd) {
        int leftEnd = rightPos - 1;
        int tmpPos = leftPos;
        int numElements = rightEnd - leftPos + 1;
        while (leftPos <= leftEnd && rightPos <= rightEnd) {
            if (a[leftPos] <= a[rightPos]) {
                tmpArray[tmpPos] = a[leftPos];
                tmpClasses[tmpPos++] = aClasses[leftPos++];
                continue;
            }
            tmpArray[tmpPos] = a[rightPos];
            tmpClasses[tmpPos++] = aClasses[rightPos++];
        }
        while (leftPos <= leftEnd) {
            tmpArray[tmpPos] = a[leftPos];
            tmpClasses[tmpPos++] = aClasses[leftPos++];
        }
        while (rightPos <= rightEnd) {
            tmpArray[tmpPos] = a[rightPos];
            tmpClasses[tmpPos++] = aClasses[rightPos++];
        }
        int i = 0;
        while (i < numElements) {
            a[rightEnd] = tmpArray[rightEnd];
            aClasses[rightEnd] = tmpClasses[rightEnd];
            ++i;
            --rightEnd;
        }
    }

    public static void rank(Vector vector) {
        int valueSize;
        boolean isSparse = false;
        if (vector instanceof DenseVector) {
            valueSize = vector.size();
        } else if (vector instanceof SparseVector) {
            valueSize = ((SparseVector)vector).getUsed();
            isSparse = true;
        } else {
            throw new RuntimeException("unexpected vector type of " + vector.getClass().getName());
        }
        double[] values = new double[valueSize];
        int k = 0;
        for (VectorEntry e : vector) {
            values[k] = e.get();
            ++k;
        }
        MatrixUtils.rank(values);
        if (isSparse) {
            int[] indices = ((SparseVector)vector).getIndex();
            for (int i = 0; i < values.length; ++i) {
                vector.set(indices[i], values[i]);
            }
        } else {
            for (int i = 0; i < values.length; ++i) {
                vector.set(i, values[i]);
            }
        }
    }

    public static void rank(double[] values) {
        int i;
        double[] copy = (double[])values.clone();
        int startRank = 1;
        int[] indices = new int[copy.length];
        for (i = 1; i < copy.length; ++i) {
            indices[i] = i;
        }
        MatrixUtils.mergeSort(copy, indices);
        for (i = 0; i < copy.length; ++i) {
            int currentIndex = indices[i];
            if (Double.isNaN(values[currentIndex])) continue;
            values[currentIndex] = startRank;
            ++startRank;
        }
    }

    public static int[] coverage(Matrix m) throws Exception {
        int[] x = new int[m.numRows()];
        for (MatrixEntry e : m) {
            x[e.row()] = 1;
        }
        return x;
    }

    public static void mergeSortIgnoreZero(double[] a, int[] indices) {
        double[] tmpArray = new double[a.length];
        int[] tmpIndices = new int[a.length];
        MatrixUtils.mergeSortIgnoreZero(a, tmpArray, indices, tmpIndices, 0, a.length - 1);
    }

    public static boolean overlap(Matrix m, int[] c) {
        for (MatrixEntry e : m) {
            if (c[e.row()] != 1 || c[e.column()] != 1) continue;
            return true;
        }
        return false;
    }

    private static void mergeSortIgnoreZero(double[] a, double[] tmpArray, int[] aIndices, int[] tmpIndices, int left, int right) {
        if (left < right) {
            int center = (left + right) / 2;
            MatrixUtils.mergeSortIgnoreZero(a, tmpArray, aIndices, tmpIndices, left, center);
            MatrixUtils.mergeSortIgnoreZero(a, tmpArray, aIndices, tmpIndices, center + 1, right);
            MatrixUtils.mergeIgnoreZero(a, tmpArray, aIndices, tmpIndices, left, center + 1, right);
        }
    }

    private static void mergeIgnoreZero(double[] a, double[] tmpArray, int[] aIndices, int[] tmpIndices, int leftPos, int rightPos, int rightEnd) {
        int leftEnd = rightPos - 1;
        int tmpPos = leftPos;
        int numElements = rightEnd - leftPos + 1;
        while (leftPos <= leftEnd && rightPos <= rightEnd) {
            if (a[leftPos] <= a[rightPos] && a[leftPos] != 0.0 || a[leftPos] > a[rightPos] && a[rightPos] == 0.0) {
                tmpArray[tmpPos] = a[leftPos];
                tmpIndices[tmpPos++] = aIndices[leftPos++];
                continue;
            }
            tmpArray[tmpPos] = a[rightPos];
            tmpIndices[tmpPos++] = aIndices[rightPos++];
        }
        while (leftPos <= leftEnd) {
            tmpArray[tmpPos] = a[leftPos];
            tmpIndices[tmpPos++] = aIndices[leftPos++];
        }
        while (rightPos <= rightEnd) {
            tmpArray[tmpPos] = a[rightPos];
            tmpIndices[tmpPos++] = aIndices[rightPos++];
        }
        int i = 0;
        while (i < numElements) {
            a[rightEnd] = tmpArray[rightEnd];
            aIndices[rightEnd] = tmpIndices[rightEnd];
            ++i;
            --rightEnd;
        }
    }

    public static DenseMatrix copyLarger(Matrix m, int extraRows, int extraCols) {
        DenseMatrix result = new DenseMatrix(m.numRows() + extraRows, m.numColumns() + extraCols);
        for (MatrixEntry e : m) {
            result.set(e.row(), e.column(), e.get());
        }
        return result;
    }

    public static Vector rescale(Vector score) {
        Vector scaled = score.copy();
        MatrixUtils.add(scaled, 1.0);
        scaled.scale(0.5);
        return scaled;
    }

    public static void normalizeNetwork(Matrix m) {
        Vector sums = MatrixUtils.columnSums(m);
        for (VectorEntry e : sums) {
            if (e.get() > 0.0) {
                e.set(Math.sqrt(e.get()));
                continue;
            }
            e.set(1.0);
        }
        for (VectorEntry e : m) {
            e.set(e.get() / (sums.get(e.row()) * sums.get(e.column())));
        }
    }

    static class IndexedScore
    implements Comparable {
        int index;
        double score;

        IndexedScore() {
        }

        public int compareTo(Object o) {
            IndexedScore oo = (IndexedScore)o;
            return -Double.compare(this.score, oo.score);
        }
    }
}

