/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.genemania.engine.core.data.Data;
import org.genemania.exception.ApplicationException;

public class CategoryIds
extends Data {
    private static final long serialVersionUID = -6402995408418744458L;
    private long[] categoryIds;
    private long ontologyId;
    private Map<Long, Integer> reverseMap;

    public CategoryIds(long organismId, long ontologyId) {
        super("CORE", organismId);
        this.ontologyId = ontologyId;
    }

    public long getOntologyId() {
        return this.ontologyId;
    }

    public void setOntologyId(long ontologyId) {
        this.ontologyId = ontologyId;
    }

    public long[] getCategoryIds() {
        return this.categoryIds;
    }

    public void setCategoryIds(long[] nodeIds) {
        this.categoryIds = nodeIds;
    }

    @Override
    public String[] getKey() {
        return new String[]{this.getNamespace(), "" + this.getOrganismId(), "" + this.ontologyId + ".categoryIds"};
    }

    public long getIdForIndex(int index) throws ApplicationException {
        try {
            return this.categoryIds[index];
        }
        catch (IndexOutOfBoundsException e) {
            throw new ApplicationException("there is no id at index postion: " + index);
        }
    }

    public int getIndexForId(long id) throws ApplicationException {
        Integer index;
        if (this.reverseMap == null) {
            this.reverseMap = Data.makeReverseMap(this.categoryIds);
        }
        if ((index = this.reverseMap.get(id)) == null) {
            throw new ApplicationException("there is no index position for node id: " + id);
        }
        return index;
    }

    public List<Integer> getIndicesForIds(Collection<Long> ids) throws ApplicationException {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (Long id : ids) {
            indices.add(this.getIndexForId(id));
        }
        return indices;
    }
}

