/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.data;

import java.util.Map;
import org.genemania.engine.Constants;
import org.genemania.engine.core.data.Data;
import org.genemania.engine.core.integration.Feature;
import org.genemania.engine.core.integration.FeatureWeightMap;
import org.genemania.engine.matricks.SymMatrix;

public class CombinedNetwork
extends Data {
    private static final long serialVersionUID = 5207364285276085027L;
    private String methodParamKey;
    private Map<Long, Double> weightMap;
    private FeatureWeightMap featureWeightMap;
    private SymMatrix data;
    private double WtW;

    public CombinedNetwork(String namespace, long organismId, String methodParamKey) {
        super(namespace, organismId);
        this.methodParamKey = methodParamKey;
    }

    @Override
    public String[] getKey() {
        return new String[]{this.getNamespace(), "" + this.getOrganismId(), "COMBINED", this.methodParamKey};
    }

    public void fix() {
        if (this.weightMap == null && this.featureWeightMap != null) {
            return;
        }
        if (this.weightMap != null && this.featureWeightMap == null) {
            this.featureWeightMap = new FeatureWeightMap();
            for (Map.Entry<Long, Double> entry : this.weightMap.entrySet()) {
                this.featureWeightMap.put(new Feature(Constants.NetworkType.SPARSE_MATRIX, 0L, entry.getKey()), entry.getValue());
            }
            return;
        }
    }

    @Deprecated
    public Map<Long, Double> getWeightMap() {
        return this.weightMap;
    }

    @Deprecated
    public void setWeightMap(Map<Long, Double> weightMap) {
        this.weightMap = weightMap;
    }

    public FeatureWeightMap getFeatureWeightMap() {
        return this.featureWeightMap;
    }

    public void setFeatureWeightMap(FeatureWeightMap featureWeightMap) {
        this.featureWeightMap = featureWeightMap;
    }

    public SymMatrix getData() {
        return this.data;
    }

    public void setData(SymMatrix data) {
        this.data = data;
    }

    public double getWtW() {
        return this.WtW;
    }

    public void setWtW(double WtW) {
        this.WtW = WtW;
    }
}

