/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.data;

import java.util.Map;
import org.genemania.engine.core.data.Data;
import org.genemania.exception.ApplicationException;

public class NetworkIds
extends Data {
    private static final long serialVersionUID = 8740819123941019128L;
    private long[] networkIds;
    private Map<Long, Integer> reverseMap;

    public NetworkIds(String namespace, long organismId) {
        super(namespace, organismId);
    }

    @Override
    public NetworkIds copy(String newNamespace) {
        NetworkIds copy = new NetworkIds(newNamespace, this.getOrganismId());
        long[] ids = new long[this.networkIds.length];
        System.arraycopy(this.networkIds, 0, ids, 0, this.networkIds.length);
        copy.setNetworkIds(ids);
        return copy;
    }

    public long[] getNetworkIds() {
        return this.networkIds;
    }

    public void setNetworkIds(long[] networkIds) {
        this.networkIds = networkIds;
        this.reverseMap = null;
    }

    @Override
    public String[] getKey() {
        return new String[]{this.getNamespace(), "" + this.getOrganismId(), "networkIds"};
    }

    public long getIdForIndex(int index) throws ApplicationException {
        try {
            return this.networkIds[index];
        }
        catch (IndexOutOfBoundsException e) {
            throw new ApplicationException("there is no id at index postion: " + index);
        }
    }

    public int getIndexForId(long id) throws ApplicationException {
        this.checkReverseMap();
        Integer index = this.reverseMap.get(id);
        if (index == null) {
            throw new ApplicationException("there is no index position for network id: " + id);
        }
        return index;
    }

    public boolean containsId(long id) throws ApplicationException {
        this.checkReverseMap();
        return this.reverseMap.containsKey(id);
    }

    private void checkReverseMap() throws ApplicationException {
        if (this.reverseMap == null) {
            this.reverseMap = Data.makeReverseMap(this.networkIds);
        }
    }

    public int addNetwork(long id) {
        int nextIndex = this.networkIds.length;
        long[] newIds = new long[this.networkIds.length + 1];
        System.arraycopy(this.networkIds, 0, newIds, 0, this.networkIds.length);
        newIds[nextIndex] = id;
        this.networkIds = newIds;
        this.reverseMap = null;
        return nextIndex;
    }

    public void removeNetwork(long id) throws ApplicationException {
        if (!this.containsId(id)) {
            return;
        }
        long[] newIds = new long[this.networkIds.length - 1];
        int j = 0;
        for (int i = 0; i < this.networkIds.length; ++i) {
            if (this.networkIds[i] == id) continue;
            newIds[j] = this.networkIds[i];
            ++j;
        }
        this.networkIds = newIds;
        this.reverseMap = null;
    }
}

