/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.evaluation.correlation;

import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.sparse.SparseVector;
import org.genemania.engine.core.MatrixUtils;
import org.genemania.engine.core.evaluation.correlation.AbstractPearson;
import org.genemania.engine.core.evaluation.correlation.PearsonRow;

public class Spearman
extends AbstractPearson {
    @Override
    protected void createPearsonRow() {
        SparseVector d = new SparseVector(0);
        for (int i = 0; i < this.rows.length; ++i) {
            Vector v = this.geneData.getGeneExpression().get(i);
            double zeroRank = Spearman.getZeroRank(v);
            MatrixUtils.tiedRank(v);
            if (zeroRank > 0.0) {
                for (VectorEntry e : v) {
                    v.set(e.index(), e.get() + zeroRank - 1.0);
                }
            }
            this.rows[i] = new PearsonRow(v, (Vector)d, 0.0, zeroRank);
        }
    }

    @Override
    protected double getDD() {
        return 0.0;
    }

    @Override
    protected double getDTD() {
        return 0.0;
    }
}

