/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.integration;

import org.genemania.engine.Constants;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.config.Config;
import org.genemania.engine.core.data.AttributeData;
import org.genemania.engine.core.data.AttributeGroups;
import org.genemania.engine.core.integration.Feature;
import org.genemania.engine.core.utils.Normalization;
import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.Matrix;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.engine.matricks.Vector;
import org.genemania.engine.matricks.custom.Outer1View;
import org.genemania.engine.matricks.custom.Outer2View;
import org.genemania.exception.ApplicationException;

public class FeatureLoader {
    private DataCache cache;
    private String namespace;
    private long organismId;
    boolean oldMode = false;
    boolean scaled = true;
    Vector sumsCache;
    long sumsCacheGroupId;

    public FeatureLoader(DataCache cache, String namespace, long organismId) {
        this(cache, namespace, organismId, false, false);
    }

    public FeatureLoader(DataCache cache, String namespace, long organismId, boolean oldMode, boolean scaled) {
        this.cache = cache;
        this.namespace = namespace;
        this.organismId = organismId;
        this.oldMode = oldMode;
        this.scaled = scaled;
    }

    public SymMatrix load(Feature feature) throws ApplicationException {
        return this.load(feature, null);
    }

    public SymMatrix load(Feature feature, int[] ixPos) throws ApplicationException {
        if (feature.getType() == Constants.NetworkType.SPARSE_MATRIX) {
            SymMatrix network = this.cache.getNetwork(this.namespace, this.organismId, feature.getId()).getData();
            if (ixPos != null) {
                return network.subMatrix(ixPos);
            }
            return network;
        }
        if (feature.getType() == Constants.NetworkType.ATTRIBUTE_VECTOR) {
            AttributeData attributeSet = this.cache.getAttributeData(this.namespace, this.organismId, feature.getGroupId());
            AttributeGroups attributeGroups = this.cache.getAttributeGroups(this.namespace, this.organismId);
            int index = attributeGroups.getIndexForAttributeId(feature.getGroupId(), feature.getId());
            Vector sums = this.getColumnSums(attributeSet);
            double scale = 1.0 / (sums.get(index) - 1.0);
            if (this.oldMode) {
                Matrix data = attributeSet.getData();
                SymMatrix tmp = this.attributeToSparse(data, index);
                return tmp.subMatrix(ixPos);
            }
            Matrix data = attributeSet.getData();
            if (ixPos != null) {
                return Outer1View.fromColumn(data, index, ixPos, scale, true);
            }
            return Outer1View.fromColumn(data, index, scale, true);
        }
        throw new ApplicationException("unexpected feature type: " + (Object)((Object)feature.getType()));
    }

    Vector getColumnSums(AttributeData attributeSet) {
        if (this.sumsCacheGroupId == attributeSet.getAttributeGroupId() && this.sumsCache != null) {
            return this.sumsCache;
        }
        this.sumsCache = attributeSet.getData().columnSums();
        this.sumsCacheGroupId = attributeSet.getAttributeGroupId();
        return this.sumsCache;
    }

    public Matrix load(Feature feature, int[] ixPos, int[] ixNeg) throws ApplicationException {
        if (feature.getType() == Constants.NetworkType.SPARSE_MATRIX) {
            SymMatrix network = this.cache.getNetwork(this.namespace, this.organismId, feature.getId()).getData();
            return network.subMatrix(ixPos, ixNeg);
        }
        if (feature.getType() == Constants.NetworkType.ATTRIBUTE_VECTOR) {
            AttributeData attributeSet = this.cache.getAttributeData(this.namespace, this.organismId, feature.getGroupId());
            AttributeGroups attributeGroups = this.cache.getAttributeGroups(this.namespace, this.organismId);
            int index = attributeGroups.getIndexForAttributeId(feature.getGroupId(), feature.getId());
            Vector sums = attributeSet.getData().columnSums();
            double scale = this.scaled ? 1.0 / (sums.get(index) - 1.0) : 1.0;
            if (this.oldMode) {
                Matrix data = attributeSet.getData();
                SymMatrix tmp = this.attributeToSparse(data, index);
                return tmp.subMatrix(ixPos, ixNeg);
            }
            Matrix data = attributeSet.getData();
            boolean zeroDiag = false;
            return Outer2View.fromColumn(data, index, ixPos, ixNeg, scale, zeroDiag);
        }
        throw new MatricksException("unkown feature type: " + (Object)((Object)feature.getType()));
    }

    private SymMatrix attributeToSparse(Matrix data, int column) throws ApplicationException {
        SymMatrix sparse = Config.instance().getMatrixFactory().symSparseMatrix(data.numRows());
        for (int i1 = 0; i1 < data.numRows(); ++i1) {
            double d1 = data.get(i1, column);
            if (d1 == 0.0) continue;
            for (int i2 = 0; i2 < data.numRows(); ++i2) {
                double d2 = data.get(i2, column);
                if (d2 == 0.0 || i1 == i2) continue;
                sparse.set(i1, i2, d1 * d2);
            }
        }
        Normalization.normalizeNetwork(sparse);
        return sparse;
    }
}

