/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.integration;

import java.util.Collection;
import no.uib.cipr.matrix.Vector;
import org.genemania.engine.Constants;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.core.integration.INetworkWeightCalculator;
import org.genemania.engine.core.integration.calculators.AutomaticCalculator;
import org.genemania.engine.core.integration.calculators.AverageByCategoryCalculator;
import org.genemania.engine.core.integration.calculators.AverageByNetworkCalculator;
import org.genemania.engine.core.integration.calculators.BranchSpecificCalculator;
import org.genemania.exception.ApplicationException;
import org.genemania.util.ProgressReporter;

public class NetworkWeightCalculatorFactory {
    public static INetworkWeightCalculator getCalculator(String namespace, DataCache cache, Collection<Collection<Long>> networkIds, Collection<Long> attributeGroupIds, long organismId, Vector label, int attributesLimit, Constants.CombiningMethod method, ProgressReporter progress) throws ApplicationException {
        if (method == Constants.CombiningMethod.AUTOMATIC) {
            return new AutomaticCalculator(namespace, cache, networkIds, attributeGroupIds, organismId, label, attributesLimit, progress);
        }
        if (method == Constants.CombiningMethod.AVERAGE) {
            return new AverageByNetworkCalculator(namespace, cache, networkIds, attributeGroupIds, organismId, label, attributesLimit, progress);
        }
        if (method == Constants.CombiningMethod.AVERAGE_CATEGORY) {
            return new AverageByCategoryCalculator(namespace, cache, networkIds, attributeGroupIds, organismId, label, attributesLimit, progress);
        }
        if (method == Constants.CombiningMethod.AUTOMATIC_RELEVANCE) {
            throw new ApplicationException("combining method not supported: " + (Object)((Object)method));
        }
        if (method == Constants.CombiningMethod.BP || method == Constants.CombiningMethod.CC || method == Constants.CombiningMethod.MF) {
            return new BranchSpecificCalculator(namespace, cache, networkIds, attributeGroupIds, organismId, label, attributesLimit, method, progress);
        }
        if (method == Constants.CombiningMethod.AUTOMATIC_FAST) {
            throw new ApplicationException("combining method not supported: " + (Object)((Object)method));
        }
        throw new ApplicationException("don't know how to calculate combining method: " + (Object)((Object)method));
    }
}

