/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.integration;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Scanner;
import org.genemania.domain.Organism;
import org.genemania.engine.Constants;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.config.Config;
import org.genemania.engine.converter.SymbolCache;
import org.genemania.engine.core.data.DatasetInfo;
import org.genemania.engine.core.data.GoAnnotations;
import org.genemania.engine.core.data.GoIds;
import org.genemania.engine.matricks.Matrix;
import org.genemania.exception.ApplicationException;
import org.genemania.mediator.GeneMediator;

public class TargetMatricesGenerator {
    Organism organism;
    GeneMediator geneMediator;
    DataCache cache;
    SymbolCache symbolCache;
    GoIds goIds;
    GoAnnotations goAnnos;
    private static int TERM_COL = 0;
    private static int GENE_COL = 1;

    public TargetMatricesGenerator(Organism organism, GeneMediator geneMediator, DataCache cache) throws ApplicationException {
        this.cache = cache;
        this.organism = organism;
        this.symbolCache = new SymbolCache(organism, geneMediator, cache);
    }

    public void load(String annoFile, String goBranch) throws IOException, ApplicationException {
        this.loadTerms(annoFile, goBranch);
        this.loadAnnos(annoFile, goBranch);
        this.save(goBranch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTerms(String annoFile, String goBranch) throws IOException {
        Scanner scanner = new Scanner(new File(annoFile));
        HashSet<String> terms = new HashSet<String>();
        try {
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.startsWith("#")) continue;
                String[] tokens = line.split("\t");
                String term = tokens[TERM_COL];
                terms.add(term);
            }
        }
        finally {
            scanner.close();
        }
        this.goIds = new GoIds(this.organism.getId(), goBranch);
        String[] ids = terms.toArray(new String[0]);
        this.goIds.setGoIds(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAnnos(String annoFile, String goBranch) throws ApplicationException, IOException {
        Scanner scanner = new Scanner(new File(annoFile));
        int numCats = this.goIds.getGoIds().length;
        int numNodes = this.cache.getNodeIds(this.organism.getId()).getNodeIds().length;
        Matrix annoData = Config.instance().getMatrixFactory().sparseMatrix(numNodes, numCats);
        try {
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.startsWith("#")) continue;
                String[] tokens = line.split("\t");
                String term = tokens[TERM_COL];
                String gene = tokens[GENE_COL];
                Integer geneIndex = this.symbolCache.getIndexForSymbol(gene);
                if (geneIndex == null) continue;
                int termIndex = this.goIds.getIndexForId(term);
                annoData.set(geneIndex, termIndex, 1.0);
            }
        }
        finally {
            scanner.close();
        }
        this.goAnnos = new GoAnnotations(this.organism.getId(), goBranch);
        this.goAnnos.setData(annoData);
    }

    private void save(String goBranch) throws ApplicationException {
        this.cache.putGoIds(this.goIds);
        this.cache.putGoAnnotations(this.goAnnos);
        DatasetInfo info = this.cache.getDatasetInfo(this.organism.getId());
        int numCategories = this.goIds.getGoIds().length;
        int goBranchNum = Constants.getIndexForGoBranch(goBranch);
        info.getNumCategories()[goBranchNum] = numCategories;
        this.cache.putDatasetInfo(info);
    }

    public GoIds getGoIds() {
        return this.goIds;
    }

    public GoAnnotations getGoAnnos() {
        return this.goAnnos;
    }
}

