/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.integration.calculators;

import java.util.Collection;
import no.uib.cipr.matrix.Vector;
import org.apache.log4j.Logger;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.core.integration.CombineNetworksOnly;
import org.genemania.engine.core.integration.FeatureList;
import org.genemania.engine.core.integration.attribute.QueryEnrichedAttributeScorer;
import org.genemania.engine.core.integration.calculators.AbstractNetworkWeightCalculator;
import org.genemania.engine.core.integration.calculators.AverageByNetworkCalculator;
import org.genemania.engine.core.integration.gram.AutomaticGramBuilder;
import org.genemania.engine.exception.WeightingFailedException;
import org.genemania.exception.ApplicationException;
import org.genemania.util.ProgressReporter;

public class AutomaticCalculator
extends AbstractNetworkWeightCalculator {
    private static Logger logger = Logger.getLogger(AutomaticCalculator.class);
    private static int MIN_QUERY_GENES_PER_ATTRIBUTE = 2;

    public AutomaticCalculator(String namespace, DataCache cache, Collection<Collection<Long>> networkIds, Collection<Long> attributeGroupIds, long organismId, Vector label, int attributesLimit, ProgressReporter progress) throws ApplicationException {
        super(namespace, cache, networkIds, attributeGroupIds, organismId, label, attributesLimit, progress);
    }

    @Override
    public void process() throws ApplicationException {
        this.progress.setStatus("computing network weights");
        this.progress.setProgress(1);
        QueryEnrichedAttributeScorer attributeScorer = new QueryEnrichedAttributeScorer(this.cache, this.label, MIN_QUERY_GENES_PER_ATTRIBUTE);
        FeatureList featureList = this.buildFeatureList(attributeScorer, false);
        try {
            AutomaticGramBuilder builder = new AutomaticGramBuilder(this.cache, this.namespace, this.organismId, featureList, this.label, this.progress);
            this.weights = builder.build(this.progress);
        }
        catch (WeightingFailedException e) {
            logger.error((Object)("weighting calculation failed, falling back to average: " + e.getMessage()));
            this.weights = AverageByNetworkCalculator.average(featureList);
        }
        this.progress.setStatus("building combined network");
        this.progress.setProgress(2);
        this.combinedMatrix = CombineNetworksOnly.combine(this.weights, this.namespace, this.organismId, this.cache, this.progress);
    }
}

