/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.mania;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import no.uib.cipr.matrix.Vector;
import org.apache.log4j.Logger;
import org.genemania.engine.Constants;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.core.data.CombinedNetwork;
import org.genemania.engine.core.integration.FeatureWeightMap;
import org.genemania.engine.core.integration.INetworkWeightCalculator;
import org.genemania.engine.core.integration.NetworkWeightCalculatorFactory;
import org.genemania.engine.core.integration.calculators.AbstractNetworkWeightCalculator;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.exception.ApplicationException;
import org.genemania.util.ProgressReporter;

public class CalculateNetworkWeights {
    private static Logger logger = Logger.getLogger(CalculateNetworkWeights.class);
    private FeatureWeightMap weights = new FeatureWeightMap();
    private Map<Integer, Long> IndexToNetworkIdMap = new HashMap<Integer, Long>();
    private SymMatrix combinedMatrix = null;
    private String namespace;
    private DataCache cache;
    private Collection<Collection<Long>> networkIds;
    private Collection<Long> attributeGroupIds;
    private long organismId;
    private Vector label;
    private int attributesLimit;
    private Constants.CombiningMethod method;
    private ProgressReporter progress;

    public CalculateNetworkWeights(String namespace, DataCache cache, Collection<Collection<Long>> networkIds, Collection<Long> attributeGroupIds, long organismId, Vector label, int attributesLimit, Constants.CombiningMethod method, ProgressReporter progress) throws ApplicationException {
        this.namespace = namespace;
        this.cache = cache;
        this.networkIds = networkIds;
        this.attributeGroupIds = attributeGroupIds;
        this.organismId = organismId;
        this.label = label;
        this.method = method;
        this.attributesLimit = attributesLimit;
        this.progress = progress;
    }

    public void process() throws ApplicationException {
        INetworkWeightCalculator calculator = NetworkWeightCalculatorFactory.getCalculator(this.namespace, this.cache, this.networkIds, this.attributeGroupIds, this.organismId, this.label, this.attributesLimit, this.method, this.progress);
        try {
            this.getFromCache(this.organismId, calculator);
            return;
        }
        catch (ApplicationException e) {
            this.recompute(calculator);
            return;
        }
    }

    private void getFromCache(long organismId, INetworkWeightCalculator calculator) throws ApplicationException {
        String key = calculator.getParameterKey();
        String hash = AbstractNetworkWeightCalculator.hashString(key);
        CombinedNetwork combined = this.cache.getCombinedNetwork(this.namespace, organismId, hash);
        logger.debug((Object)String.format("found pre-combined network in cache for namespace %s organism %s with hash %s for key %s", this.namespace, organismId, hash, key));
        this.weights = combined.getFeatureWeightMap();
        this.combinedMatrix = combined.getData();
    }

    private void recompute(INetworkWeightCalculator calculator) throws ApplicationException {
        calculator.process();
        this.weights = calculator.getWeights();
        this.combinedMatrix = calculator.getCombinedMatrix();
    }

    public FeatureWeightMap getWeights() {
        return this.weights;
    }

    public SymMatrix getCombinedMatrix() {
        return this.combinedMatrix;
    }

    public Map<Integer, Long> getIndexToNetworkIdMap() {
        return this.IndexToNetworkIdMap;
    }
}

