/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.labels;

import java.util.Collection;
import no.uib.cipr.matrix.DenseVector;
import org.genemania.engine.core.data.NodeIds;
import org.genemania.exception.ApplicationException;

public class LabelVectorGenerator {
    public static DenseVector createLabelsFromIds(NodeIds nodeIds, Collection<Long> positiveNodeIds, Collection<Long> negativeNodeIds, double posLabelValue, double negLabelValue, double nonLabelValue) throws ApplicationException {
        int index;
        int totalNodesForOrganism = nodeIds.getNodeIds().length;
        DenseVector labels = new DenseVector(totalNodesForOrganism);
        for (int i = 0; i < totalNodesForOrganism; ++i) {
            labels.set(i, nonLabelValue);
        }
        for (Long nodeId : positiveNodeIds) {
            index = nodeIds.getIndexForId(nodeId);
            labels.set(index, posLabelValue);
        }
        for (Long nodeId : negativeNodeIds) {
            index = nodeIds.getIndexForId(nodeId);
            labels.set(index, negLabelValue);
        }
        return labels;
    }
}

