/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.custom;

import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.Vector;
import org.genemania.engine.matricks.VectorCursor;

public abstract class AbstractVector
implements Vector {
    @Override
    public void scale(double a) throws MatricksException {
        VectorCursor cursor = this.cursor();
        while (cursor.next()) {
            this.set(cursor.index(), cursor.val() * a);
        }
    }

    @Override
    public void setAll(double a) throws MatricksException {
        VectorCursor cursor = this.cursor();
        while (cursor.next()) {
            this.set(cursor.index(), a);
        }
    }

    @Override
    public void add(Vector B) throws MatricksException {
        if (B.getSize() != this.getSize()) {
            throw new MatricksException("incompatible size for addition");
        }
        VectorCursor cursor = B.cursor();
        while (cursor.next()) {
            int index = cursor.index();
            double v = cursor.val() + this.get(index);
            this.set(index, v);
        }
    }

    @Override
    public void add(double a, Vector B) throws MatricksException {
        if (B.getSize() != this.getSize()) {
            throw new MatricksException("incompatible size for addition");
        }
        VectorCursor cursor = B.cursor();
        while (cursor.next()) {
            int index = cursor.index();
            double v = a * cursor.val() + this.get(index);
            this.set(index, v);
        }
    }

    @Override
    public double elementSum() {
        double sum = 0.0;
        VectorCursor cursor = this.cursor();
        while (cursor.next()) {
            sum += cursor.val();
        }
        return sum;
    }

    @Override
    public int[] findIndexesOf(double val) {
        throw new RuntimeException("not implemented");
    }
}

