/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.custom;

import java.util.Arrays;
import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.Matrix;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.custom.AbstractMatrix;
import org.genemania.engine.matricks.custom.FlexFloatArray;

public class FlexFloatMatrix
extends AbstractMatrix {
    private static final long serialVersionUID = 8262113357006375706L;
    int rows;
    int cols;
    FlexFloatArray[] data;

    public FlexFloatMatrix(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.alloc();
    }

    private void alloc() {
        this.data = new FlexFloatArray[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            this.data[i] = new FlexFloatArray(this.cols);
        }
    }

    @Override
    public int numRows() {
        return this.rows;
    }

    @Override
    public int numCols() {
        return this.cols;
    }

    @Override
    public double get(int row, int col) {
        this.checkIdx(row, col);
        return this.data[row].get(col);
    }

    @Override
    public void set(int row, int col, double val) throws MatricksException {
        this.checkIdx(row, col);
        this.data[row].set(col, (float)val);
    }

    private void checkIdx(int row, int col) {
        if (row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException(String.format("invalid row index: %d", row));
        }
        if (col < 0 || col >= this.cols) {
            throw new IndexOutOfBoundsException(String.format("invalid column index: %d", col));
        }
    }

    @Override
    public MatrixCursor cursor() {
        return new FlexDoubleMatrixCursor();
    }

    @Override
    public double elementMultiplySum(Matrix m) {
        if (m instanceof FlexFloatMatrix) {
            return this.elementMultiplySum((FlexFloatMatrix)m);
        }
        throw new RuntimeException("not implemented for: " + m.getClass().getName());
    }

    public double elementMultiplySum(FlexFloatMatrix m) {
        if (m.numRows() != this.rows && m.numCols() != this.cols) {
            throw new MatricksException("inconsistent dimensions");
        }
        double sum = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            sum += this.data[i].dot(m.data[i]);
        }
        return sum;
    }

    @Override
    public void rowSums(double[] result) {
        for (int row = 0; row < this.rows; ++row) {
            result[row] = result[row] + this.data[row].elementSum();
        }
    }

    @Override
    public void columnSums(double[] result) {
        for (int row = 0; row < this.rows; ++row) {
            this.data[row].addTo(result);
        }
    }

    @Override
    public void mult(double[] x, double[] y) {
        for (int row = 0; row < this.rows; ++row) {
            y[row] = this.data[row].dot(x);
        }
    }

    @Override
    public void multAdd(double[] x, double[] y) {
        for (int row = 0; row < this.rows; ++row) {
            y[row] = y[row] + this.data[row].dot(x);
        }
    }

    @Override
    public Matrix subMatrix(int[] rows, int[] cols) {
        FlexFloatMatrix subMatrix = new FlexFloatMatrix(rows.length, cols.length);
        for (int i = 0; i < rows.length; ++i) {
            int idx = rows[i];
            for (int j = 0; j < cols.length; ++j) {
                int jdx = cols[j];
                double v = this.get(idx, jdx);
                if (v == 0.0) continue;
                subMatrix.set(i, j, v);
            }
        }
        return subMatrix;
    }

    @Override
    public void transMult(double[] x, double[] y) {
        Arrays.fill(y, 0.0);
        for (int row = 0; row < this.rows; ++row) {
            this.data[row].add(x[row], y);
        }
    }

    private class FlexDoubleMatrixCursor
    implements MatrixCursor {
        public int row = -1;
        public MatrixCursor rowCursor;

        private FlexDoubleMatrixCursor() {
        }

        @Override
        public boolean next() {
            boolean next = this.rowCursor == null ? this.getNextCursor() : this.rowCursor.next();
            if (next) {
                return true;
            }
            return this.getNextCursor();
        }

        private boolean getNextCursor() {
            while (++this.row < FlexFloatMatrix.this.data.length) {
                this.rowCursor = FlexFloatMatrix.this.data[this.row].cursor();
                boolean next = this.rowCursor.next();
                if (!next) continue;
                return true;
            }
            return false;
        }

        @Override
        public int row() {
            return this.row;
        }

        @Override
        public int col() {
            return this.rowCursor.row();
        }

        @Override
        public double val() {
            return this.rowCursor.val();
        }

        @Override
        public void set(double val) {
            this.rowCursor.set(val);
        }
    }
}

