/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.custom;

import java.util.Arrays;
import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.Matrix;
import org.genemania.engine.matricks.MatrixAccumulator;
import org.genemania.engine.matricks.custom.FlexFloatArray;
import org.genemania.engine.matricks.custom.FlexSymFloatMatrix;

public class FloatSymMatrixAccumulator
implements MatrixAccumulator {
    private static final long serialVersionUID = -3631959211056416493L;
    final int numRows;
    final int numCols;
    final int bufSizeBytes;
    final float[] buffer;
    final FlexSymFloatMatrix sum;
    int blockStart = -1;
    int blockLength = 0;

    public FloatSymMatrixAccumulator(FlexSymFloatMatrix sum, int bufSizeBytes) {
        this.numRows = sum.numRows();
        this.numCols = sum.numCols();
        this.bufSizeBytes = bufSizeBytes;
        this.sum = sum;
        this.buffer = new float[bufSizeBytes / 4];
    }

    @Override
    public void add(double weight, Matrix m) {
        if (!(m instanceof FlexSymFloatMatrix)) {
            throw new MatricksException("not implemented for given matrix type");
        }
        this.add(weight, (FlexSymFloatMatrix)m);
    }

    public void add(double weight, FlexSymFloatMatrix m) {
        int offset = 0;
        for (int row = this.blockStart; row <= this.blockStart + this.blockLength; ++row) {
            FlexFloatArray a = m.data[row];
            a.add(weight, this.buffer, offset);
            offset += a.size;
        }
    }

    @Override
    public void add(Matrix m) {
        if (!(m instanceof FlexSymFloatMatrix)) {
            throw new MatricksException("not implemented for given matrix type");
        }
        this.add((FlexSymFloatMatrix)m);
    }

    public void add(FlexSymFloatMatrix m) {
        int offset = 0;
        for (int row = this.blockStart; row <= this.blockStart + this.blockLength; ++row) {
            FlexFloatArray a = m.data[row];
            a.add(this.buffer, offset);
            offset += a.size;
        }
    }

    @Override
    public boolean nextBlock() {
        if (this.blockStart != -1) {
            this.compact();
        }
        this.updateBlockIndices();
        if (this.blockStart < this.numRows) {
            Arrays.fill(this.buffer, 0.0f);
            this.add(this.sum);
            return true;
        }
        return false;
    }

    void updateBlockIndices() {
        int all;
        long todo;
        long overflow;
        this.blockStart = this.blockStart + this.blockLength + 1;
        if (this.blockStart >= this.numRows) {
            return;
        }
        long done = 0L;
        if (this.blockStart > 0) {
            int n = this.sum.data[this.blockStart - 1].size;
            done = n * (n + 1) / 2;
        }
        if ((overflow = (todo = (long)(all = this.numRows * (this.numRows + 1) / 2) - done) - (long)this.buffer.length) <= 0L) {
            this.blockLength = this.numRows - this.blockStart - 1;
        } else {
            long p = (long)this.buffer.length + done;
            int lastRow = (int)Math.floor((-1.0 + Math.sqrt(1L + 8L * p)) / 2.0);
            this.blockLength = lastRow - this.blockStart;
        }
    }

    void compact() {
        int offset = 0;
        for (int row = this.blockStart; row <= this.blockStart + this.blockLength; ++row) {
            FlexFloatArray newRow = this.sum.data[row];
            newRow = new FlexFloatArray(newRow.size);
            int end = offset + newRow.size;
            for (int i = offset; i < end; ++i) {
                if (this.buffer[i] == 0.0f) continue;
                newRow.set(i - offset, this.buffer[i]);
            }
            offset += newRow.size;
            this.sum.data[row] = newRow;
        }
    }
}

