/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.custom;

import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.Matrix;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.engine.matricks.Vector;
import org.genemania.engine.matricks.custom.AbstractMatrix;
import org.genemania.engine.matricks.custom.DenseDoubleVector;
import org.genemania.engine.matricks.custom.OuterProductComboSymMatrix;

public class MultiOPCSymMatrix
extends AbstractMatrix
implements SymMatrix {
    private static final long serialVersionUID = 4356797702972735183L;
    private int size;
    private SymMatrix matrix;
    private OuterProductComboSymMatrix[] combos;

    public MultiOPCSymMatrix(SymMatrix matrix, OuterProductComboSymMatrix ... combos) {
        this.matrix = matrix;
        this.combos = combos;
        this.size = matrix.numRows();
        this.checkSizes();
    }

    private void checkSizes() {
        for (OuterProductComboSymMatrix combo : this.combos) {
            if (combo.numRows() == this.size) continue;
            throw new MatricksException("inconsistent matrix sizes");
        }
    }

    @Override
    public int numRows() {
        return this.size;
    }

    @Override
    public int numCols() {
        return this.size;
    }

    @Override
    public double get(int row, int col) {
        double val = this.matrix.get(row, col);
        for (OuterProductComboSymMatrix combo : this.combos) {
            val += combo.get(row, col);
        }
        return val;
    }

    @Override
    public void set(int row, int col, double val) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void scale(double a) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void setAll(double a) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public MatrixCursor cursor() {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void add(Matrix B) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void add(double a, Matrix B) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public double elementSum() {
        throw new MatricksException("Not implemented");
    }

    @Override
    public double elementMultiplySum(Matrix m) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void CG(Vector x, Vector y) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void QR(Vector x, Vector y) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public Vector rowSums() throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public Vector columnSums() throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void rowSums(double[] result) throws MatricksException {
        this.matrix.rowSums(result);
        double[] ones = new double[result.length];
        for (int i = 0; i < ones.length; ++i) {
            ones[i] = 1.0;
        }
        for (OuterProductComboSymMatrix combo : this.combos) {
            combo.multAdd(ones, result);
        }
    }

    @Override
    public void columnSums(double[] result) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void setToMaxTranspose() throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void multAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseDoubleVector) || !(y instanceof DenseDoubleVector)) {
            throw new MatricksException("Not implemented");
        }
        DenseDoubleVector xx = (DenseDoubleVector)x;
        DenseDoubleVector yy = (DenseDoubleVector)y;
        this.multAdd(xx.data, yy.data);
    }

    @Override
    public void mult(Vector x, Vector y) {
        if (!(x instanceof DenseDoubleVector) || !(y instanceof DenseDoubleVector)) {
            throw new MatricksException("Not implemented");
        }
        DenseDoubleVector xx = (DenseDoubleVector)x;
        DenseDoubleVector yy = (DenseDoubleVector)y;
        this.mult(xx.data, yy.data);
    }

    @Override
    public Matrix subMatrix(int[] rows, int[] cols) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void add(int i, int j, double alpha) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void transMult(double[] x, double[] y) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void compact() {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void multAdd(double alpha, double[] x, double[] y) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void mult(double[] x, double[] y) {
        this.matrix.mult(x, y);
        for (OuterProductComboSymMatrix combo : this.combos) {
            combo.multAdd(x, y);
        }
    }

    @Override
    public void multAdd(double[] x, double[] y) {
        this.matrix.multAdd(x, y);
        for (OuterProductComboSymMatrix combo : this.combos) {
            combo.multAdd(x, y);
        }
    }

    @Override
    public SymMatrix subMatrix(int[] rowcols) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void setDiag(double alpha) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void dotDivOuterProd(Vector x) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void addOuterProd(double[] x) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public double sumDotMultOuterProd(double[] x) {
        throw new MatricksException("Not implemented");
    }

    public SymMatrix getMatrix() {
        return this.matrix;
    }

    public OuterProductComboSymMatrix[] getCombos() {
        return this.combos;
    }
}

