/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.custom;

import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.Matrix;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.engine.matricks.Vector;
import org.genemania.engine.matricks.custom.AbstractMatrix;
import org.genemania.engine.matricks.custom.DenseDoubleVector;
import org.genemania.engine.matricks.custom.DoubleDiagonalMatrix;

public class OuterProductComboSymMatrix
extends AbstractMatrix
implements SymMatrix {
    private static final long serialVersionUID = -3004938530505371965L;
    int size;
    Matrix vectorData;
    Vector weights;
    boolean zeroDiag;
    DenseDoubleVector diag;

    public OuterProductComboSymMatrix(Matrix vectorData, Vector weights, boolean zeroDiag) {
        if (vectorData.numCols() != weights.getSize()) {
            throw new MatricksException("inconsistent size, matrix cols must equal vector len");
        }
        this.vectorData = vectorData;
        this.weights = weights;
        this.zeroDiag = zeroDiag;
        this.size = vectorData.numRows();
    }

    @Override
    public int numRows() {
        return this.size;
    }

    @Override
    public int numCols() {
        return this.size;
    }

    @Override
    public int nnz() {
        return this.size * this.size;
    }

    @Override
    public double get(int row, int col) {
        double val = 0.0;
        if (this.zeroDiag && row == col) {
            return 0.0;
        }
        for (int j = 0; j < this.vectorData.numCols(); ++j) {
            val += this.weights.get(j) * this.vectorData.get(row, j) * this.vectorData.get(col, j);
        }
        return val;
    }

    public DenseDoubleVector getDiagAsVector() {
        if (this.diag != null) {
            return this.diag;
        }
        this.diag = new DenseDoubleVector(this.size);
        MatrixCursor cursor = this.vectorData.cursor();
        while (cursor.next()) {
            double weight = this.weights.get(cursor.col());
            if (weight == 0.0) continue;
            int row = cursor.row();
            double val = cursor.val();
            double diag_val = this.diag.get(row);
            this.diag.set(row, diag_val += val * val * weight);
        }
        return this.diag;
    }

    @Override
    public void compact() {
        this.diag = null;
    }

    @Override
    public void set(int row, int col, double val) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void scale(double a) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void setAll(double a) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public MatrixCursor cursor() {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void add(Matrix B) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void add(double a, Matrix B) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public double elementSum() {
        throw new MatricksException("Not implemented");
    }

    @Override
    public double elementMultiplySum(Matrix m) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void CG(Vector x, Vector y) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void QR(Vector x, Vector y) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public Vector rowSums() throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public Vector columnSums() throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void rowSums(double[] result) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void columnSums(double[] result) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void setToMaxTranspose() throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void multAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseDoubleVector) || !(y instanceof DenseDoubleVector)) {
            throw new MatricksException("Not implemented");
        }
        DenseDoubleVector xx = (DenseDoubleVector)x;
        DenseDoubleVector yy = (DenseDoubleVector)y;
        this.multAdd(xx.data, yy.data);
    }

    @Override
    public void mult(Vector x, Vector y) {
        if (!(x instanceof DenseDoubleVector) || !(y instanceof DenseDoubleVector)) {
            throw new MatricksException("Not implemented");
        }
        DenseDoubleVector xx = (DenseDoubleVector)x;
        DenseDoubleVector yy = (DenseDoubleVector)y;
        this.mult(xx.data, yy.data);
    }

    @Override
    public Matrix subMatrix(int[] rows, int[] cols) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void add(int i, int j, double alpha) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void transMult(double[] x, double[] y) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void multAdd(double alpha, double[] x, double[] y) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void mult(double[] x, double[] y) {
        double[] temp = this.multHelper(x);
        this.vectorData.mult(temp, y);
        if (this.zeroDiag) {
            this.compensateForDiag(x, y);
        }
    }

    @Override
    public void multAdd(double[] x, double[] y) {
        double[] temp = this.multHelper(x);
        this.vectorData.multAdd(temp, y);
        if (this.zeroDiag) {
            this.compensateForDiag(x, y);
        }
    }

    private double[] multHelper(double[] x) {
        double[] temp1 = new double[this.vectorData.numCols()];
        double[] temp2 = new double[this.vectorData.numCols()];
        this.vectorData.transMult(x, temp1);
        DoubleDiagonalMatrix diag = new DoubleDiagonalMatrix(this.weights);
        diag.multAdd(temp1, temp2);
        return temp2;
    }

    private void compensateForDiag(double[] x, double[] y) {
        DenseDoubleVector diagonal = this.getDiagAsVector();
        for (int i = 0; i < y.length; ++i) {
            y[i] = y[i] - x[i] * diagonal.data[i];
        }
    }

    @Override
    public SymMatrix subMatrix(int[] rowcols) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void setDiag(double alpha) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void dotDivOuterProd(Vector x) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void addOuterProd(double[] x) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public double sumDotMultOuterProd(double[] x) {
        throw new MatricksException("Not implemented");
    }
}

