/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.custom;

import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.Matrix;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.OuterProductSymMatrix;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.engine.matricks.Vector;
import org.genemania.engine.matricks.custom.AbstractMatrix;

public class OuterProductSymFloatMatrix
extends AbstractMatrix
implements OuterProductSymMatrix {
    private static final long serialVersionUID = 327153796421326669L;
    int size;
    float[] data;

    public OuterProductSymFloatMatrix(float[] data) {
        this.data = data;
        this.size = data.length;
    }

    public OuterProductSymFloatMatrix(int size) {
        this.size = size;
        this.alloc();
    }

    private void alloc() {
        this.data = new float[this.size];
    }

    @Override
    public int numRows() {
        return this.size;
    }

    @Override
    public int numCols() {
        return this.size;
    }

    @Override
    public double get(int row, int col) {
        return this.data[row] * this.data[col];
    }

    @Override
    public void set(int pos, double val) {
        this.data[pos] = (float)val;
    }

    @Override
    public void set(int row, int col, double val) throws MatricksException {
        throw new MatricksException("can't set matrix element for Outer-Product matrix");
    }

    @Override
    public void scale(double a) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void setAll(double a) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public MatrixCursor cursor() {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void add(Matrix B) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void add(double a, Matrix B) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public double elementSum() {
        throw new MatricksException("Not implemented");
    }

    @Override
    public double elementMultiplySum(Matrix m) throws MatricksException {
        if (m instanceof OuterProductSymFloatMatrix) {
            return this.elementMultiplySum((OuterProductSymFloatMatrix)m);
        }
        throw new MatricksException("Not implemented");
    }

    public double elementMultiplySum(OuterProductSymFloatMatrix m) throws MatricksException {
        int i;
        if (this.size != m.size) {
            throw new MatricksException("size mismatch");
        }
        double sum = 0.0;
        for (i = 0; i < this.size; ++i) {
            for (int j = 0; j < j; ++j) {
                sum += (double)(this.data[i] * this.data[j] * m.data[i] * m.data[j]);
            }
        }
        sum = 2.0 * sum;
        for (i = 0; i < this.size; ++i) {
            sum += (double)(this.data[i] * this.data[i] * m.data[i] * m.data[i]);
        }
        return sum;
    }

    @Override
    public void CG(Vector x, Vector y) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void QR(Vector x, Vector y) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public Vector rowSums() throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public Vector columnSums() throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void rowSums(double[] result) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void columnSums(double[] result) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void setToMaxTranspose() throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void multAdd(double alpha, Vector x, Vector y) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void mult(Vector x, Vector y) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public Matrix subMatrix(int[] rows, int[] cols) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void add(int i, int j, double alpha) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void transMult(double[] x, double[] y) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void compact() {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void multAdd(double alpha, double[] x, double[] y) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void mult(double[] x, double[] y) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void multAdd(double[] x, double[] y) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public SymMatrix subMatrix(int[] rowcols) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void setDiag(double alpha) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void dotDivOuterProd(Vector x) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void addOuterProd(double[] x) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public double sumDotMultOuterProd(double[] x) {
        throw new MatricksException("Not implemented");
    }
}

