/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.mtj;

import java.util.Iterator;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.VectorEntry;
import org.genemania.engine.core.MatrixUtils;
import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.Vector;
import org.genemania.engine.matricks.VectorCursor;

public class DenseDoubleVector
implements Vector {
    no.uib.cipr.matrix.Vector v;

    public DenseDoubleVector(int size) {
        this.v = new DenseVector(size);
    }

    public DenseDoubleVector(no.uib.cipr.matrix.Vector v) {
        this.v = v;
    }

    @Override
    public int[] findIndexesOf(double x) {
        return MatrixUtils.find(this.v, x);
    }

    @Override
    public double elementSum() {
        return MatrixUtils.sum(this.v);
    }

    @Override
    public void add(Vector y) {
        throw new RuntimeException("not implemented");
    }

    public void add(DenseDoubleVector y) {
        this.v.add(y.v);
    }

    @Override
    public void add(double a, Vector y) {
        throw new RuntimeException("not implemented");
    }

    public void add(double a, DenseDoubleVector y) {
        this.v.add(a, y.v);
    }

    @Override
    public VectorCursor cursor() {
        return new DenseDoubleVectorCursor();
    }

    @Override
    public void setAll(double x) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setEqual(Vector b) {
        if (!(b instanceof no.uib.cipr.matrix.Vector)) {
            throw new RuntimeException("not implemented for type: " + b.getClass().getName());
        }
        no.uib.cipr.matrix.Vector bb = (no.uib.cipr.matrix.Vector)b;
        this.setEqual(bb);
    }

    public void setEqual(no.uib.cipr.matrix.Vector b) {
        this.v.set(b);
    }

    @Override
    public void scale(double x) {
        this.v.scale(x);
    }

    @Override
    public void set(int index, double a) {
        this.v.set(index, a);
    }

    @Override
    public double get(int index) {
        return this.v.get(index);
    }

    @Override
    public int getSize() {
        return this.v.size();
    }

    @Override
    public int countMatches(double x) {
        return MatrixUtils.countMatches(this.v, x);
    }

    @Override
    public void findReplace(double oldValue, double newValue) {
        MatrixUtils.setMatches(this.v, oldValue, newValue);
    }

    @Override
    public double dot(Vector b) throws MatricksException {
        if (b instanceof DenseDoubleVector) {
            DenseDoubleVector bb = (DenseDoubleVector)b;
            return this.dot(bb);
        }
        throw new RuntimeException("unsupported type: " + b.getClass().getName());
    }

    public double dot(DenseDoubleVector b) throws MatricksException {
        return this.v.dot(b.v);
    }

    private class DenseDoubleVectorCursor
    implements VectorCursor {
        Iterator<VectorEntry> iter;
        VectorEntry e;

        private DenseDoubleVectorCursor() {
            this.iter = DenseDoubleVector.this.v.iterator();
        }

        @Override
        public boolean next() {
            if (this.iter.hasNext()) {
                this.e = this.iter.next();
                return true;
            }
            return false;
        }

        @Override
        public int index() {
            return this.e.index();
        }

        @Override
        public double val() {
            return this.e.get();
        }

        @Override
        public void set(double val) {
            this.e.set(val);
        }
    }
}

