/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.summary;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.genemania.domain.Gene;
import org.genemania.domain.GeneNamingSource;
import org.genemania.domain.Node;
import org.genemania.domain.Organism;
import org.genemania.engine.apps.support.DataConnector;
import org.genemania.engine.summary.PreferredNames;
import org.genemania.engine.summary.Reporter;
import org.genemania.engine.summary.ReporterFactory;
import org.genemania.engine.summary.Summarizer;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.mediator.NodeCursor;

public class IdentifiersDumper
implements Summarizer {
    private static Logger logger = Logger.getLogger(IdentifiersDumper.class);
    Organism organism;
    DataConnector dataConnector;
    PreferredNames preferredNames;

    public IdentifiersDumper(Organism organism, DataConnector dataConnector, PreferredNames preferredNames) {
        this.organism = organism;
        this.dataConnector = dataConnector;
        this.preferredNames = preferredNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void summarize(ReporterFactory reporterFactory) throws Exception {
        logger.info((Object)String.format("summarizing identifiers for organism %d - %s", this.organism.getId(), this.organism.getName()));
        Reporter reporter = reporterFactory.getReporter("identifier_mappings");
        try {
            this.count(reporter);
        }
        finally {
            reporter.close();
        }
    }

    void count(Reporter reporter) throws ApplicationException, DataStoreException {
        NodeCursor cursor = this.dataConnector.getOrganismMediator().createNodeCursor(this.organism.getId());
        reporter.init("Preferred_Name", "Name", "Source");
        while (cursor.next()) {
            long id = cursor.getId();
            Node node = this.dataConnector.getNodeMediator().getNode(id, this.organism.getId());
            Collection genes = node.getGenes();
            for (Gene gene : genes) {
                GeneNamingSource namingSource = gene.getNamingSource();
                String sourceName = namingSource.getName();
                String preferred = this.preferredNames.getName(id);
                reporter.write(preferred, gene.getSymbol(), sourceName);
            }
        }
    }

    @Override
    public void setUp() throws Exception {
    }

    @Override
    public void tearDown() throws Exception {
    }
}

