/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.summary;

import org.genemania.engine.core.data.Network;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.Vector;

public class NetworkStats {
    Network network;
    int numEdges;
    int numInteractingNodes;
    Vector nodeDegrees;
    int[] nodeInteractorsCount;

    public NetworkStats(Network network) {
        this.network = network;
        this.computeStats();
    }

    void computeStats() {
        this.computeDegree();
        this.countInteractors();
        this.countEdges();
    }

    void computeDegree() {
        this.nodeDegrees = this.network.getData().columnSums();
    }

    void countInteractors() {
        this.numInteractingNodes = 0;
        for (int i = 0; i < this.nodeDegrees.getSize(); ++i) {
            if (!(this.nodeDegrees.get(i) > 0.0)) continue;
            ++this.numInteractingNodes;
        }
    }

    void countEdges() {
        MatrixCursor cursor = this.network.getData().cursor();
        this.numEdges = 0;
        int numNodes = this.network.getData().numCols();
        this.nodeInteractorsCount = new int[numNodes];
        while (cursor.next()) {
            if (cursor.val() == 0.0 || cursor.col() >= cursor.row()) continue;
            int n = cursor.col();
            this.nodeInteractorsCount[n] = this.nodeInteractorsCount[n] + 1;
            int n2 = cursor.row();
            this.nodeInteractorsCount[n2] = this.nodeInteractorsCount[n2] + 1;
            ++this.numEdges;
        }
    }

    public Vector getNodeDegrees() {
        return this.nodeDegrees;
    }

    public int getNumEdges() {
        return this.numEdges;
    }

    public int getNumInteractingNodes() {
        return this.numInteractingNodes;
    }

    public int[] getNodeInteractorsCount() {
        return this.nodeInteractorsCount;
    }
}

