/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.summary;

import java.text.DecimalFormat;
import java.text.Normalizer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Organism;
import org.genemania.engine.apps.support.DataConnector;
import org.genemania.engine.core.data.Network;
import org.genemania.engine.core.data.NodeIds;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.engine.summary.PreferredNames;
import org.genemania.engine.summary.Reporter;
import org.genemania.engine.summary.ReporterFactory;
import org.genemania.engine.summary.Summarizer;
import org.genemania.exception.ApplicationException;

public class NetworksDumper
implements Summarizer {
    private static Logger logger = Logger.getLogger(NetworksDumper.class);
    Organism organism;
    DataConnector dataConnector;
    PreferredNames preferredNames;
    Map<String, Integer> countsByGroup;
    int uniqueNetworks;
    ReporterFactory reporterFactory;
    Reporter networkReporter;
    Reporter interactionReporter;

    public NetworksDumper(Organism organism, DataConnector dataConnector, PreferredNames preferredNames) throws Exception {
        this.organism = organism;
        this.dataConnector = dataConnector;
        this.preferredNames = preferredNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void summarize(ReporterFactory reporterFactory) throws Exception {
        logger.info((Object)String.format("summarizing networks for organism %d - %s", this.organism.getId(), this.organism.getName()));
        this.reporterFactory = reporterFactory;
        this.networkReporter = reporterFactory.getReporter("networks");
        try {
            this.networkReporter.init("File_Name", "Network_Group_Name", "Network_Name", "Source", "Pubmed_ID");
            Collection groups = this.organism.getInteractionNetworkGroups();
            for (InteractionNetworkGroup group : groups) {
                this.summerizeGroup(group);
            }
        }
        finally {
            this.networkReporter.close();
        }
    }

    void summerizeGroup(InteractionNetworkGroup group) throws ApplicationException {
        Collection networks = group.getInteractionNetworks();
        String groupName = group.getName();
        int numNetworks = networks.size();
        this.countsByGroup.put(groupName, numNetworks);
        for (InteractionNetwork network : networks) {
            this.reportNetwork(network, group);
        }
    }

    public String makeFileName(InteractionNetwork network, InteractionNetworkGroup group) {
        String name = group.getName() + "." + network.getName();
        name = name.replace(' ', '_');
        name = NetworksDumper.normalizeString(name);
        return name;
    }

    public static String normalizeString(String s) {
        s = Normalizer.normalize(s, Normalizer.Form.NFD);
        s = s.replaceAll("[^\\p{ASCII}]", "");
        return s;
    }

    void reportNetwork(InteractionNetwork network, InteractionNetworkGroup group) throws ApplicationException {
        String name = this.makeFileName(network, group);
        long numEdges = 0L;
        long expectedNumInteractions = 0L;
        DecimalFormat formatter = new DecimalFormat("0.#E0");
        NodeIds nodeIds = this.dataConnector.getCache().getNodeIds(this.organism.getId());
        Network networkData = this.dataConnector.getCache().getNetwork("CORE", this.organism.getId(), network.getId());
        name = NetworksDumper.dumpNetwork(networkData.getData(), this.reporterFactory, name, this.preferredNames, nodeIds);
        this.networkReporter.write(name, group.getName(), NetworksDumper.normalizeString(network.getName()), network.getMetadata().getSource(), network.getMetadata().getPubmedId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dumpNetwork(SymMatrix nw, ReporterFactory reporterFactory, String reportName, PreferredNames preferredNames, NodeIds nodeIds) throws ApplicationException {
        DecimalFormat formatter = new DecimalFormat("0.#E0");
        Reporter reporter = reporterFactory.getReporter(reportName);
        reportName = reporter.getReportName();
        try {
            reporter.init("Gene_A", "Gene_B", "Weight");
            MatrixCursor cursor = nw.cursor();
            while (cursor.next()) {
                if (cursor.val() == 0.0 || cursor.col() >= cursor.row()) continue;
                long nodeIdA = nodeIds.getIdForIndex(cursor.col());
                long nodeIdB = nodeIds.getIdForIndex(cursor.row());
                String symbolA = preferredNames.getName(nodeIdA);
                String symbolB = preferredNames.getName(nodeIdB);
                double weight = cursor.val();
                reporter.write(symbolA, symbolB, formatter.format(weight));
            }
        }
        finally {
            reporter.close();
        }
        return reportName;
    }

    @Override
    public void setUp() throws Exception {
        this.countsByGroup = new HashMap<String, Integer>();
        this.uniqueNetworks = 0;
    }

    @Override
    public void tearDown() throws Exception {
    }
}

