/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.summary;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Organism;
import org.genemania.engine.Constants;
import org.genemania.engine.apps.AbstractEngineApp;
import org.genemania.engine.apps.support.DataConnector;
import org.genemania.engine.config.Config;
import org.genemania.engine.core.data.CombinedNetwork;
import org.genemania.engine.core.data.NodeIds;
import org.genemania.engine.core.integration.Feature;
import org.genemania.engine.core.integration.FeatureWeightMap;
import org.genemania.engine.core.integration.INetworkWeightCalculator;
import org.genemania.engine.core.integration.NetworkWeightCalculatorFactory;
import org.genemania.engine.core.integration.calculators.AbstractNetworkWeightCalculator;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.engine.summary.NetworksDumper;
import org.genemania.engine.summary.PreferredNames;
import org.genemania.engine.summary.Reporter;
import org.genemania.engine.summary.ReporterFactory;
import org.genemania.engine.summary.Summarizer;
import org.genemania.exception.ApplicationException;
import org.genemania.util.NullProgressReporter;

public class PrecombinedDumper
implements Summarizer {
    Organism organism;
    DataConnector dataConnector;
    PreferredNames preferredNames;
    String[] combiningNetworkFilter;
    String combinedNetworksFilter;
    HashMap<Long, InteractionNetworkGroup> nid2gid = null;

    public PrecombinedDumper(Organism organism, DataConnector dataConnector, String combinedNetworksFilter, PreferredNames preferredNames) {
        this.organism = organism;
        this.dataConnector = dataConnector;
        this.combinedNetworksFilter = combinedNetworksFilter;
        this.preferredNames = preferredNames;
    }

    @Override
    public void setUp() throws Exception {
    }

    @Override
    public void summarize(ReporterFactory reporterFactory) throws Exception {
        if ("BP.DEFAULT".equalsIgnoreCase(this.combinedNetworksFilter)) {
            this.dump("BP", "DEFAULT", reporterFactory);
        } else if ("ALL".equalsIgnoreCase(this.combinedNetworksFilter)) {
            this.dump("BP", "DEFAULT", reporterFactory);
            this.dump("BP", "ALL", reporterFactory);
            this.dump("CC", "DEFAULT", reporterFactory);
            this.dump("CC", "ALL", reporterFactory);
            this.dump("MF", "DEFAULT", reporterFactory);
            this.dump("MF", "ALL", reporterFactory);
            this.dump("AVERAGE", "DEFAULT", reporterFactory);
            this.dump("AVERAGE", "ALL", reporterFactory);
            this.dump("AVERAGE_CATEGORY", "DEFAULT", reporterFactory);
            this.dump("AVERAGE_CATEGORY", "ALL", reporterFactory);
        } else {
            throw new ApplicationException("unexpected value for combinedNetworksFilter: " + this.combinedNetworksFilter);
        }
    }

    void dump(String method, String networks, ReporterFactory reporterFactory) throws Exception {
        String key = this.getDefaultNetworkKey(this.organism, networks, method);
        CombinedNetwork cnw = this.dataConnector.getCache().getCombinedNetwork("CORE", this.organism.getId(), key);
        FeatureWeightMap weights = cnw.getFeatureWeightMap();
        SymMatrix nw = cnw.getData();
        String reportName = PrecombinedDumper.makeCombinedWeightsName(method, networks);
        this.reportWeights(weights, reporterFactory, reportName);
        NodeIds nodeIds = this.dataConnector.getCache().getNodeIds(this.organism.getId());
        reportName = PrecombinedDumper.makeCombinedNetworkName(method, networks);
        NetworksDumper.dumpNetwork(nw, reporterFactory, reportName, this.preferredNames, nodeIds);
    }

    static String makeCombinedNetworkName(String method, String networks) {
        return String.format("COMBINED.%s_NETWORKS.%s_COMBINING", networks, method);
    }

    static String makeCombinedWeightsName(String method, String networks) {
        return String.format("COMBINATION_WEIGHTS.%s_NETWORKS.%s_COMBINING", networks, method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportWeights(FeatureWeightMap weights, ReporterFactory reporterFactory, String reportName) throws Exception {
        Reporter weightReporter = reporterFactory.getReporter(reportName);
        DecimalFormat formatter = new DecimalFormat("0.#E0");
        try {
            weightReporter.init("group", "network", "weight");
            for (Feature feature : weights.keySet()) {
                if (feature.getType() != Constants.NetworkType.SPARSE_MATRIX) {
                    throw new Exception("don't know how to report features of type " + feature.getType().name());
                }
                double weight = (Double)weights.get(feature);
                InteractionNetwork network = this.dataConnector.getNetworkMediator().getNetwork(feature.getId());
                String group = this.getGroupForNetworkId(feature.getId()).getName();
                String name = network.getName();
                name = NetworksDumper.normalizeString(name);
                weightReporter.write(group, name, formatter.format(weight));
            }
        }
        finally {
            weightReporter.close();
        }
    }

    void initnid2gid() {
        this.nid2gid = new HashMap();
        Collection groups = this.organism.getInteractionNetworkGroups();
        for (InteractionNetworkGroup group : groups) {
            Collection networks = group.getInteractionNetworks();
            for (InteractionNetwork n : networks) {
                this.nid2gid.put(n.getId(), group);
            }
        }
    }

    InteractionNetworkGroup getGroupForNetworkId(long networkId) {
        if (this.nid2gid == null) {
            this.initnid2gid();
        }
        return this.nid2gid.get(networkId);
    }

    String getDefaultNetworkKey(Organism organism, String networkSelection, String methodName) throws Exception {
        Collection<Collection<Long>> networkIds = null;
        if (networkSelection.equals("DEFAULT")) {
            networkIds = AbstractEngineApp.getDefaultNetworks(organism);
        } else if (networkSelection.equals("ALL")) {
            networkIds = AbstractEngineApp.getAllNetworks(organism);
        } else {
            throw new Exception("unexpected network selection: " + networkSelection);
        }
        Constants.CombiningMethod method = Constants.getCombiningMethod(methodName);
        INetworkWeightCalculator calculator = NetworkWeightCalculatorFactory.getCalculator("CORE", this.dataConnector.getCache(), networkIds, null, organism.getId(), null, Config.instance().getAttributeEnrichmentMaxSize(), method, NullProgressReporter.instance());
        String hash = AbstractNetworkWeightCalculator.hashString(calculator.getParameterKey());
        return hash;
    }

    @Override
    public void tearDown() throws Exception {
    }
}

