/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.validation;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;

public class ResultWriter {
    String outputFilename;
    char sepChar;
    private PrintWriter writer;

    public ResultWriter(String outputFilename, char sepChar, boolean append) throws IOException {
        this.outputFilename = outputFilename;
        this.sepChar = sepChar;
        this.writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(outputFilename, append)));
    }

    public ResultWriter(String outputFilename) throws IOException {
        this(outputFilename, '\t', false);
    }

    public void close() {
        this.writer.close();
    }

    public void writeOutput(String msg) {
        this.writer.println(msg);
    }

    public void write(String[] fields) {
        StringBuilder msg = new StringBuilder(fields[0]);
        for (int i = 1; i < fields.length; ++i) {
            msg.append(this.sepChar + fields[i]);
        }
        this.writeOutput(msg.toString());
    }

    public void write(List<String> fields) {
        StringBuilder msg = new StringBuilder(fields.get(0));
        for (int i = 1; i < fields.size(); ++i) {
            msg.append(this.sepChar + fields.get(i));
        }
        this.writeOutput(msg.toString());
    }

    public void writeComment(String comment) {
        this.writer.print("# " + comment);
    }

    public void flush() {
        this.writer.flush();
    }

    public static ResultWriter getNullWriter() {
        return new NullResultWriter();
    }

    private ResultWriter() {
    }

    private static class NullResultWriter
    extends ResultWriter {
        public NullResultWriter() {
        }

        public NullResultWriter(String outputFilename, char sepChar) {
        }

        @Override
        public void writeOutput(String msg) {
        }

        @Override
        public void close() {
        }
    }
}

