/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.component.field.editable;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.ut.biolab.medsavant.component.field.editable.EditableFieldValidator;
import org.ut.biolab.medsavant.component.field.editable.FieldCommittedListener;
import org.ut.biolab.medsavant.component.field.editable.FieldEditedListener;

public abstract class EditableField<T>
extends JPanel {
    protected Color editColor = new Color(26, 143, 240);
    protected Color nullColor = new Color(150, 150, 150);
    private boolean autonomousEditingEnabled = true;
    boolean editing = false;
    private String tag;
    private EditableFieldValidator<T> validator;
    private final List<FieldCommittedListener> commitListeners;
    private final List<FieldEditedListener> editListeners;

    public EditableField() {
        this.setOpaque(false);
        this.commitListeners = new ArrayList<FieldCommittedListener>();
        this.editListeners = new ArrayList<FieldEditedListener>();
    }

    public void setEditing(boolean isEditing) {
        this.editing = isEditing;
        this.updateUIForEditingState(isEditing);
        this.updateUI();
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setAutonomousEditingEnabled(boolean b) {
        this.autonomousEditingEnabled = b;
        this.updateUIForAutonomousEditingState(b);
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    protected abstract void updateUIForEditingState(boolean var1);

    protected abstract void updateUIForAutonomousEditingState(boolean var1);

    public abstract void setValue(T var1);

    public abstract T getValue();

    public abstract T getValueFromEditor();

    public boolean isAutonomousEditingEnabled() {
        return this.autonomousEditingEnabled;
    }

    public boolean setValueFromEditor() {
        T value = this.getValueFromEditor();
        if (this.validateValue(value)) {
            this.setValue(value);
            this.fireFieldCommittedEvent();
            return true;
        }
        return false;
    }

    public boolean validateCurrentValue() {
        return this.validator == null || this.validator.validate(this.getValue());
    }

    public boolean validateValue(T value) {
        return this.validator == null || this.validator.validate(value);
    }

    public void setValidator(EditableFieldValidator<T> validator) {
        this.validator = validator;
    }

    public EditableFieldValidator<T> getValidator() {
        return this.validator;
    }

    private void fireFieldCommittedEvent() {
        for (FieldCommittedListener l : this.commitListeners) {
            l.handleCommitEvent(this);
        }
    }

    protected void fireFieldEditedEvent() {
        for (FieldEditedListener l : this.editListeners) {
            l.handleEditEvent(this);
        }
    }

    public void addFieldComittedListener(FieldCommittedListener l) {
        this.commitListeners.add(l);
    }

    public void removeFieldCommittedListener(FieldCommittedListener l) {
        this.commitListeners.remove(l);
    }

    public void addFieldEditedListener(FieldEditedListener l) {
        this.editListeners.add(l);
    }

    public void removeFieldCommittedListener(FieldEditedListener l) {
        this.editListeners.remove(l);
    }

    public static JButton createSegmentButton(String style, String position) {
        JButton button = new JButton();
        button.setFocusable(false);
        button.putClientProperty("JButton.buttonType", style);
        button.putClientProperty("JButton.segmentPosition", position);
        return button;
    }

    protected static void removeMouseListeners(JComponent c) {
        for (MouseListener ml : c.getMouseListeners()) {
            c.removeMouseListener(ml);
        }
    }

    protected static void addEditOnClickListener(final EditableField field, JComponent c) {
        c.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                field.setEditing(true);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    public static JButton getIconButton(String path, String failureText) {
        try {
            ImageIcon i = new ImageIcon(ImageIO.read(ClassLoader.getSystemResource(path)));
            JButton b = new JButton(i);
            b.setBorder(null);
            b.setFocusable(false);
            b.setBorderPainted(false);
            return b;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return new JButton(failureText);
        }
    }

    private FocusListener getEditOnFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!EditableField.this.isEditing() && EditableField.this.isAutonomousEditingEnabled()) {
                    EditableField.this.setEditing(true);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
    }
}

