/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.component.field.validator;

import org.ut.biolab.medsavant.component.field.editable.EditableFieldValidator;

public class PositiveNumberValidator
extends EditableFieldValidator<String> {
    private String name;

    public PositiveNumberValidator() {
        this("value");
    }

    public PositiveNumberValidator(String name) {
        this.name = name;
    }

    @Override
    public boolean validate(String value) {
        try {
            return value != null && !value.isEmpty() && Integer.parseInt(value) >= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public String getDescriptionOfValidValue() {
        return "Invalid " + this.name;
    }
}

